/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.command;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.blocks.reactor.ProcessExplosion;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class CommandKaboom {
    private static ProcessExplosion explosionProcess = null;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"de_kaboom").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)10, (int)50000)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> CommandKaboom.calculate((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vec3i)BlockPosArgument.m_174395_((CommandContext)ctx, (String)"position"), false, true))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"effect_only").executes(ctx -> CommandKaboom.effect((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vec3i)BlockPosArgument.m_174395_((CommandContext)ctx, (String)"position"), false))).then(Commands.m_82127_((String)"flash").executes(ctx -> CommandKaboom.effect((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vec3i)BlockPosArgument.m_174395_((CommandContext)ctx, (String)"position"), true))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"prime").executes(ctx -> CommandKaboom.calculate((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vec3i)BlockPosArgument.m_174395_((CommandContext)ctx, (String)"position"), true, true))).then(Commands.m_82127_((String)"no_effect").executes(ctx -> CommandKaboom.calculate((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vec3i)BlockPosArgument.m_174395_((CommandContext)ctx, (String)"position"), true, false))))).then(Commands.m_82127_((String)"no_effect").executes(ctx -> CommandKaboom.calculate((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vec3i)BlockPosArgument.m_174395_((CommandContext)ctx, (String)"position"), false, false)))))).then(Commands.m_82127_((String)"detonate").executes(ctx -> CommandKaboom.detonate()))).then(Commands.m_82127_((String)"abort").executes(ctx -> CommandKaboom.abort((CommandContext<CommandSourceStack>)ctx))));
    }

    private static int calculate(CommandSourceStack source, int radius, Vec3i pos, boolean prime, boolean effect) {
        if (explosionProcess != null && !explosionProcess.isDead()) {
            source.m_81352_((Component)new TextComponent("Explosion already in progress"));
            return 1;
        }
        LogHelper.dev("calculate Rad: " + radius + ", Pos: " + pos + ", Prime: " + prime);
        explosionProcess = new ProcessExplosion(new BlockPos(pos), radius, source.m_81372_(), prime ? -1 : 0);
        CommandKaboom.explosionProcess.enableEffect = effect;
        CommandKaboom.explosionProcess.progressMon = progress -> {
            if (TimeKeeper.getServerTick() % 20 == 0) {
                source.m_81354_((Component)new TextComponent("Calculating: " + Math.round(progress * 100.0) + "%"), true);
            }
        };
        ProcessHandler.addProcess((IProcess)explosionProcess);
        return 0;
    }

    private static int effect(CommandSourceStack source, int radius, Vec3i pos, boolean flash) {
        if (flash) {
            ClientEventHandler.triggerExplosionEffect(new BlockPos(pos), false);
        } else {
            DraconicNetwork.sendExplosionEffect((ResourceKey<Level>)source.m_81372_().m_46472_(), new BlockPos(pos), radius * 4, true);
        }
        return 0;
    }

    private static int detonate() {
        WorldEntityHandler.getWorldEntities().forEach(WorldEntity::removeEntity);
        if (explosionProcess != null && explosionProcess.isCalculationComplete()) {
            explosionProcess.detonate();
            explosionProcess = null;
            return 0;
        }
        return 1;
    }

    private static int abort(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        if (explosionProcess != null) {
            CommandKaboom.explosionProcess.isDead = true;
            explosionProcess = null;
            return 0;
        }
        return 1;
    }

    private static int relight(CommandSourceStack source) {
        BlockPos pos = new BlockPos(source.m_81371_());
        ServerLevel world = source.m_81372_();
        while (world.m_46859_(pos)) {
            pos = pos.m_7495_();
        }
        BlockPos.m_121990_((BlockPos)pos.m_142082_(-10, -10, -10), (BlockPos)pos.m_142082_(10, 10, 10)).forEach(e -> {
            world.m_5518_().m_142202_(e);
            LevelChunk chunk = world.m_46745_(e);
        });
        return 0;
    }
}

