/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.sound;

import codechicken.lib.vec.Vector3;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class SimpleSoundImpl
extends SimpleSoundInstance
implements TickableSoundInstance {
    private Supplier<Float> pitchSupplier;
    private Supplier<Float> volumeSupplier;
    private Supplier<Boolean> stoppedSupplier;
    private Supplier<Vector3> posSupplier;
    private boolean stop = false;

    public static SimpleSoundImpl create(SoundEvent sound, SoundSource source) {
        return new SimpleSoundImpl(sound, source);
    }

    private SimpleSoundImpl(SoundEvent sound, SoundSource source) {
        super(sound, source, 1.0f, 1.0f, 0.0, 0.0, 0.0);
    }

    public SimpleSoundImpl setPitch(float pitch) {
        this.f_119574_ = pitch;
        return this;
    }

    public SimpleSoundImpl setPitchSupplier(Supplier<Float> pitchSupplier) {
        this.pitchSupplier = pitchSupplier;
        return this;
    }

    public SimpleSoundImpl setVolume(float volume) {
        this.f_119573_ = volume;
        return this;
    }

    public SimpleSoundImpl setVolumeSupplier(Supplier<Float> volumeSupplier) {
        this.volumeSupplier = volumeSupplier;
        return this;
    }

    public SimpleSoundImpl setPos(double x, double y, double z) {
        this.f_119575_ = x;
        this.f_119576_ = y;
        this.f_119577_ = z;
        return this;
    }

    public SimpleSoundImpl setPos(Vector3 pos) {
        return this.setPos(pos.x, pos.y, pos.z);
    }

    public SimpleSoundImpl setPos(BlockPos pos) {
        return this.setPos(Vector3.fromBlockPosCenter((BlockPos)pos));
    }

    public SimpleSoundImpl setPos(Entity pos) {
        return this.setPos(Vector3.fromEntityCenter((Entity)pos));
    }

    public SimpleSoundImpl setPosSupplier(Supplier<Vector3> posSupplier) {
        this.posSupplier = posSupplier;
        return this;
    }

    public SimpleSoundImpl setStoppedSupplier(Supplier<Boolean> stoppedSupplier) {
        this.stoppedSupplier = stoppedSupplier;
        return this;
    }

    public SimpleSoundImpl loop() {
        this.f_119578_ = true;
        return this;
    }

    public SimpleSoundImpl play(Minecraft minecraft) {
        minecraft.m_91106_().m_120367_((SoundInstance)this);
        return this;
    }

    public void stop() {
        this.stop = true;
    }

    public boolean m_7801_() {
        return this.stop || this.stoppedSupplier != null && this.stoppedSupplier.get() != false;
    }

    public void m_7788_() {
        if (this.pitchSupplier != null) {
            this.setPitch(this.pitchSupplier.get().floatValue());
        }
        if (this.volumeSupplier != null) {
            this.setVolume(this.volumeSupplier.get().floatValue());
        }
        if (this.posSupplier != null) {
            this.setPos(this.posSupplier.get());
        }
    }
}

