/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.draconicevolution.blocks.PlacedItem;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePlacedItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderTilePlacedItem
implements BlockEntityRenderer<TilePlacedItem> {
    public RenderTilePlacedItem(BlockEntityRendererProvider.Context context) {
    }

    public void render(TilePlacedItem tile, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.m_91087_();
        List<ItemStack> stackList = tile.getStacksInOrder();
        float scale = stackList.size() == 1 && tile.toolMode.get() ? 0.875f : 0.4375f;
        mStack.m_85836_();
        mStack.m_85837_(0.5, 0.5, 0.5);
        Direction direction = (Direction)tile.m_58900_().m_61143_((Property)PlacedItem.FACING);
        this.rotateToSide(direction, mStack);
        int posLong = (int)tile.m_58899_().m_121878_();
        for (int i = 0; i < stackList.size(); ++i) {
            ItemStack stack = stackList.get(i);
            mStack.m_85836_();
            if (stack.m_41720_() instanceof BlockItem) {
                mStack.m_85837_(PlacedItem.getXOffset(i, stackList.size()), -0.3125, PlacedItem.getZOffset(i, stackList.size()));
                mStack.m_85845_(new Quaternion(0.0f, (float)tile.rotation[i].get() * -22.5f, 0.0f, true));
                if (direction.m_122434_() != Direction.Axis.Y) {
                    mStack.m_85845_(new Quaternion(90.0f, 0.0f, 0.0f, true));
                }
                mStack.m_85841_(0.75f, 0.75f, 0.75f);
            } else {
                mStack.m_85837_(PlacedItem.getXOffset(i, stackList.size()), -0.5 + 0.034375 * (double)scale, PlacedItem.getZOffset(i, stackList.size()));
                mStack.m_85845_(new Quaternion(0.0f, (float)tile.rotation[i].get() * -22.5f, 0.0f, true));
                mStack.m_85845_(new Quaternion(90.0f, 0.0f, 0.0f, true));
                mStack.m_85841_(scale, scale, scale);
            }
            mc.m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, packedLight, packedOverlay, mStack, getter, posLong + i);
            mStack.m_85849_();
            mStack.m_85837_(0.0, (double)5.0E-5f, 0.0);
        }
        mStack.m_85849_();
    }

    private void rotateToSide(Direction direction, PoseStack mStack) {
        switch (direction) {
            case DOWN: {
                mStack.m_85845_(new Quaternion(180.0f, 0.0f, 0.0f, true));
                break;
            }
            case NORTH: {
                mStack.m_85845_(new Quaternion(-90.0f, 0.0f, 0.0f, true));
                break;
            }
            case SOUTH: {
                mStack.m_85845_(new Quaternion(-90.0f, 0.0f, 180.0f, true));
                break;
            }
            case WEST: {
                mStack.m_85845_(new Quaternion(-90.0f, 0.0f, 90.0f, true));
                break;
            }
            case EAST: {
                mStack.m_85845_(new Quaternion(-90.0f, 0.0f, -90.0f, true));
            }
        }
    }
}

