/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.blocks.machines.Grinder;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGrinder;
import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import java.util.OptionalDouble;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderTileGrinder
implements BlockEntityRenderer<TileGrinder> {
    private static final double[] ROTATION_MAP = new double[]{0.0, 180.0, 90.0, -90.0};
    private static final RenderType swordType = RenderType.m_110446_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/grinder.png"));
    private static final RenderType fanType = RenderType.m_110446_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/parts/machine_fan.png"));
    private static final RenderType aoeOutlineType = RenderType.m_173209_((String)"aoe", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173095_).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110687_(RenderStateShard.f_110115_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(4.0))).m_110691_(false));
    private static RenderType aoeSolidType = RenderType.m_173209_((String)"aoe_solid", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
    private final CCModel swordModel;
    private final CCModel fanModel;

    public RenderTileGrinder(BlockEntityRendererProvider.Context context) {
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/grinder/grinder_fan.obj")).quads().ignoreMtl().parse();
        this.fanModel = CCModel.combine(map.values());
        map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/grinder/grinder_sword.obj")).quads().ignoreMtl().parse();
        this.swordModel = CCModel.combine(map.values());
        this.swordModel.computeNormals();
        this.swordModel.apply((Transformation)new Scale(-0.0625));
        this.swordModel.apply((Transformation)new Rotation(3.1415926535897403, 0.0, 0.0, 1.0));
        this.swordModel.apply((Transformation)new Rotation(1.5707963267948701, 0.0, 1.0, 0.0));
    }

    public void render(TileGrinder tile, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        BlockState state = tile.m_58904_().m_8055_(tile.m_58899_());
        if (state.m_60734_() != DEContent.grinder) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)Grinder.FACING);
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.bind(swordType, getter);
        ccrs.r = new TransformingVertexConsumer(ccrs.r, (Transformation)mat);
        Vector3 tilePos = Vector3.fromTileCenter((BlockEntity)tile);
        Vector3 vecA = tile.targetA == null ? null : this.getEntityMovingVec(tile.targetA, partialTicks);
        Vector3 vecB = tile.targetB == null ? null : this.getEntityMovingVec(tile.targetB, partialTicks);
        this.renderSword(ccrs, facing, 0.34, tilePos, vecA, Math.min(tile.animA + partialTicks * tile.getAnimSpeed(), 1.0f), partialTicks);
        this.renderSword(ccrs, facing, -0.34, tilePos, vecB, Math.min(tile.animB + partialTicks * tile.getAnimSpeed(), 1.0f), partialTicks);
        ccrs.bind(fanType, getter);
        Matrix4 fanMat = mat.copy();
        fanMat.translate(Vector3.CENTER);
        fanMat.apply((Transformation)new Rotation((double)facing.m_122435_() * -0.017453292519943, 0.0, 1.0, 0.0));
        fanMat.apply((Transformation)new Scale(-0.0625));
        fanMat.apply((Transformation)new Rotation((double)(tile.fanRotation + tile.fanSpeed * partialTicks), 0.0, 0.0, 1.0));
        this.fanModel.render(ccrs, new IVertexOperation[]{fanMat});
        if ((double)tile.aoeDisplay > 0.51) {
            tile.validateKillZone(true);
            TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(aoeOutlineType), (Transformation)mat);
            Cuboid6 box = new Cuboid6(tile.killZone.m_82338_(Vector3.fromTile((BlockEntity)tile).multiply(-1.0).pos()).m_82406_(0.01).m_82406_((double)((float)tile.aoe.get() - tile.aoeDisplay)));
            RenderUtils.bufferCuboidOutline((VertexConsumer)builder, (Cuboid6)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            builder = new TransformingVertexConsumer(getter.m_6299_(aoeSolidType), (Transformation)mat);
            RenderUtils.bufferCuboidSolid((VertexConsumer)builder, (Cuboid6)box, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            com.brandon3055.brandonscore.client.render.RenderUtils.endBatch((MultiBufferSource)getter);
        }
    }

    private void renderSword(CCRenderState ccrs, Direction tileFacing, double sideOffset, Vector3 tilePos, Vector3 targetPos, double attackAnimTime, float partialTicks) {
        double yoyo = (attackAnimTime *= 2.0) > 1.0 ? 1.0 - (attackAnimTime - 1.0) : attackAnimTime;
        double sideAngle = ROTATION_MAP[tileFacing.m_122411_() - 2] * 0.017453292519943;
        Transformation rotation = new Rotation(yoyo * Math.PI * -2.8, 1.0, 0.0, 0.0).at(new Vector3(0.0, -0.2, 0.0));
        Vector3 handPos = new Vector3(0.4975 + (sideOffset *= 1.0 - yoyo), 0.5, 0.125 + yoyo * 0.375);
        handPos.apply(new Rotation(sideAngle, 0.0, 1.0, 0.0).at(new Vector3(0.5, 0.0, 0.5)));
        Translation translation = new Translation(handPos);
        TransformationList transforms = rotation.with((Transformation)translation);
        if (targetPos == null) {
            transforms = transforms.with(new Rotation(sideAngle, 0.0, 1.0, 0.0).at(handPos));
        } else {
            Vector3 targetVec = targetPos.copy().subtract(tilePos);
            double angle = Math.atan2(targetVec.x, targetVec.z) + Math.PI;
            transforms = transforms.with(new Rotation(angle, 0.0, 1.0, 0.0).at(handPos));
            transforms = transforms.with((Transformation)new Translation(targetVec.multiply(yoyo)));
        }
        this.swordModel.render(ccrs, new IVertexOperation[]{transforms});
    }

    private Vector3 getEntityMovingVec(Entity entity, float partialTicks) {
        Vector3 vec = new Vector3(entity.f_19790_, entity.f_19791_ - entity.m_6049_() + (double)(entity.m_20206_() / 2.0f), entity.f_19792_);
        vec.add(Vector3.fromEntityCenter((Entity)entity).subtract(entity.f_19790_, entity.f_19791_ - entity.m_6049_() + (double)(entity.m_20206_() / 2.0f), entity.f_19792_).multiply((double)partialTicks));
        return vec;
    }
}

