/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Quaternion;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class RenderEnergyCoreStabilizer
implements BlockEntityRenderer<TileEnergyCoreStabilizer> {
    private static final RenderType MODEL_TYPE = RenderType.m_110446_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/energy_core/stabilizer_large.png"));
    private static final RenderType MODEL_TYPE_ACTIVE = RenderType.m_173215_((String)"stab_type_a", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/block/energy_core/stabilizer_large.png"), false, false)).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172835_)).m_110671_(RenderStateShard.f_110152_).m_110691_(false));
    private CCModel model;

    public RenderEnergyCoreStabilizer(BlockEntityRendererProvider.Context context) {
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/energy_core/stabilizer_large.obj")).quads().ignoreMtl().parse();
        this.model = CCModel.combine(map.values()).backfacedCopy();
    }

    public void render(TileEnergyCoreStabilizer tile, float partialTicks, PoseStack poseStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        if (!tile.isValidMultiBlock.get()) {
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = 240;
        ccrs.overlay = packedOverlay;
        boolean coreActive = tile.isCoreActive.get();
        Direction facing = coreActive ? (Direction)tile.coreDirection.get() : Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)tile.multiBlockAxis.get()));
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        if (facing.m_122434_() == Direction.Axis.X || facing.m_122434_() == Direction.Axis.Y) {
            poseStack.m_85845_(new Quaternion((float)(facing.m_122430_() * 90), (float)(facing.m_122429_() * -90), 0.0f, true));
        } else if (facing == Direction.SOUTH) {
            poseStack.m_85845_(new Quaternion(0.0f, 180.0f, 0.0f, true));
        }
        poseStack.m_85845_(new Quaternion(0.0f, 0.0f, tile.rotation + (coreActive ? partialTicks : 0.0f), true));
        poseStack.m_85837_(0.0, -1.5, 0.0);
        ccrs.bind(coreActive ? MODEL_TYPE_ACTIVE : MODEL_TYPE, getter, poseStack);
        this.model.render(ccrs, new IVertexOperation[0]);
        poseStack.m_85849_();
    }
}

