/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.BCProfiler;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class ParticleEnergyCoreFX
extends TextureSheetParticle {
    public static final ParticleRenderType PARTICLE_NO_DEPTH_NO_LIGHT = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager manager) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
        }

        public String toString() {
            return "PARTICLE_NO_DEPTH_NO_LIGHT";
        }
    };
    public Vec3D targetPos;
    public boolean toCore = false;
    public int startRotation = 0;
    private Direction.Axis direction;
    public boolean isLargeStabilizer = false;
    private final SpriteSet spriteSet;

    public ParticleEnergyCoreFX(ClientLevel world, double xPos, double yPos, double zPos, Vec3D targetPos, SpriteSet spriteSet) {
        super(world, xPos, yPos, zPos);
        this.targetPos = targetPos;
        this.spriteSet = spriteSet;
        this.m_108337_(spriteSet.m_7102_(world.f_46441_));
        this.f_107219_ = false;
        Vec3D dir = Vec3D.getDirectionVec((Vec3D)new Vec3D(xPos, yPos, zPos), (Vec3D)targetPos);
        this.direction = Direction.m_122372_((float)((float)dir.x), (float)((float)dir.y), (float)((float)dir.z)).m_122434_();
        this.f_107225_ = 40;
    }

    public ParticleRenderType m_7556_() {
        return PARTICLE_NO_DEPTH_NO_LIGHT;
    }

    protected int m_6355_(float p_107249_) {
        return 255;
    }

    public void m_5989_() {
        BCProfiler.TICK.start("core_fx_update");
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        Vec3D tPos = this.targetPos.copy();
        this.m_108337_(this.spriteSet.m_7102_(this.f_107208_.f_46441_));
        if (this.toCore) {
            double d;
            double rotation = ClientEventHandler.elapsedTicks;
            double offsetX = Math.sin(rotation / 180.0 * Math.PI + (double)this.startRotation / 100.0);
            double offsetY = Math.cos(rotation / 180.0 * Math.PI + (double)this.startRotation / 100.0);
            double d2 = d = this.isLargeStabilizer ? 1.8 : 0.2;
            if (this.direction == Direction.Axis.Z) {
                tPos.add(offsetX * d, offsetY * d, 0.0);
            } else if (this.direction == Direction.Axis.Y) {
                tPos.add(offsetX * d, 0.0, offsetY * d);
            } else if (this.direction == Direction.Axis.X) {
                tPos.add(0.0, offsetY * d, offsetX * d);
            }
        }
        Vec3D dir = Vec3D.getDirectionVec((Vec3D)new Vec3D(this.f_107212_, this.f_107213_, this.f_107214_), (Vec3D)tPos);
        double speed = this.toCore ? 0.5 : 0.25;
        this.f_107215_ = dir.x * speed;
        this.f_107216_ = dir.y * speed;
        this.f_107217_ = dir.z * speed;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (this.f_107224_++ > this.f_107225_ || Utils.getDistanceSq((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_, (double)tPos.x, (double)tPos.y, (double)tPos.z) < 0.01) {
            this.m_107274_();
        }
        BCProfiler.TICK.stop();
    }

    public static class Factory
    implements ParticleProvider<IntParticleType.IntParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet p_i50823_1_) {
            this.spriteSet = p_i50823_1_;
        }

        public Particle createParticle(IntParticleType.IntParticleData data, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleEnergyCoreFX particle = new ParticleEnergyCoreFX(world, x, y, z, new Vec3D(xSpeed, ySpeed, zSpeed), this.spriteSet);
            particle.toCore = data.get().length >= 1 && data.get()[0] == 1;
            particle.startRotation = data.get().length >= 2 ? data.get()[1] : 0;
            particle.isLargeStabilizer = data.get().length >= 3 && data.get()[2] == 1;
            particle.m_6569_(particle.isLargeStabilizer ? 2.0f : 1.0f);
            return particle;
        }
    }
}

