/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.modelfx;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public abstract class ModelEffect {
    public Vector3 pos = new Vector3();
    public double scale = 1.0;
    public float red = 1.0f;
    public float green = 1.0f;
    public float blue = 1.0f;
    public float alpha = 1.0f;
    protected static Random rand;
    private static float[] r;
    private static float[] randSet;
    private static int randPos;

    public abstract RenderType getRenderType();

    protected abstract void doRender(VertexConsumer var1, float var2, TechLevel var3);

    public void renderEffect(Matrix4 mat, MultiBufferSource getter, float partialTicks, TechLevel techLevel) {
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(this.getRenderType()), (Transformation)mat);
        this.doRender((VertexConsumer)builder, partialTicks, techLevel);
    }

    protected void drawParticle(VertexConsumer builder, double x, double y, double z, double scale, float red, float green, float blue, float alpha) {
        double min = (1.0 - scale) * 0.5;
        double max = 0.5 + scale * 0.5;
        builder.m_5483_(x + min, y + 0.5, z + min).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        builder.m_5483_(x + min, y + 0.5, z + max).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_5752_();
        builder.m_5483_(x + max, y + 0.5, z + max).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_5752_();
        builder.m_5483_(x + max, y + 0.5, z + min).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_5752_();
        builder.m_5483_(x + min, y + min, z + 0.5).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        builder.m_5483_(x + min, y + max, z + 0.5).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_5752_();
        builder.m_5483_(x + max, y + max, z + 0.5).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_5752_();
        builder.m_5483_(x + max, y + min, z + 0.5).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_5752_();
        builder.m_5483_(x + 0.5, y + min, z + min).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        builder.m_5483_(x + 0.5, y + min, z + max).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_5752_();
        builder.m_5483_(x + 0.5, y + max, z + max).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_5752_();
        builder.m_5483_(x + 0.5, y + max, z + min).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_5752_();
    }

    protected static float noise(float input) {
        int xMin = (int)(input %= (float)r.length - 1.0f);
        float t = input - (float)xMin;
        return MathHelper.interpolate((float)r[xMin], (float)r[xMin + 1], (float)t);
    }

    protected static float flicker(float input) {
        int xMin = (int)(input %= (float)r.length - 1.0f);
        float t = input - (float)xMin;
        return MathHelper.interpolate((float)r[xMin], (float)0.0f, (float)t);
    }

    protected static float flickerFlair(float input) {
        int xMin;
        float t;
        if ((double)(t = (input %= (float)r.length - 1.0f) - (float)(xMin = (int)input)) < 0.1) {
            return MathHelper.interpolate((float)0.0f, (float)r[xMin], (float)(t / 0.1f));
        }
        return MathHelper.interpolate((float)r[xMin], (float)0.0f, (float)((t - 0.1f) / 0.9f));
    }

    protected static float nextFloat() {
        return randSet[randPos++ % randSet.length];
    }

    protected static void setRandSeed(int i) {
        randPos = i % randSet.length;
    }

    static {
        int i;
        rand = new Random();
        r = new float[256];
        randSet = new float[4096];
        randPos = 0;
        rand.setSeed(123L);
        for (i = 0; i < r.length; ++i) {
            ModelEffect.r[i] = rand.nextFloat();
        }
        for (i = 0; i < randSet.length; ++i) {
            ModelEffect.randSet[i] = rand.nextFloat();
        }
    }
}

