/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.brandon3055.draconicevolution.client.shader.ToolShader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class RenderModularChestpiece
extends ToolRenderBase {
    private final ToolRenderBase.ToolPart basePart;
    private final ToolRenderBase.ToolPart materialPart;
    private final ToolRenderBase.ToolPart gemPart;
    private final CoreGemPart coreGemPart;

    public RenderModularChestpiece(TechLevel techLevel) {
        super(techLevel, "chestpeice");
        Map model = new OBJParser(new ResourceLocation("draconicevolution", "models/item/equipment/chestpeice.obj")).ignoreMtl().parse();
        this.basePart = this.basePart(((CCModel)model.get("base_model")).backfacedCopy());
        this.materialPart = this.materialPart(((CCModel)model.get("chevrons")).backfacedCopy());
        this.gemPart = this.gemPart(((CCModel)model.get("power_crystals")).backfacedCopy());
        this.coreGemPart = this.coreGemPart(((CCModel)model.get("crystal_core")).backfacedCopy());
    }

    @Override
    public void renderTool(CCRenderState ccrs, ItemStack stack, ItemTransforms.TransformType transform, Matrix4 mat, MultiBufferSource buffers, boolean gui) {
        ModuleHost host;
        ShieldControlEntity shieldControl;
        mat.translate(0.5, 1.05, 0.5);
        mat.rotate(3.1415926535897403, Vector3.Z_POS);
        mat.scale(1.95);
        this.basePart.render(transform, buffers, mat);
        this.materialPart.render(transform, buffers, mat);
        int shieldColour = -1;
        LazyOptional optionalHost = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        if (!stack.m_41619_() && optionalHost.isPresent() && (shieldControl = (ShieldControlEntity)(host = (ModuleHost)optionalHost.orElseThrow(IllegalStateException::new)).getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null)) != null) {
            shieldColour = shieldControl.getShieldColour();
        }
        this.gemPart.render(transform, buffers, mat);
        this.coreGemPart.render(buffers, mat, shieldColour);
    }

    @Override
    public ModelState getModelTransform() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    protected CoreGemPart coreGemPart(CCModel model) {
        String levelName = this.techLevel.name().toLowerCase(Locale.ROOT);
        RenderType.CompositeRenderType gemType = RenderType.m_173209_((String)"draconicevolution:core_gem", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> ((ToolShader)DEShaders.CHESTPIECE_GEM_SHADER).getShaderInstance())).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/item/equipment/shader_fallback_" + levelName + ".png"), false, false)).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110691_(false));
        return new CoreGemPart(model, (RenderType)gemType, DEShaders.CHESTPIECE_GEM_SHADER);
    }

    private class CoreGemPart
    extends ToolRenderBase.SimpleToolPart {
        private final ToolShader shader;

        public CoreGemPart(CCModel model, RenderType baseType, ToolShader shader) {
            super(RenderModularChestpiece.this, model, baseType, shader);
            this.shader = shader;
        }

        @Override
        public void render(ItemTransforms.TransformType transformType, MultiBufferSource buffers, Matrix4 mat, float pulse) {
            this.render(buffers, mat, -1);
        }

        public void render(MultiBufferSource buffers, Matrix4 mat, int color) {
            buffers.m_6299_((RenderType)this.vboType.withCallback(() -> {
                this.shader.getBaseColorUniform().glUniform4f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
                this.shader.getModelMatUniform().glUniformMatrix4f(mat);
            }));
        }
    }
}

