/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.hud;

import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.api.math.Vector2;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.api.modules.entities.UndyingEntity;
import com.brandon3055.draconicevolution.client.DEGuiSprites;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.equipment.ModularChestpiece;
import com.brandon3055.draconicevolution.items.tools.DraconiumCapacitor;
import com.brandon3055.draconicevolution.lib.WTFException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class ShieldHudElement
extends AbstractHudElement {
    private static int TOTEM_EFFECT_TIME = 32;
    private static Random rand = new Random();
    private Minecraft mc = Minecraft.m_91087_();
    private double shieldCharge = 0.0;
    private String shieldText = "";
    private double coolDown = 0.0;
    private double energyBar = 0.0;
    private String energyText = "";
    private double[] totemStatus = new double[0];
    private int totemEffect = 0;
    private long totemEffectSeed = 0L;
    private int totemEffectIndex = 0;
    private float hudOpacity = 1.0f;
    private int lastTotemCount = 0;
    private int lastChargedTotemCount = 0;
    private boolean renderHud = false;
    private boolean numericEnergy = true;
    private boolean showUndying = true;
    private int energyMode = 2;
    private float scale = 1.0f;

    public ShieldHudElement() {
        super(new Vector2(0.0136, 0.9787));
        this.width = 119.0;
    }

    public void addConfigElements(List<GuiElement<?>> list, GuiElement<?> parent) {
        super.addConfigElements(list, parent);
        list.add(((GuiButton)this.createButton(() -> I18n.m_118938_((String)("hud_armor.draconicevolution.numeric." + this.numericEnergy), (Object[])new Object[0]), parent, this.runDirty(() -> {
            this.numericEnergy = !this.numericEnergy;
        })).setHoverText(I18n.m_118938_((String)"hud_armor.draconicevolution.numeric.info", (Object[])new Object[0]))).setXSize(140));
        list.add(this.createButton(() -> I18n.m_118938_((String)("hud_armor.draconicevolution.undying." + this.showUndying), (Object[])new Object[0]), parent, this.runDirty(() -> {
            this.showUndying = !this.showUndying;
        })).setHoverText(I18n.m_118938_((String)"hud_armor.draconicevolution.undying.info", (Object[])new Object[0])));
        list.add(this.createButton(() -> I18n.m_118938_((String)("hud_armor.draconicevolution.energy." + this.energyMode), (Object[])new Object[0]), parent, this.runDirty(() -> {
            this.energyMode = this.energyMode == 2 ? 0 : this.energyMode + 1;
        })).setHoverText(I18n.m_118938_((String)"hud_armor.draconicevolution.energy.info", (Object[])new Object[0])));
    }

    public void popTotem() {
        this.totemEffect = TOTEM_EFFECT_TIME;
        if (this.mc.f_91073_ != null) {
            this.totemEffectSeed = this.mc.f_91073_.f_46441_.nextLong();
        }
        this.totemEffectIndex = 0;
        for (double totem : this.totemStatus) {
            if (totem == -1.0) break;
            ++this.totemEffectIndex;
        }
    }

    private boolean extended() {
        return this.numericEnergy || this.totemStatus.length > 0;
    }

    public double height() {
        return 17.0f * this.scale + (this.extended() ? 10.0f * this.scale : 0.0f);
    }

    public double width() {
        return 115.0f * this.scale;
    }

    public void tick(boolean configuring) {
        if (this.mc.f_91074_ == null || !this.enabled) {
            this.renderHud = false;
            if (configuring) {
                this.setupExample();
            }
            return;
        }
        if (this.totemEffect > 0) {
            --this.totemEffect;
        }
        ItemStack chestStack = ModularChestpiece.getChestpiece((LivingEntity)this.mc.f_91074_);
        LazyOptional optionalHost = chestStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        LazyOptional optionalStorage = chestStack.getCapability(DECapabilities.OP_STORAGE);
        if (chestStack.m_41619_() || !optionalHost.isPresent() || !optionalStorage.isPresent()) {
            this.renderHud = false;
            if (configuring) {
                this.setupExample();
            }
            return;
        }
        ModuleHost host = (ModuleHost)optionalHost.orElseThrow(IllegalStateException::new);
        IOPStorage opStorage = (IOPStorage)optionalStorage.orElseThrow(IllegalStateException::new);
        ShieldControlEntity shieldControl = host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
        if (shieldControl == null) {
            this.shieldCharge = 0.0;
            this.shieldText = I18n.m_118938_((String)"hud_armor.draconicevolution.no_shield", (Object[])new Object[0]);
        } else if (!shieldControl.isShieldEnabled()) {
            this.shieldCharge = 0.0;
            this.shieldText = I18n.m_118938_((String)"hud_armor.draconicevolution.shield_disabled", (Object[])new Object[0]);
        } else {
            double capacity = (double)shieldControl.getShieldCapacity() + shieldControl.getMaxShieldBoost();
            if (capacity == 0.0 && shieldControl.getMaxShieldBoost() > 0.0) {
                capacity = shieldControl.getMaxShieldBoost();
            }
            double points = shieldControl.getShieldPoints();
            this.shieldCharge = capacity > 0.0 ? points / capacity : 0.0;
            this.shieldText = (int)points + "/" + (int)capacity;
            double maxCooldown = shieldControl.getMaxShieldCoolDown();
            this.coolDown = maxCooldown > 0.0 ? (double)shieldControl.getShieldCoolDown() / maxCooldown : 0.0;
        }
        long energy = opStorage.getOPStored();
        long maxEnergy = opStorage.getMaxOPStored();
        if (this.energyMode > 0) {
            ArrayList<ItemStack> capacitors = new ArrayList<ItemStack>(EquipmentManager.findItems(e -> e.m_41720_() instanceof DraconiumCapacitor, (LivingEntity)this.mc.f_91074_));
            for (ItemStack stack : this.mc.f_91074_.m_150109_().f_35974_) {
                if (!(stack.m_41720_() instanceof DraconiumCapacitor)) continue;
                capacitors.add(stack);
            }
            long capMax = 0L;
            long capEnergy = 0L;
            for (ItemStack stack : capacitors) {
                LazyOptional optCap = stack.getCapability(CapabilityOP.OP);
                if (!optCap.isPresent()) continue;
                IOPStorage storage = (IOPStorage)optCap.orElseThrow(WTFException::new);
                capMax = Utils.safeAdd((long)storage.getMaxOPStored(), (long)capMax);
                capEnergy = Utils.safeAdd((long)storage.getOPStored(), (long)capEnergy);
            }
            if (this.energyMode == 1) {
                energy = capEnergy;
                maxEnergy = capMax;
            } else {
                energy = Utils.safeAdd((long)capEnergy, (long)energy);
                maxEnergy = Utils.safeAdd((long)capMax, (long)maxEnergy);
            }
        }
        double d = this.energyBar = maxEnergy > 0L ? (double)energy / (double)maxEnergy : 0.0;
        if (this.numericEnergy) {
            this.energyText = I18n.m_118938_((String)"op.brandonscore.op", (Object[])new Object[0]) + ": " + Utils.formatNumber((long)energy);
        }
        if (this.showUndying) {
            List totems = host.getEntitiesByType(ModuleTypes.UNDYING).map(e -> (UndyingEntity)e).sorted(Comparator.comparing(e -> e.getModule().getModuleTechLevel().index)).collect(Collectors.toList());
            int chargedTotems = 0;
            this.totemStatus = new double[totems.size()];
            for (int i = 0; i < totems.size(); ++i) {
                UndyingEntity entity = (UndyingEntity)totems.get(i);
                if (entity.isCharged()) {
                    ++chargedTotems;
                }
                this.totemStatus[i] = entity.isCharged() ? -1.0 : entity.getCharge();
            }
            if (this.lastTotemCount != totems.size()) {
                this.lastTotemCount = totems.size();
            } else if (chargedTotems > this.lastChargedTotemCount && this.mc.f_91073_ != null) {
                this.mc.f_91073_.m_104677_(this.mc.f_91074_.m_142538_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 2.0f, false);
            }
            this.lastChargedTotemCount = chargedTotems;
        } else {
            this.totemStatus = new double[0];
        }
        this.renderHud = true;
    }

    private void setupExample() {
        double[] dArray;
        this.renderHud = this.enabled;
        this.shieldCharge = 0.5315875613747955;
        this.shieldText = "1624/3055";
        this.energyBar = 0.75;
        this.energyText = I18n.m_118938_((String)"op.brandonscore.op", (Object[])new Object[0]) + ": 42M";
        if (this.showUndying) {
            double[] dArray2 = new double[3];
            dArray2[0] = -1.0;
            dArray2[1] = 0.5;
            dArray = dArray2;
            dArray2[2] = 0.75;
        } else {
            dArray = new double[]{};
        }
        this.totemStatus = dArray;
    }

    public void render(PoseStack mStack, float partialTicks, boolean configuring) {
        if (!this.renderHud) {
            return;
        }
        mStack.m_85837_(this.xPos(), this.yPos(), 0.0);
        mStack.m_85841_(this.scale, this.scale, this.scale);
        MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
        this.hudOpacity = 1.0f;
        double width = this.width() - (double)(16.0f * this.scale);
        double height = this.height() - (double)(this.extended() ? 10.0f * this.scale : 0.0f);
        double iconSize = height - 2.0;
        GuiHelper.drawSprite((VertexConsumer)BCGuiSprites.builder((MultiBufferSource)getter, (PoseStack)mStack), (double)0.0, (double)(height / 2.0 - iconSize / 2.0), (double)iconSize, (double)iconSize, (TextureAtlasSprite)DEGuiSprites.getSprite("hud/shield_icon"), (float)1.0f, (float)1.0f, (float)1.0f, (float)this.hudOpacity);
        mStack.m_85837_(iconSize, 0.0, 0.0);
        boolean xl = false;
        int shH = xl ? 11 : 7;
        int reH = xl ? 3 : 2;
        int divH = xl ? 2 : 1;
        GuiHelper.drawHoverRect((MultiBufferSource)getter, (PoseStack)mStack, (double)0.0, (double)0.0, (double)width, (double)height, (int)this.scaleAlpha(-16711653), (int)this.scaleAlpha(-12251305), (boolean)true);
        double charge = this.shieldCharge >= 0.0 ? this.shieldCharge : 0.0;
        double bw = width - 4.0;
        GuiHelper.drawPartialSprite((VertexConsumer)BCGuiSprites.builder((MultiBufferSource)getter, (PoseStack)mStack), (double)2.0, (double)2.0, (double)(bw * charge), (double)shH, (TextureAtlasSprite)DEGuiSprites.getSprite("hud/ryg_bar"), (double)0.0, (double)0.0, (double)charge, (double)1.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)this.hudOpacity);
        GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)mStack, (double)(2.0 + bw * charge), (double)2.0, (double)(bw * (1.0 - charge)), (double)shH, (int)this.scaleAlpha(-16711653));
        GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)mStack, (double)2.0, (double)(2 + shH), (double)(width - 4.0), (double)divH, (int)this.scaleAlpha(-14547157));
        GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)mStack, (double)2.0, (double)(2 + shH + divH), (double)(bw * this.coolDown), (double)reH, (int)this.scaleAlpha(-8126464));
        GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)mStack, (double)(2.0 + bw * this.coolDown), (double)(2 + shH + divH), (double)(bw * (1.0 - this.coolDown)), (double)reH, (int)this.scaleAlpha(-16732140));
        GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)mStack, (double)2.0, (double)(2 + shH + divH + reH), (double)(width - 4.0), (double)divH, (int)this.scaleAlpha(-14547157));
        GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)mStack, (double)2.0, (double)(2 + shH + divH + reH + divH), (double)(bw * this.energyBar), (double)reH, (int)this.scaleAlpha(-16265512));
        GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)mStack, (double)(2.0 + bw * this.energyBar), (double)(2 + shH + divH + reH + divH), (double)(bw * (1.0 - this.energyBar)), (double)reH, (int)this.scaleAlpha(-16711653));
        if (this.totemStatus.length > 0) {
            double x = width - 8.0;
            for (double state : this.totemStatus) {
                GuiHelper.drawSprite((VertexConsumer)BCGuiSprites.builder((MultiBufferSource)getter, (PoseStack)mStack), (double)x, (double)(height + 1.0), (double)8.0, (double)8.0, (TextureAtlasSprite)DEGuiSprites.getSprite("hud/undying"), (int)this.scaleAlpha(state != -1.0 ? -65536 : -1));
                if (state != -1.0) {
                    GuiHelper.drawPieProgress((MultiBufferSource)getter, (PoseStack)mStack, (double)x, (double)(height + 1.0), (double)8.0, (double)state, (double)0.0, (int)-2130706433);
                }
                x -= 9.0;
            }
        }
        if (this.totemEffect > 0) {
            float progress = 1.0f - ((float)this.totemEffect - partialTicks) / (float)TOTEM_EFFECT_TIME;
            this.particleExplosion((MultiBufferSource)getter, mStack, width - 4.0 - (double)(this.totemEffectIndex * 9), height + 5.0, progress, rand);
        }
        getter.m_109911_();
        double tPos = width / 2.0 - (double)this.mc.f_91062_.m_92895_(this.shieldText) / 2.0;
        this.mc.f_91062_.m_92883_(mStack, this.shieldText, (float)tPos, xl ? 4.0f : 2.0f, this.scaleAlpha(-16776961));
        if (this.numericEnergy && !this.energyText.isEmpty()) {
            this.mc.f_91062_.m_92750_(mStack, this.energyText, 2.0f, (float)height + 1.0f, this.scaleAlpha(-1));
        }
    }

    public void particleExplosion(MultiBufferSource getter, PoseStack mStack, double x, double y, float progress, Random rand) {
        rand.setSeed(this.totemEffectSeed);
        TextureAtlasSprite[] particles = new TextureAtlasSprite[8];
        for (int i = 0; i < 8; ++i) {
            particles[i] = DEGuiSprites.getSprite("effect/glitter_" + i);
        }
        int pCount = 128;
        int size = 100;
        double scale = 6.0;
        for (int p = 0; p < pCount; ++p) {
            float life = 0.5f + rand.nextFloat() * 0.5f;
            float age = Mth.m_14036_((float)(progress / life), (float)0.0f, (float)1.0f);
            float fadeOut = Math.min(1.0f, (1.0f - age) * 10.0f);
            boolean altColour = rand.nextInt(4) == 0;
            float red = (altColour ? 0.6f : 0.1f) + rand.nextFloat() * 0.2f;
            float green = (altColour ? 0.6f : 0.4f) + rand.nextFloat() * 0.3f;
            float blue = rand.nextFloat() * 0.2f;
            double dir = rand.nextDouble() * Math.PI * 2.0;
            double dist = rand.nextGaussian() * (double)size;
            double pX = x + (double)Mth.m_14031_((float)((float)dir)) * dist * (double)progress;
            double pY = y + (double)Mth.m_14089_((float)((float)dir)) * dist * (double)progress;
            double ps = scale * (0.75 + rand.nextDouble() * 0.5) * (double)fadeOut;
            int index = Math.min((int)(age * 8.0f), 7);
            if (age >= 1.0f) continue;
            GuiHelper.drawSprite((VertexConsumer)BCGuiSprites.builder((MultiBufferSource)getter, (PoseStack)mStack), (double)(pX - ps / 2.0), (double)(pY - ps / 2.0), (double)ps, (double)ps, (TextureAtlasSprite)particles[index], (float)red, (float)green, (float)blue, (float)1.0f);
        }
    }

    private int scaleAlpha(int colour) {
        int modifier = (int)(this.hudOpacity * 240.0f) + 15 << 24;
        return modifier | (colour &= 0xFFFFFF);
    }

    public void writeNBT(CompoundTag nbt) {
        super.writeNBT(nbt);
        nbt.m_128379_("show_numeric", this.numericEnergy);
        nbt.m_128379_("show_undying", this.showUndying);
        nbt.m_128350_("scale", this.scale);
    }

    public void readNBT(CompoundTag nbt) {
        super.readNBT(nbt);
        this.numericEnergy = nbt.m_128471_("show_numeric");
        this.showUndying = nbt.m_128471_("show_undying");
        this.scale = nbt.m_128457_("scale");
    }
}

