/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import com.brandon3055.draconicevolution.client.DEMiscSprites;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrystalFXWireless
extends CrystalFXBase<TileCrystalWirelessIO> {
    private final BlockPos linkTarget;
    private final AABB targetBB;
    private float powerLevel = 0.0f;
    private List<PTracker> trackers = new ArrayList<PTracker>();
    private static final ParticleRenderType BASIC_HANDLER = new FXHandler();
    private static final ParticleRenderType WYVERN_HANDLER = new FXHandler();
    private static final ParticleRenderType DRACONIC_HANDLER = new FXHandler();

    public CrystalFXWireless(ClientLevel worldIn, TileCrystalWirelessIO tile, BlockPos linkTarget) {
        super(worldIn, tile);
        this.f_107224_ = worldIn.f_46441_.nextInt(1024);
        this.setPosition(tile.getBeamLinkPos(linkTarget));
        this.linkTarget = linkTarget;
        BlockState state = worldIn.m_8055_(linkTarget);
        VoxelShape shape = state.m_60808_((BlockGetter)worldIn, linkTarget);
        if (shape.m_83281_()) {
            shape = Shapes.m_83144_();
        }
        this.targetBB = shape.m_83215_();
        this.targetBB.m_82406_(0.05);
        this.m_107259_(new AABB(this.f_107212_, this.f_107213_, this.f_107214_, (double)this.linkTarget.m_123341_(), (double)this.linkTarget.m_123342_(), (double)this.linkTarget.m_123343_()));
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        if (this.ticksTillDeath-- <= 0) {
            this.m_107274_();
        }
        this.f_107230_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107227_ = 1.0f;
        this.powerLevel = (float)MathHelper.approachExp((double)this.powerLevel, (double)this.fxState, (double)0.05);
        Iterator<PTracker> i = this.trackers.iterator();
        while (i.hasNext()) {
            PTracker next = i.next();
            if (next.ticksActive >= next.travelTime) {
                i.remove();
                continue;
            }
            ++next.ticksActive;
        }
        int ps = Minecraft.m_91087_().f_91066_.f_92073_.m_92198_();
        if (this.f_107224_ % 2 == 0 && this.powerLevel > this.f_107223_.nextFloat() && (ps == 0 || ps == 1 && this.f_107223_.nextInt(3) == 0 || ps == 2 && this.f_107223_.nextInt(10) == 0)) {
            double travel = 50 + this.f_107223_.nextInt(50);
            this.trackers.add(new PTracker((int)(travel *= (double)(1.4f - this.powerLevel)), new Vector3(this.targetBB.f_82288_ + this.f_107223_.nextDouble() * (this.targetBB.f_82291_ - this.targetBB.f_82288_), this.targetBB.f_82289_ + this.f_107223_.nextDouble() * (this.targetBB.f_82292_ - this.targetBB.f_82289_), this.targetBB.f_82290_ + this.f_107223_.nextDouble() * (this.targetBB.f_82293_ - this.targetBB.f_82290_))));
        }
        ++this.f_107224_;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        int texIndex = ClientEventHandler.elapsedTicks % DEMiscSprites.ENERGY_PARTICLE.length;
        TextureAtlasSprite sprite = DEMiscSprites.ENERGY_PARTICLE[texIndex];
        if (sprite == null) {
            return;
        }
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        float scale = 0.08f;
        boolean output = !((TileCrystalWirelessIO)this.tile).inputMode.get();
        Vec3 view = renderInfo.m_90583_();
        Vector3 source = new Vector3(this.f_107212_ - view.f_82479_, this.f_107213_ - view.f_82480_, this.f_107214_ - view.f_82481_);
        Vector3 target = Vector3.fromBlockPos((BlockPos)this.linkTarget).subtract(view.f_82479_, view.f_82480_, view.f_82481_);
        for (PTracker tracker : this.trackers) {
            double progress = ((double)tracker.ticksActive + (double)partialTicks) / (double)tracker.travelTime;
            if (!output) {
                progress = 1.0 - progress;
            }
            if (progress >= 1.0 || progress <= 0.0) continue;
            Vector3 pathVec = target.copy().subtract(source);
            pathVec.add(tracker.tOffset);
            pathVec.multiply(progress);
            pathVec.add(source);
            Vector3f[] renderVector = this.getRenderVectors(renderInfo, (float)pathVec.x, (float)pathVec.y, (float)pathVec.z, scale);
            buffer.m_5483_((double)renderVector[0].m_122239_(), (double)renderVector[0].m_122260_(), (double)renderVector[0].m_122269_()).m_85950_(0.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[1].m_122239_(), (double)renderVector[1].m_122260_(), (double)renderVector[1].m_122269_()).m_85950_(0.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, minV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[2].m_122239_(), (double)renderVector[2].m_122260_(), (double)renderVector[2].m_122269_()).m_85950_(0.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[3].m_122239_(), (double)renderVector[3].m_122260_(), (double)renderVector[3].m_122269_()).m_85950_(0.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_7120_(240, 240).m_5752_();
        }
    }

    public ParticleRenderType m_7556_() {
        return ((TileCrystalWirelessIO)this.tile).getTier() == 0 ? BASIC_HANDLER : (((TileCrystalWirelessIO)this.tile).getTier() == 1 ? WYVERN_HANDLER : DRACONIC_HANDLER);
    }

    public static class PTracker {
        public int ticksActive = 0;
        public final int travelTime;
        public final Vector3 tOffset;

        public PTracker(int travelTime, Vector3 tOffset) {
            this.travelTime = travelTime;
            this.tOffset = tOffset;
        }
    }

    public static class FXHandler
    implements ParticleRenderType {
        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.m_157427_(GameRenderer::m_172835_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)DEMiscSprites.ATLAS_LOCATION);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        }

        public void m_6294_(Tesselator tessellator) {
            tessellator.m_85914_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    }
}

