/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.handler;

import com.brandon3055.draconicevolution.api.energy.ICrystalBinder;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.handlers.BinderHandler;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OverlayRenderHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already Initialized");

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(OverlayRenderHandler::renderLevelStage);
    }

    public static void renderLevelStage(RenderLevelLastEvent event) {
        if (event.isCanceled()) {
            return;
        }
        ClientEventHandler.MODELVIEW.set(event.getPoseStack().m_85850_().m_85861_());
        ClientEventHandler.PROJECTION.set(event.getProjectionMatrix());
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Level world = player.m_20193_();
        ItemStack stack = player.m_21205_();
        ItemStack offStack = player.m_21206_();
        Minecraft mc = Minecraft.m_91087_();
        float partialTicks = event.getPartialTick();
        try {
            if (!stack.m_41619_() && stack.m_41720_() instanceof ICrystalBinder) {
                BinderHandler.renderWorldOverlay(player, event.getPoseStack(), world, stack, mc, partialTicks);
            } else if (!stack.m_41619_() && offStack.m_41720_() instanceof ICrystalBinder) {
                BinderHandler.renderWorldOverlay(player, event.getPoseStack(), world, offStack, mc, partialTicks);
            }
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred while rendering crystal binder overlay", e);
        }
    }
}

