/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular.itemconfig;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.StandardDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.ThemedElements;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiManipulable;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.lib.Tripple;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.ItemConfigDataHandler;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyContainer;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyElement;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.inventory.ContainerConfigurableItem;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class GuiConfigurableItem
extends ModularGuiContainer<ContainerConfigurableItem> {
    private static final int HIDDEN_SIZE = 15;
    private static final int EXPANDED_SIZE = 230;
    private static final int COLLAPSED_SIZE = 97;
    private final Inventory inventory;
    private UUID selectedItem = null;
    private static float hideAnim = 0.0f;
    private static float rePosAnim = 1.0f;
    private static float resizeAnim = 1.0f;
    private static boolean advancedUI = false;
    private static boolean hideUI = false;
    private int holdTimer = 0;
    private boolean closeOnRelease = false;
    private boolean bindReleased = false;
    private GuiLabel title;
    private GuiButton toggleAdvanced;
    private GuiElement<?> mainUI;
    private GuiElement<?> playerSlots;
    private GuiScrollElement simpleViewList;
    private GuiToolkit.InfoPanel infoPanel;
    protected GuiElement<?> deleteZone;
    protected GuiElement<?> advancedContainer;
    protected PropertyData hoveredData = null;
    protected PropertyProvider hoveredProvider = null;
    protected List<UpdateAnim> updateAnimations = new ArrayList<UpdateAnim>();
    protected GuiToolkit<GuiConfigurableItem> toolkit;
    protected List<PropertyContainer> propertyContainers = new ArrayList<PropertyContainer>();
    protected static List<PropertyContainer> keyBindCache = null;

    public GuiConfigurableItem(ContainerConfigurableItem container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
        this.inventory = inv;
        this.toolkit = new GuiToolkit((Screen)this, 0, 0);
        container.setOnInventoryChange(this::onInventoryUpdate);
        container.setSelectionListener(this::onItemSelected);
        this.setExperimentalSlotOcclusion(true);
    }

    protected void drawSlotOverlay(Slot slot, boolean occluded) {
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_()) {
            stack.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY).ifPresent(provider -> {
                ConfigProperty prop;
                int y = slot.f_40221_;
                int x = slot.f_40220_;
                int light = -268971;
                int dark = -763643;
                MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
                this.setZLevel(this.mainUI.displayZLevel);
                GuiHelperOld.drawShadedRect((VertexConsumer)getter.m_6299_(GuiHelper.transColourType), (double)(x - 1), (double)(y - 1), (double)18.0, (double)18.0, (double)1.0, (int)0, (int)dark, (int)light, (int)GuiElement.midColour((int)light, (int)dark), (double)this.mainUI.getRenderZLevel());
                if (!advancedUI && provider.getProviderID().equals(this.selectedItem)) {
                    GuiHelperOld.drawColouredRect((VertexConsumer)getter.m_6299_(GuiHelper.transColourType), (double)x, (double)y, (double)16.0, (double)16.0, (int)-2130771968, (double)this.mainUI.displayZLevel);
                } else if (DEConfig.configUiEnableVisualization && this.hoveredData != null && (prop = this.hoveredData.getPropIfApplicable((PropertyProvider)provider)) != null) {
                    GuiHelperOld.drawColouredRect((VertexConsumer)getter.m_6299_(GuiHelper.transColourType), (double)x, (double)y, (double)16.0, (double)16.0, (int)(this.hoveredData.doesDataMatch(prop) ? -2147418368 : -2130734848), (double)0.0);
                }
                getter.m_109911_();
                if (DEConfig.configUiEnableVisualization && !this.updateAnimations.isEmpty()) {
                    this.updateAnimations.stream().filter(e -> e.data.getPropIfApplicable((PropertyProvider)provider) != null).forEach(e -> e.render(x, y));
                }
            });
        }
    }

    public void addElements(GuiElementManager manager) {
        this.addAdvancedUIElements(manager);
        this.mainUI = GuiTexture.newDynamicTexture(() -> BCGuiSprites.getThemed((String)"background_dynamic"));
        this.mainUI.setSize(218, 230);
        manager.addChild(this.mainUI, 90, false);
        GuiButton themeButton = this.toolkit.createThemeButton(this.mainUI);
        themeButton.onReload(() -> themeButton.setPos(this.mainUI.maxXPos() - 15, this.mainUI.yPos() + 3));
        this.title = this.toolkit.createHeading("", this.mainUI, false);
        this.title.setDisplaySupplier(() -> {
            if (advancedUI || ((ContainerConfigurableItem)this.container).getLastStack().m_41619_()) {
                return I18n.m_118938_((String)"gui.draconicevolution.item_config.name", (Object[])new Object[0]);
            }
            String name = ((ContainerConfigurableItem)this.container).getLastStack().m_41786_().getString();
            String prefix = I18n.m_118938_((String)"gui.draconicevolution.item_config.configure", (Object[])new Object[0]) + " ";
            if (this.f_96547_.m_92895_(prefix + name) > themeButton.xPos() - this.toggleAdvanced.maxXPos() - 22) {
                return name;
            }
            return prefix + name;
        });
        this.title.setAlignment(GuiAlign.CENTER);
        this.title.setSize(this.mainUI.xSize() - 48, 8);
        this.title.setPos(this.mainUI.xPos() + 24, this.mainUI.yPos() + 4);
        GuiButton hideButton = this.toolkit.createResizeButton(this.mainUI);
        hideButton.setEnabledCallback(() -> advancedUI);
        hideButton.onPressed(() -> {
            hideUI = !hideUI;
        });
        hideButton.setHoverText(I18n.m_118938_((String)"gui.draconicevolution.item_config.toggle_hidden.info", (Object[])new Object[0]));
        hideButton.onReload(() -> hideButton.setPos(themeButton.xPos() - 12, this.mainUI.yPos() + 3));
        this.toggleAdvanced = this.toolkit.createAdvancedButton(this.mainUI);
        this.toggleAdvanced.onPressed(this::toggleAdvanced);
        this.toggleAdvanced.setHoverText(I18n.m_118938_((String)"gui.draconicevolution.item_config.toggle_advanced.info", (Object[])new Object[0]));
        this.toggleAdvanced.onReload(() -> this.toggleAdvanced.setPos(this.mainUI.xPos() + 3, this.mainUI.yPos() + 3));
        this.playerSlots = this.toolkit.createPlayerSlots(this.mainUI, false, true, true);
        GuiElement equipModSlots = this.toolkit.createEquipModSlots(this.mainUI, this.inventory.f_35978_, true, e -> e.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY).isPresent());
        equipModSlots.setPos(this.mainUI.xPos() - 28, this.mainUI.yPos());
        this.simpleViewList = GuiConfigurableItem.createPropertyList();
        this.simpleViewList.setInsets(2, 2, 2, 2);
        this.simpleViewList.addBackgroundChild((GuiElement)((ThemedElements.ContentRect)new ThemedElements.ContentRect(false, false).bindSize((GuiElement)this.simpleViewList, false)));
        this.simpleViewList.setEnabledCallback(() -> this.simpleViewList.ySize() > 20);
        this.simpleViewList.setPos(this.mainUI.xPos() + 15, this.mainUI.yPos() + 15);
        this.simpleViewList.setMaxXPos(this.mainUI.maxXPos() - 15, true);
        this.simpleViewList.setInsetScrollBars(true);
        this.mainUI.addChild((GuiElement)this.simpleViewList);
        GuiLabel getStarted = new GuiLabel(I18n.m_118938_((String)"gui.draconicevolution.item_config.select_item_to_get_started", (Object[])new Object[0]));
        getStarted.onReload(e -> e.setPosAndSize(0, this.mainUI.yPos() - 20, this.f_96543_, 8));
        getStarted.setEnabledCallback(() -> advancedUI && this.propertyContainers.isEmpty() || !advancedUI && this.simpleViewList.getScrollingElements().isEmpty());
        this.mainUI.addChild((GuiElement)getStarted);
        GuiButton options = this.createOptionsButton();
        GuiButton moduleConfig = this.toolkit.createThemedIconButton(this.mainUI, "grid_small");
        moduleConfig.onReload(() -> moduleConfig.setPos(hideButton.isEnabled() ? hideButton.xPos() - 12 : themeButton.xPos() - 12, this.mainUI.yPos() + 3));
        moduleConfig.setHoverText(I18n.m_118938_((String)"gui.draconicevolution.item_config.open_modules.info", (Object[])new Object[0]));
        moduleConfig.onPressed(this::openModulesGui);
        GuiButton hudConfig = this.toolkit.createIconButton(this.mainUI, 16, 9, 16, 8, BCGuiSprites.themedGetter((String)"hud_button"));
        hudConfig.onReload(e -> e.setPos((options.isEnabled() ? options : this.toggleAdvanced).maxXPos() + 1, moduleConfig.yPos() + 1));
        hudConfig.setHoverText(I18n.m_118938_((String)"hud.draconicevolution.open_hud_config", (Object[])new Object[0]));
        hudConfig.onPressed(() -> this.f_96541_.m_91152_((Screen)new HudConfigGui()));
        this.mainUI.onReload(this::updateUIGeometry);
        this.selectedItem = ((ContainerConfigurableItem)this.container).getSelectedId();
        this.loadSelectedItemProperties();
        this.loadPropertyConfig();
    }

    private void openModulesGui() {
        this.f_96541_.f_91074_.m_6915_();
        this.m_7861_();
        DraconicNetwork.sendOpenModuleConfig();
    }

    private void addAdvancedUIElements(GuiElementManager manager) {
        this.advancedContainer = new GuiElement();
        this.advancedContainer.setEnabledCallback(() -> advancedUI || DEConfig.configUiEnableAdvancedXOver);
        this.advancedContainer.onReload(() -> this.advancedContainer.setPosAndSize(0, 0, this.f_96543_, this.f_96544_));
        manager.addChild(this.advancedContainer);
        this.deleteZone = new GuiTexture(16, 16, () -> BCGuiSprites.get((String)"delete"));
        this.deleteZone.setEnabledCallback(() -> advancedUI && DEConfig.configUiEnableDeleteZone);
        this.deleteZone.setYPos(0).setXPosMod(() -> this.advancedContainer.maxXPos() - 16);
        this.deleteZone.setHoverText(I18n.m_118938_((String)"gui.draconicevolution.item_config.delete_zone.info", (Object[])new Object[0]));
        GuiToolkit.addHoverHighlight(this.deleteZone, (int)0, (int)0, (boolean)true);
        this.advancedContainer.addChild(this.deleteZone);
        GuiButton addGroup = this.toolkit.createIconButton(this.advancedContainer, 16, BCGuiSprites.getter((String)"new_group"));
        GuiToolkit.addHoverHighlight((GuiElement)addGroup, (int)0, (int)0, (boolean)true);
        addGroup.setEnabledCallback(() -> advancedUI && DEConfig.configUiEnableAddGroupButton);
        addGroup.setHoverText(I18n.m_118938_((String)"gui.draconicevolution.item_config.add_group.info", (Object[])new Object[0]));
        addGroup.onReload(e -> ((GuiButton)e.setMaxXPos(this.f_96543_, false)).setYPos(this.deleteZone.isEnabled() ? this.deleteZone.maxYPos() + 1 : 0));
        addGroup.onPressed(() -> {
            PropertyContainer newGroup = new PropertyContainer(this, true);
            this.propertyContainers.add(newGroup);
            this.advancedContainer.addChild((GuiElement)newGroup);
            ((GuiManipulable)newGroup.setMaxXPos((int)this.advancedContainer.getMouseX() + 5, false)).setYPos((int)this.advancedContainer.getMouseY() - 5);
            newGroup.updatePosition();
            newGroup.startDragging();
        });
    }

    private GuiButton createOptionsButton() {
        ArrayList<Tripple> options = new ArrayList<Tripple>();
        options.add(new Tripple(() -> DEConfig.configUiShowUnavailable ? "hide_unavailable" : "show_unavailable", () -> DEConfig.configUiShowUnavailable ? "hide_unavailable" : "show_unavailable", () -> {
            DEConfig.modifyClientProperty("showUnavailable", tag -> tag.setBoolean(!DEConfig.configUiShowUnavailable), "itemConfigGUI");
            this.advancedContainer.reloadElement();
            this.advancedContainer.reloadElement();
        }));
        options.add(new Tripple(() -> DEConfig.configUiEnableSnapping ? "disable_snapping" : "enable_snapping", () -> "disable_snapping", () -> DEConfig.modifyClientProperty("enableSnapping", tag -> tag.setBoolean(!DEConfig.configUiEnableSnapping), "itemConfigGUI")));
        options.add(new Tripple(() -> DEConfig.configUiEnableVisualization ? "disable_visualization" : "enable_visualization", () -> "disable_visualization", () -> DEConfig.modifyClientProperty("enableVisualization", tag -> tag.setBoolean(!DEConfig.configUiEnableVisualization), "itemConfigGUI")));
        options.add(new Tripple(() -> DEConfig.configUiEnableAddGroupButton ? "hide_group_button" : "show_group_button", null, () -> DEConfig.modifyClientProperty("enableAddGroupButton", tag -> tag.setBoolean(!DEConfig.configUiEnableAddGroupButton), "itemConfigGUI")));
        options.add(new Tripple(() -> DEConfig.configUiEnableDeleteZone ? "hide_delete_zone" : "show_delete_zone", null, () -> {
            DEConfig.modifyClientProperty("enableDeleteZone", tag -> tag.setBoolean(!DEConfig.configUiEnableDeleteZone), "itemConfigGUI");
            this.advancedContainer.reloadElement();
        }));
        options.add(new Tripple(() -> DEConfig.configUiEnableAdvancedXOver ? "disable_adv_xover" : "enable_adv_xover", () -> DEConfig.configUiEnableAdvancedXOver ? "disable_adv_xover" : "enable_adv_xover", () -> {
            DEConfig.modifyClientProperty("enableAdvancedXOver", tag -> tag.setBoolean(!DEConfig.configUiEnableAdvancedXOver), "itemConfigGUI");
            this.advancedContainer.reloadElement();
        }));
        GuiButton optionsButton = this.toolkit.createThemedIconButton(this.mainUI, "gear");
        optionsButton.setPos(this.toggleAdvanced.maxXPos(), this.toggleAdvanced.yPos());
        optionsButton.setHoverText(I18n.m_118938_((String)"gui.draconicevolution.item_config.options", (Object[])new Object[0]));
        optionsButton.setEnabledCallback(() -> advancedUI);
        optionsButton.onPressed(() -> {
            StandardDialog dialog = new StandardDialog(this.advancedContainer);
            dialog.setHeading(I18n.m_118938_((String)"gui.draconicevolution.item_config.options", (Object[])new Object[0]));
            dialog.setDefaultRenderer(e -> I18n.m_118938_((String)("gui.draconicevolution.item_config." + (String)((Supplier)e.getA()).get()), (Object[])new Object[0]));
            dialog.setToolTipHandler((key, element) -> {
                if (key.getB() != null) {
                    element.setHoverText(e -> I18n.m_118938_((String)("gui.draconicevolution.item_config." + (String)((Supplier)key.getB()).get() + ".info"), (Object[])new Object[0])).setHoverTextDelay(20);
                }
            });
            dialog.setSelectionListener(e -> ((Runnable)e.getC()).run());
            dialog.addItems((Collection)options);
            dialog.setPos(optionsButton.maxXPos() + 2, optionsButton.yPos() - 2);
            dialog.show();
            dialog.normalizePosition();
        });
        return optionsButton;
    }

    protected static GuiScrollElement createPropertyList() {
        GuiScrollElement element = new GuiScrollElement();
        element.setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH);
        element.setStandardScrollBehavior();
        element.setReloadOnUpdate(true);
        element.getVerticalScrollBar().setBackgroundElement((GuiElement)new ThemedElements.ScrollBar(true));
        element.getVerticalScrollBar().setSliderElement((GuiElement)new ThemedElements.ScrollBar(false));
        ((GuiSlideControl)element.getVerticalScrollBar().setXSize(6)).setInsets(0, 0, 0, 0);
        element.getVerticalScrollBar().updateElements();
        return element;
    }

    private void loadSelectedItemProperties() {
        this.simpleViewList.clearElements();
        this.simpleViewList.resetScrollPositions();
        PropertyProvider provider = ((ContainerConfigurableItem)this.container).findProvider(this.selectedItem);
        if (provider != null) {
            provider.getProperties().forEach(property -> {
                PropertyData data = new PropertyData(provider, (ConfigProperty)property, true);
                data.setChangeListener(data::sendToServer);
                this.simpleViewList.addElement((GuiElement)new PropertyElement(data, this, false));
            });
        }
    }

    private void onInventoryUpdate() {
        this.simpleViewList.getScrollingElements().stream().filter(e -> e instanceof PropertyElement).map(e -> ((PropertyElement)e).data).forEach(data -> data.pullData((ContainerConfigurableItem)this.container, true));
        this.propertyContainers.forEach(PropertyContainer::inventoryUpdate);
    }

    private void onItemSelected(boolean initialLoad) {
        if (this.selectedItem != ((ContainerConfigurableItem)this.container).getSelectedId() && !advancedUI) {
            this.selectedItem = ((ContainerConfigurableItem)this.container).getSelectedId();
            this.loadSelectedItemProperties();
        } else if (advancedUI && !initialLoad) {
            PropertyProvider provider = ((ContainerConfigurableItem)this.container).findProvider(((ContainerConfigurableItem)this.container).getSelectedId());
            if (provider == null || provider.getProperties().isEmpty()) {
                return;
            }
            StandardDialog dialog = new StandardDialog(this.mainUI);
            dialog.setHeading(I18n.m_118938_((String)"gui.draconicevolution.item_config.click_and_drag_to_place", (Object[])new Object[0]));
            dialog.setDefaultRenderer(e -> e.getDisplayName().getString());
            dialog.addItems(provider.getProperties());
            int x = (int)this.mainUI.getMouseX();
            dialog.setPos(x, this.f_96544_ - dialog.ySize());
            dialog.setSelectionListener(property -> {
                PropertyContainer newContainer = new PropertyContainer(this, false);
                this.advancedContainer.addChild((GuiElement)newContainer);
                ((GuiManipulable)newContainer.setMaxXPos((int)this.advancedContainer.getMouseX() + 5, false)).setYPos((int)this.advancedContainer.getMouseY() - 5);
                newContainer.updatePosition();
                newContainer.addProperty(new PropertyData(provider, (ConfigProperty)property, true));
                newContainer.startDragging();
                newContainer.setCancelZone(dialog.getRect().intersection(this.mainUI.getRect()));
            });
            dialog.setBlockOutsideClicks(true);
            dialog.setCloseOnOutsideClick(true);
            dialog.show();
        }
        if (!initialLoad) {
            GuiButton.playGenericClick();
        }
    }

    private boolean isFullSize() {
        return !advancedUI;
    }

    private boolean isUIHidden() {
        return advancedUI && hideUI;
    }

    private void toggleAdvanced() {
        boolean bl = advancedUI = !advancedUI;
        if (!advancedUI) {
            this.loadSelectedItemProperties();
        }
        this.mainUI.reloadElement();
        this.advancedContainer.reloadElement();
    }

    private void updateUIGeometry() {
        this.toolkit.centerX(this.mainUI, this.advancedContainer, 0);
        this.mainUI.setYSize((int)MathHelper.map((float)resizeAnim, (float)0.0f, (float)1.0f, (float)97.0f, (float)230.0f));
        float centerYPos = (float)this.f_96544_ / 2.0f - (float)this.mainUI.ySize() / 2.0f;
        float bottomYPos = this.f_96544_ - this.mainUI.ySize();
        float centerAnim = MathHelper.map((float)rePosAnim, (float)0.0f, (float)1.0f, (float)bottomYPos, (float)centerYPos);
        float actualPos = MathHelper.map((float)hideAnim, (float)0.0f, (float)1.0f, (float)centerAnim, (float)(this.f_96544_ - 15));
        this.mainUI.setYPos((int)actualPos);
        this.toolkit.placeInside(this.playerSlots, this.mainUI, GuiToolkit.LayoutPos.BOTTOM_CENTER, 0, -7);
        this.simpleViewList.setMaxYPos(this.playerSlots.yPos() - 5, true);
        this.simpleViewList.updateScrollElement();
        this.simpleViewList.resetScrollPositions();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if ((float)(this.isFullSize() ? 1 : 0) != resizeAnim || (float)(!advancedUI ? 1 : 0) != rePosAnim || (float)(this.isUIHidden() ? 1 : 0) != hideAnim) {
            resizeAnim = MathHelper.clip((float)MathHelper.approachLinear((float)resizeAnim, (float)(this.isFullSize() ? 1 : 0), (float)(0.15f * partialTicks)), (float)0.0f, (float)1.0f);
            hideAnim = MathHelper.clip((float)MathHelper.approachLinear((float)hideAnim, (float)(this.isUIHidden() ? 1 : 0), (float)(0.15f * partialTicks)), (float)0.0f, (float)1.0f);
            rePosAnim = MathHelper.clip((float)MathHelper.approachLinear((float)rePosAnim, (float)(!advancedUI ? 1 : 0), (float)(0.15f * partialTicks)), (float)0.0f, (float)1.0f);
            this.updateUIGeometry();
        }
        this.updateAnimations.removeIf(UpdateAnim::isFinished);
        this.updateAnimations.forEach(e -> e.tick(partialTicks));
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public void m_181908_() {
        Slot hovered;
        this.hoveredData = null;
        this.hoveredProvider = null;
        if (DEConfig.configUiEnableVisualization && (hovered = (Slot)((ContainerConfigurableItem)this.container).f_38839_.stream().filter(slot -> this.m_97774_((Slot)slot, this.getMouseX(), this.getMouseY())).findAny().orElse(null)) != null) {
            LazyOptional optionalCap = hovered.m_7993_().getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY);
            optionalCap.ifPresent(e -> {
                this.hoveredProvider = e;
            });
        }
        if (!this.bindReleased) {
            InputConstants.Key bind = KeyBindings.toolConfig.getKey();
            if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)bind.m_84873_())) {
                if (this.closeOnRelease) {
                    this.f_96541_.f_91074_.m_6915_();
                    this.m_7861_();
                } else {
                    this.bindReleased = true;
                }
            } else if (this.holdTimer > 10) {
                this.closeOnRelease = true;
            }
            ++this.holdTimer;
        }
        super.m_181908_();
    }

    public void m_7861_() {
        this.savePropertyConfig();
        super.m_7861_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.bindReleased) {
            this.closeOnRelease = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.bindReleased) {
            this.closeOnRelease = true;
        }
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        List<PropertyContainer> targets = this.propertyContainers.stream().filter(e -> e.isPreset).filter(e -> !e.boundKey.isEmpty()).filter(e -> e.boundKey.equals(input.toString())).filter(e -> e.modifier.isActive(null)).collect(Collectors.toList());
        targets.forEach(e -> e.dataList.forEach(data -> {
            data.sendToServer();
            this.updateAnimations.add(new UpdateAnim((PropertyData)data));
        }));
        if (!targets.isEmpty()) {
            GuiButton.playGenericClick();
        }
        if (KeyBindings.toolConfig.getKey().equals((Object)input)) {
            this.f_96541_.f_91074_.m_6915_();
            this.m_7861_();
            return true;
        }
        return false;
    }

    public static void checkKeybinding(int keyCode, int scanCode) {
        if (Minecraft.m_91087_().f_91080_ instanceof GuiConfigurableItem) {
            return;
        }
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyBindCache == null) {
            keyBindCache = new ArrayList<PropertyContainer>();
            CompoundTag nbt = ItemConfigDataHandler.retrieveData();
            List<PropertyContainer> containers = nbt.m_128437_("property_containers", 10).stream().map(e -> (CompoundTag)e).map(e -> PropertyContainer.deserialize(null, e)).toList();
            containers.stream().filter(e -> !e.boundKey.isEmpty() && e.globalKeyBind && e.isPreset).forEach(e -> keyBindCache.add((PropertyContainer)((Object)e)));
            keyBindCache.sort(Comparator.comparing(e -> e.modifier.ordinal()));
        }
        for (PropertyContainer container : keyBindCache) {
            if (!input.toString().equals(container.boundKey) || !container.modifier.isActive(null)) continue;
            container.dataList.forEach(PropertyData::sendToServer);
            GuiButton.playGenericClick();
            return;
        }
    }

    private void loadPropertyConfig() {
        CompoundTag nbt = ItemConfigDataHandler.retrieveData();
        advancedUI = nbt.m_128471_("advanced");
        hideUI = nbt.m_128471_("hidden");
        this.propertyContainers.forEach(arg_0 -> this.advancedContainer.removeChild(arg_0));
        this.propertyContainers.clear();
        this.propertyContainers.addAll(nbt.m_128437_("property_containers", 10).stream().map(e -> (CompoundTag)e).map(e -> PropertyContainer.deserialize(this, e)).collect(Collectors.toList()));
        this.propertyContainers.forEach(arg_0 -> this.advancedContainer.addChild(arg_0));
        resizeAnim = this.isFullSize() ? 1.0f : 0.0f;
        hideAnim = this.isUIHidden() ? 1.0f : 0.0f;
        rePosAnim = advancedUI ? 0.0f : 1.0f;
        this.updateUIGeometry();
        this.propertyContainers.forEach(PropertyContainer::inventoryUpdate);
    }

    protected void savePropertyConfig() {
        keyBindCache = null;
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("advanced", advancedUI);
        nbt.m_128379_("hidden", hideUI);
        nbt.m_128365_("property_containers", (Tag)this.propertyContainers.stream().map(PropertyContainer::serialize).collect(Collectors.toCollection(ListTag::new)));
        ItemConfigDataHandler.saveData(nbt);
    }

    protected static class UpdateAnim {
        private float tick = 0.0f;
        private PropertyData data;

        public UpdateAnim(PropertyData data) {
            this.data = data;
        }

        private void tick(float partialTicks) {
            this.tick += partialTicks;
            if (this.tick > 10.0f) {
                this.tick = 20.0f;
            }
        }

        private boolean isFinished() {
            return this.tick >= 10.0f;
        }

        public void render(int x, int y) {
            if (!this.isFinished()) {
                float offset = this.tick / 10.0f * 8.0f;
                RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                RenderSystem.m_69465_();
                MultiBufferSource.BufferSource source = RenderUtils.getGuiBuffers();
                PoseStack poseStack = new PoseStack();
                poseStack.m_85837_(0.0, 0.0, 300.0);
                GuiHelper.drawGradientRect((MultiBufferSource)source, (PoseStack)poseStack, (double)((float)x + offset), (double)((float)y + offset), (double)((float)(x + 16) - offset), (double)((float)(y + 16) - offset), (int)-2147418113, (int)-2147418113);
                RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                RenderSystem.m_69482_();
                source.m_109911_();
            }
        }
    }
}

