/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.TBasicMachine;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostContainer;
import com.brandon3055.draconicevolution.client.gui.ModuleGridRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TModularMachine
extends TBasicMachine {
    private final ModularGuiContainer<?> gui;
    public GuiButton moduleButton;
    public ModulePanel modulePanel;

    public TModularMachine(ModularGuiContainer<?> gui, TileBCore tile) {
        super(gui, tile);
        this.gui = gui;
    }

    public TModularMachine(ModularGuiContainer<?> gui, TileBCore tile, ContainerSlotLayout slotLayout) {
        super(gui, tile, slotLayout);
        this.gui = gui;
    }

    public TModularMachine(ModularGuiContainer<?> gui, TileBCore tile, boolean addPlayerSlots) {
        super(gui, tile, addPlayerSlots);
        this.gui = gui;
    }

    public TModularMachine(ModularGuiContainer<?> gui, TileBCore tile, ContainerSlotLayout slotLayout, boolean addPlayerSlots) {
        super(gui, tile, slotLayout, addPlayerSlots);
        this.gui = gui;
    }

    public void addDynamicButtons(List<GuiElement<?>> dynamicButtons) {
        ModuleHostContainer container;
        super.addDynamicButtons(dynamicButtons);
        AbstractContainerMenu abstractContainerMenu = this.gui.getContainer();
        if (abstractContainerMenu instanceof ModuleHostContainer && (container = (ModuleHostContainer)abstractContainerMenu).getModuleHost() != null) {
            this.moduleButton = this.toolkit.createThemedIconButton(this.background, "grid_small").onPressed(() -> this.modulePanel.toggleExpanded());
            this.modulePanel = new ModulePanel(this.background, container).setOrigin(() -> new Point(this.moduleButton.xPos(), this.moduleButton.yPos()));
            this.background.addChild((GuiElement)this.modulePanel);
            this.toolkit.jeiExclude((GuiElement)this.modulePanel);
            dynamicButtons.add((GuiElement<?>)this.moduleButton);
            TechLevel techLevel = container.getModuleHost().getHostTechLevel();
            StringBuilder gridName = new StringBuilder();
            gridName.append(container.getGrid().getWidth()).append("x").append(container.getGrid().getHeight());
            gridName.append(" ");
            gridName.append(techLevel.getTextColour());
            gridName.append(techLevel.getDisplayName().m_6879_().m_130940_(techLevel.getTextColour()).getString());
            gridName.append(ChatFormatting.RESET);
            gridName.append(" ");
            gridName.append(I18n.m_118938_((String)"gui.draconicevolution.modular_item.module_grid", (Object[])new Object[0]));
            this.moduleButton.setHoverText(gridName.toString());
        }
    }

    public class ModulePanel
    extends GuiElement<ModulePanel> {
        private GuiElement<?> parent;
        private ModuleGrid grid;
        private ModuleHostContainer container;
        private boolean expanded = false;
        private double animState = 0.0;
        private Supplier<Point> origin;
        private int extendedWidth;
        private int extendedHeight;
        private ModuleGridRenderer gridRenderer;
        private int colour;

        public ModulePanel(GuiElement<?> parent, ModuleHostContainer container) {
            this.parent = parent;
            this.grid = container.getGrid();
            this.container = container;
            TechLevel techLevel = container.getModuleHost().getHostTechLevel();
            this.colour = techLevel.getTextColour().m_126664_() ? techLevel.getTextColour().m_126665_() : 33023;
        }

        public ModulePanel setOrigin(Supplier<Point> origin) {
            this.origin = origin;
            return this;
        }

        public void toggleExpanded() {
            boolean bl = this.expanded = !this.expanded;
            if (this.expanded) {
                int maxWidth = Math.min(this.grid.getWidth() * 16, this.screenWidth - this.parent.maxXPos() - 8);
                int gridSize = (int)((double)maxWidth / (double)this.grid.getWidth());
                this.grid.setCellSize(gridSize);
                this.extendedWidth = gridSize * this.grid.getWidth() + 6;
                this.extendedHeight = gridSize * this.grid.getHeight() + 6;
            }
        }

        public void addChildElements() {
            super.addChildElements();
            this.gridRenderer = (ModuleGridRenderer)this.addChild(new ModuleGridRenderer(this.grid, TModularMachine.this.gui.playerInv));
            this.gridRenderer.renderBorder = false;
            this.gridRenderer.setEnabledCallback(() -> this.expanded && this.animState >= 1.0);
            TModularMachine.this.gui.setFloatingItemOverride(this.gridRenderer::renderStackOverride);
        }

        private void updatePosSize() {
            int xPos = this.parent.maxXPos() + 2;
            int yPos = this.parent.yPos();
            if (TModularMachine.this.infoPanel.isEnabled() && TModularMachine.this.infoPanel.animState > 0.0) {
                yPos = TModularMachine.this.infoPanel.maxYPos() + 2;
            }
            Rectangle expanded = new Rectangle(xPos, yPos, this.extendedWidth, this.extendedHeight);
            Point origin = this.origin.get();
            Rectangle collapsed = new Rectangle(origin.x, origin.y, 12, 12);
            double animState = Math.max(0.0, this.animState);
            int sx = (int)MathUtils.map((double)animState, (double)0.0, (double)1.0, (double)collapsed.x, (double)expanded.x);
            int sy = (int)MathUtils.map((double)animState, (double)0.0, (double)1.0, (double)collapsed.y, (double)expanded.y);
            int sw = (int)MathUtils.map((double)animState, (double)0.0, (double)1.0, (double)collapsed.width, (double)expanded.width);
            int sh = (int)MathUtils.map((double)animState, (double)0.0, (double)1.0, (double)collapsed.height, (double)expanded.height);
            this.setPosAndSize(sx, sy, sw, sh);
            this.gridRenderer.setPos(this.xPos() + 3, this.yPos() + 3);
            this.gridRenderer.setSize(this.xSize() - 6, this.ySize() - 6);
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            double fadeAlpha = Math.min(1.0, (this.animState + 0.5) * 2.0);
            int backgroundCol = 0x100010 | (int)(240.0 * fadeAlpha) << 24;
            int borderCol = this.colour | (int)(176.0 * fadeAlpha) << 24;
            MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
            PoseStack poseStack = new PoseStack();
            GuiHelper.drawHoverRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)this.xPos(), (double)this.yPos(), (double)this.xSize(), (double)this.ySize(), (int)backgroundCol, (int)borderCol, (boolean)false);
            getter.m_109911_();
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }

        public boolean onUpdate() {
            if (this.expanded && this.animState < 1.0) {
                this.animState = Math.min(1.0, this.animState + 0.2);
            } else if (!this.expanded && this.animState > -0.5) {
                this.animState = Math.max(-0.5, this.animState - 0.2);
            }
            this.updatePosSize();
            return super.onUpdate();
        }
    }
}

