/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiStackIcon;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTooltipBackground;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleRegistry;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SupportedModulesIcon
extends GuiElement<SupportedModulesIcon> {
    private Map<ModuleType<?>, List<Module<?>>> supported = new HashMap();
    private Map<Module<?>, ItemStack> moduleStacks = new HashMap();
    private GuiStackIcon stackIcon;
    private GuiElement<?> hoverElement;
    private boolean locked = false;
    private int page = Integer.MIN_VALUE;

    public SupportedModulesIcon(ModuleHost host) {
        for (Module module : ModuleRegistry.getRegistry().getValues()) {
            if (!host.isModuleSupported(module.createEntity())) continue;
            this.supported.computeIfAbsent(module.getType(), e -> new ArrayList()).add(module);
            this.moduleStacks.put(module, new ItemStack((ItemLike)module.getItem()));
        }
    }

    public void addChildElements() {
        int cols;
        this.stackIcon = ((GuiStackIcon)((GuiStackIcon)((GuiStackIcon)this.addChild((GuiElement)new GuiStackIcon())).bindPosition((GuiElement)this)).bindSize((GuiElement)this, false)).setDrawToolTip(false).setStackSupplier(() -> this.supported.isEmpty() ? ItemStack.f_41583_ : (ItemStack)ImmutableList.copyOf(this.moduleStacks.values()).get(TimeKeeper.interval((int)20, (int)this.moduleStacks.values().size())));
        int iconSize = 18;
        ArrayList<GuiElement> typeElements = new ArrayList<GuiElement>();
        for (ModuleType<?> type : this.supported.keySet()) {
            List<Module<?>> modules = this.supported.get(type);
            int maxWidth = modules.stream().map(this.moduleStacks::get).map(ItemStack::m_41611_).mapToInt(this::minWidth).max().orElse(10);
            maxWidth = Math.max(maxWidth, 100);
            GuiStackIcon icon = ((GuiStackIcon)((GuiStackIcon)new GuiStackIcon().setInsets(0, 0, 0, 0)).setSize(iconSize, iconSize)).setStackSupplier(() -> this.moduleStacks.get(modules.get(Math.floorMod(this.getPage(), modules.size()))));
            GuiLabel label = ((GuiLabel)((GuiLabel)new GuiLabel().setWrap(true).setSize(maxWidth + 4, iconSize)).setPos(icon.maxXPos() + 2, icon.yPos())).setAlignment(GuiAlign.LEFT).setComponentSupplier(() -> {
                ItemStack stack = this.moduleStacks.get(modules.get(Math.floorMod(this.getPage(), modules.size())));
                return stack.m_41786_().m_6881_().m_130938_(stack.m_41791_().getStyleModifier());
            });
            GuiElement element = new GuiElement();
            element.addChild((GuiElement)icon);
            element.addChild((GuiElement)label);
            element.setBoundsToChildren(1, 0, 1, 1);
            typeElements.add(element);
        }
        int count = typeElements.size();
        int elementWidth = typeElements.stream().mapToInt(GuiElement::xSize).max().orElse(10);
        for (cols = 1; count / cols * iconSize > cols * elementWidth && cols < count && (cols + 1) * elementWidth < this.screenWidth; ++cols) {
        }
        this.hoverElement = this.modularGui.getManager().addChild((GuiElement)new GuiTooltipBackground(), 100, false);
        ((GuiLabel)((GuiLabel)this.hoverElement.addChild((GuiElement)new GuiLabel((Component)new TranslatableComponent("gui.draconicevolution.modular_item.supported_modules").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.UNDERLINE)))).setAlignment(GuiAlign.LEFT).setSize(12, 8)).setTrim(false).setPos(this.hoverElement.xPos(), this.hoverElement.yPos() - 10);
        for (int i = 0; i < typeElements.size(); ++i) {
            GuiElement element = (GuiElement)typeElements.get(i);
            element.setPos(i % cols * elementWidth, i / cols * iconSize);
            this.hoverElement.addChild(element);
        }
        this.hoverElement.setBoundsToChildren(4, 4, 4, 4);
        this.hoverElement.setEnabledCallback(() -> this.getHoverTime() > 0 || this.locked);
        this.hoverElement.normalizePosition();
        ((GuiButton)((GuiButton)((GuiButton)((GuiButton)this.hoverElement.addChild((GuiElement)new GuiButton("<"))).setInsets(0, 1, 0, 0)).setSize(8, 8)).setFillColours(0, 0x60909090).setAlignment(GuiAlign.LEFT).setPos(this.hoverElement.maxXPos() - 26, this.hoverElement.yPos() + 4)).onPressed(() -> this.cyclePage(-1));
        ((GuiButton)((GuiButton)((GuiButton)((GuiButton)this.hoverElement.addChild((GuiElement)new GuiButton(">"))).setInsets(0, 0, 0, 1)).setSize(8, 8)).setFillColours(0, 0x60909090).setAlignment(GuiAlign.RIGHT).setPos(this.hoverElement.maxXPos() - 12, this.hoverElement.yPos() + 4)).onPressed(() -> this.cyclePage(1));
        this.hoverElement.modifyZOffset(150.0);
    }

    private int minWidth(Component component) {
        int w = this.fontRenderer.m_92852_((FormattedText)component) / 2;
        while (this.fontRenderer.m_92865_().m_92414_((FormattedText)component, w, component.m_7383_()).size() > 2) {
            ++w;
        }
        return w;
    }

    private int getPage() {
        return this.page == Integer.MIN_VALUE ? TimeKeeper.getClientTick() / 60 : this.page;
    }

    private void cyclePage(int dir) {
        this.page = this.page == Integer.MIN_VALUE ? 0 : this.page + dir;
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (GuiElement element : this.childElements) {
            if (!element.isEnabled()) continue;
            element.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
        if (!this.hoverElement.isEnabled() || this.locked) {
            return;
        }
        this.hoverElement.setYPos(mouseY + 4);
        if (mouseX > this.screenWidth / 2) {
            this.hoverElement.setMaxXPos(mouseX, false);
        } else {
            this.hoverElement.setXPos(mouseX);
        }
        this.hoverElement.normalizePosition();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY) && !this.locked) {
            this.locked = true;
            GuiButton.playGenericClick();
        } else if (this.locked) {
            this.locked = false;
            this.page = Integer.MIN_VALUE;
            GuiButton.playGenericClick();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

