/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.TGuiBase;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.client.gui.ModuleGridRenderer;
import com.brandon3055.draconicevolution.client.gui.modular.SupportedModulesIcon;
import com.brandon3055.draconicevolution.inventory.ContainerModularItem;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class GuiModularItem
extends ModularGuiContainer<ContainerModularItem> {
    private static AtomicBoolean infoExpanded = new AtomicBoolean(true);
    private ModuleGrid grid;
    private Inventory playerInv;
    private GuiToolkit<GuiModularItem> toolkit;
    private ModuleGridRenderer gridRenderer;
    private GuiToolkit.InfoPanel infoPanel;

    public GuiModularItem(ContainerModularItem container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
        this.grid = container.getGrid();
        this.playerInv = inv;
        int maxGridWidth = 226;
        int maxGridHeight = 145;
        int minXPadding = 30;
        int yPadding = 112;
        int cellSize = Math.min(Math.min(maxGridWidth / this.grid.getWidth(), maxGridHeight / this.grid.getHeight()), 16);
        int width = Math.max(218, cellSize * this.grid.getWidth() + minXPadding);
        int height = yPadding + cellSize * this.grid.getHeight();
        this.grid.setCellSize(cellSize);
        this.toolkit = new GuiToolkit((Screen)this, width, height);
    }

    public void addElements(GuiElementManager manager) {
        TGuiBase template = new TGuiBase((Screen)this);
        template.background = GuiTexture.newDynamicTexture((int)this.xSize(), (int)this.ySize(), () -> BCGuiSprites.getThemed((String)"background_dynamic"));
        template.background.onReload(guiTex -> guiTex.setPos(this.guiLeft(), this.guiTop()));
        SupportedModulesIcon supportedModules = (SupportedModulesIcon)new SupportedModulesIcon(((ContainerModularItem)this.container).getModuleHost()).setSize(12, 12);
        template.dynamicButtonPrePosition(e -> e.addLast(supportedModules));
        this.toolkit.loadTemplate((IGuiTemplate)template);
        template.title.setInsets(0, 14, 0, 12);
        template.addPlayerSlots(true, true, true);
        this.infoPanel = template.infoPanel;
        this.infoPanel.setExpandedHolder(infoExpanded);
        this.gridRenderer = new ModuleGridRenderer(((ContainerModularItem)this.container).getGrid(), this.playerInv);
        this.gridRenderer.setYPos(template.title.maxYPos() + 3);
        this.toolkit.centerX((GuiElement)this.gridRenderer, template.background, 0);
        template.background.addChild((GuiElement)this.gridRenderer);
        this.grid.setPosition(this.gridRenderer.xPos() - this.guiLeft(), this.gridRenderer.yPos() - this.guiTop());
        this.grid.setOnGridChange(this::updateInfoPanel);
        this.setFloatingItemOverride(this.gridRenderer::renderStackOverride);
        GuiElement equipModSlots = this.toolkit.createEquipModSlots(template.background, this.playerInv.f_35978_, true, e -> e.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent());
        equipModSlots.setPos(template.background.xPos() - 28, template.background.yPos());
        GuiButton itemConfig = this.toolkit.createThemedIconButton(template.background, "item_config");
        itemConfig.onReload(e -> e.setRelPos(template.background, 3, 3));
        itemConfig.setHoverText(I18n.m_118938_((String)"gui.draconicevolution.modular_item.open_item_config.info", (Object[])new Object[0]));
        itemConfig.onPressed(() -> DraconicNetwork.sendOpenItemConfig(false));
        GuiButton hudConfig = this.toolkit.createIconButton(template.background, 16, 9, 16, 8, BCGuiSprites.themedGetter((String)"hud_button"));
        hudConfig.onReload(e -> e.setPos(itemConfig.maxXPos() + 1, itemConfig.yPos()));
        hudConfig.setHoverText(I18n.m_118938_((String)"hud.draconicevolution.open_hud_config", (Object[])new Object[0]));
        hudConfig.onPressed(() -> this.f_96541_.m_91152_((Screen)new HudConfigGui()));
        template.background.addChild((GuiElement)supportedModules);
        this.updateInfoPanel();
    }

    private void updateInfoPanel() {
        this.infoPanel.clear();
        TechLevel techLevel = ((ContainerModularItem)this.container).getModuleHost().getHostTechLevel();
        StringBuilder gridName = new StringBuilder();
        gridName.append(this.grid.getWidth()).append("x").append(this.grid.getHeight());
        gridName.append(" ");
        gridName.append(techLevel.getDisplayName().m_6879_().m_130940_(techLevel.getTextColour()).getString());
        gridName.append(" ");
        gridName.append(I18n.m_118938_((String)"gui.draconicevolution.modular_item.module_grid", (Object[])new Object[0]));
        this.infoPanel.addDynamicLabel(gridName::toString, 12);
        LinkedHashMap<Component, Component> nameStatMap = new LinkedHashMap<Component, Component>();
        this.grid.getModuleHost().addInformation(nameStatMap, ((ContainerModularItem)this.container).getModuleContext());
        for (Component name : nameStatMap.keySet()) {
            this.infoPanel.addLabeledValue(ChatFormatting.GOLD + name.getString(), 6, 10, () -> ChatFormatting.GRAY + ((Component)nameStatMap.get(name)).getString(), true);
        }
        this.reloadGui();
    }

    protected void drawSlotOverlay(Slot slot, boolean occluded) {
        if (slot.m_6657_() && slot.m_7993_().getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            int y = slot.f_40221_;
            int x = slot.f_40220_;
            int light = -268971;
            int dark = -763643;
            MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
            GuiHelperOld.drawShadedRect((VertexConsumer)getter.m_6299_(GuiHelper.transColourType), (double)(x - 1), (double)(y - 1), (double)18.0, (double)18.0, (double)1.0, (int)0, (int)dark, (int)light, (int)GuiElement.midColour((int)light, (int)dark), (double)0.0);
            if (slot.m_7993_() == ((ContainerModularItem)this.container).hostStack) {
                GuiHelperOld.drawBorderedRect((VertexConsumer)getter.m_6299_(GuiHelper.transColourType), (double)x, (double)y, (double)16.0, (double)16.0, (double)1.0, (int)0x50FF0000, (int)-65536, (double)0.0);
            }
            getter.m_109911_();
        }
    }
}

