/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.items.ModuleItem;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;

public class ModuleGridRenderer
extends GuiElement<ModuleGridRenderer> {
    private ModuleGrid grid;
    private Inventory player;
    private boolean doubleClick;
    private long lastClickTime;
    private int lastClickButton;
    private boolean canDrop = false;
    private ModuleGrid.GridPos lastClickPos;
    private List<Component> lastError = null;
    private int lastErrorTime = 0;
    public boolean renderBorder = true;
    private ModuleGrid.GridPos hoverCell = null;
    private int hoverTime = 0;

    public ModuleGridRenderer(ModuleGrid grid, Inventory player) {
        this.grid = grid;
        this.player = player;
        this.setSize(grid.getWidth() * grid.getCellSize(), grid.getHeight() * grid.getCellSize());
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
        PoseStack poseStack = new PoseStack();
        int light = GuiToolkit.Palette.BG.accentLight();
        int dark = GuiToolkit.Palette.BG.accentDark();
        int fill = GuiToolkit.Palette.BG.fill();
        if (this.renderBorder) {
            GuiHelper.drawShadedRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)(this.xPos() - 2), (double)(this.yPos() - 2), (double)(this.xSize() + 4), (double)(this.ySize() + 4), (double)1.0, (int)0, (int)light, (int)dark, (int)fill);
            GuiHelper.drawShadedRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)(this.xPos() - 1), (double)(this.yPos() - 1), (double)(this.xSize() + 2), (double)(this.ySize() + 2), (double)1.0, (int)0, (int)dark, (int)light, (int)fill);
        }
        GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)this.xPos(), (double)this.yPos(), (double)this.xSize(), (double)this.ySize(), (int)ModuleGridRenderer.midColour((int)light, (int)dark));
        int s = this.grid.getCellSize();
        for (int x = 0; x < this.grid.getWidth(); ++x) {
            for (int y = 0; y < this.grid.getHeight(); ++y) {
                int xPos = this.xPos() + x * s;
                int yPos = this.yPos() + y * s;
                this.renderCell((MultiBufferSource)getter, xPos, yPos, s, x, y, mouseX, mouseY, GuiHelper.isInRect((int)xPos, (int)yPos, (int)s, (int)s, (double)mouseX, (double)mouseY), partialTicks);
            }
        }
        getter.m_109911_();
    }

    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        boolean carrying = !this.player.f_35978_.f_36096_.m_142621_().m_41619_();
        MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_(0.0, 0.0, (double)this.getRenderZLevel());
        if (this.isMouseOver(mouseX, mouseY) && this.lastError != null) {
            this.renderTooltip(poseStack, this.lastError, mouseX, mouseY);
            return true;
        }
        for (ModuleEntity<ModuleGridRenderer> moduleEntity : this.grid.getModuleHost().getModuleEntities()) {
            int cs = this.grid.getCellSize();
            int mw = moduleEntity.getWidth() * cs;
            int mh = moduleEntity.getHeight() * cs;
            int x = this.xPos() + moduleEntity.getGridX() * cs;
            int y = this.yPos() + moduleEntity.getGridY() * cs;
            boolean mouseOver = GuiHelper.isInRect((int)x, (int)y, (int)mw, (int)mh, (double)mouseX, (double)mouseY);
            if (!moduleEntity.renderModuleOverlay(this, this.grid.container.getModuleContext(), (MultiBufferSource)getter, poseStack, x, y, mw, mh, mouseX, mouseY, partialTicks, mouseOver ? this.hoverTime : 0)) continue;
            return true;
        }
        getter.m_109911_();
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public void renderCell(MultiBufferSource getter, int x, int y, int size, int cellX, int cellY, double mouseX, double mouseY, boolean mouseOver, float partialTicks) {
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_(0.0, 0.0, (double)this.getRenderZLevel());
        ModuleGrid.GridPos cell = this.grid.getCell(cellX, cellY);
        if (cell.hasEntity()) {
            ModuleEntity<ModuleGridRenderer> entity = cell.getEntity();
            int cs = this.grid.getCellSize();
            int mw = entity.getWidth() * cs;
            int mh = entity.getHeight() * cs;
            if (cell.isActualEntityPos()) {
                entity.renderModule(this, getter, poseStack, x, y, mw, mh, mouseX, mouseY, false, partialTicks);
            }
        } else {
            GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)(x + 1), (double)(y + 1), (double)(size - 2), (double)(size - 2), (int)(BCConfig.darkMode ? -8355712 : -11513776));
            if (mouseOver) {
                GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)x, (double)y, (double)size, (double)size, (int)0x50FFFFFF);
            }
        }
    }

    public boolean renderStackOverride(ItemStack stack, int x, int y, String altText) {
        Module<?> module;
        if (this.isMouseOver((x += 8) + this.modularGui.guiLeft(), (y += 8) + this.modularGui.guiTop()) && (module = ModuleItem.getModule(stack)) != null) {
            ModuleEntity<ModuleGridRenderer> entity = module.createEntity();
            int cs = this.grid.getCellSize();
            int mw = module.getProperties().getWidth() * cs;
            int mh = module.getProperties().getHeight() * cs;
            PoseStack poseStack = new PoseStack();
            poseStack.m_85837_(0.0, 0.0, (double)this.getRenderZLevel());
            MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
            entity.renderModule(this, (MultiBufferSource)getter, poseStack, x - mw / 2, y - mh / 2, mw, mh, x, y, true, this.mc.m_91297_());
            getter.m_109911_();
            if (stack.m_41613_() > 1 || altText != null) {
                BCFontRenderer font = this.fontRenderer;
                String s = altText == null ? String.valueOf(stack.m_41613_()) : altText;
                poseStack.m_85837_(0.0, 0.0, 250.0);
                float f = (float)(x - font.m_92895_(s)) + (float)mw / 2.0f + 1.0f;
                Objects.requireNonNull(font);
                font.m_92750_(poseStack, s, f, (float)(y - 9) + (float)mh / 2.0f + 2.0f, 0xFFFFFF);
                poseStack.m_85837_(0.0, 0.0, -250.0);
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.canDrop = false;
        this.lastError = null;
        if (this.isMouseOver(mouseX, mouseY)) {
            InputConstants.Key mouseKey = InputConstants.Type.MOUSE.m_84895_(button);
            boolean pickBlock = this.mc.f_91066_.f_92097_.isActiveAndMatches(mouseKey);
            ModuleGrid.GridPos cell = this.getCellAtPos(mouseX, mouseY, true);
            long i = Util.m_137550_();
            boolean bl = this.doubleClick = i - this.lastClickTime < 250L && this.lastClickButton == button && this.getCellAtPos(mouseX, mouseY, false).equals(this.lastClickPos);
            if (cell.isValidCell()) {
                ModuleEntity<ModuleGridRenderer> entity = cell.getEntity();
                if (entity != null) {
                    int yPos;
                    int cs = this.grid.getCellSize();
                    int mw = entity.getWidth() * cs;
                    int mh = entity.getHeight() * cs;
                    int xPos = this.xPos() + entity.getGridX() * cs;
                    if (entity.clientModuleClicked(this, this.player.f_35978_, xPos, yPos = this.yPos() + entity.getGridY() * cs, mw, mh, mouseX, mouseY, button)) {
                        return true;
                    }
                }
                if (this.player.f_35978_.f_36096_.m_142621_().m_41619_()) {
                    if (pickBlock) {
                        this.handleGridClick(cell, mouseX, mouseY, button, ClickType.CLONE);
                    } else {
                        boolean shiftClick = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344);
                        ClickType clicktype = ClickType.PICKUP;
                        if (shiftClick) {
                            clicktype = ClickType.QUICK_MOVE;
                        }
                        this.handleGridClick(cell, mouseX, mouseY, button, clicktype);
                    }
                } else {
                    this.canDrop = true;
                }
            }
            this.lastClickTime = i;
            this.lastClickPos = this.getCellAtPos(mouseX, mouseY, false);
            this.lastClickButton = button;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        ModuleGrid.GridPos cell = this.getCellAtPos(mouseX, mouseY, true);
        if (this.doubleClick && button == 0) {
            this.handleGridClick(cell, mouseX, mouseY, button, ClickType.PICKUP_ALL);
            this.doubleClick = false;
            this.lastClickTime = 0L;
        } else if (this.canDrop) {
            this.handleGridClick(cell, mouseX, mouseY, button, ClickType.PICKUP);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected void handleGridClick(ModuleGrid.GridPos cell, double mouseX, double mouseY, int mouseButton, ClickType type) {
        float x = 0.5f;
        float y = 0.5f;
        ModuleEntity<?> entity = cell.getEntity();
        if (entity != null) {
            int cs = this.grid.getCellSize();
            int mw = entity.getWidth() * cs;
            int mh = entity.getHeight() * cs;
            int mx = this.xPos() + entity.getGridX() * cs;
            int my = this.yPos() + entity.getGridY() * cs;
            x = (float)(mouseX - (double)mx) / (float)mw;
            y = (float)(mouseY - (double)my) / (float)mh;
        }
        DraconicNetwork.sendModuleContainerClick(cell, x, y, mouseButton, type);
        InstallResult result = this.grid.cellClicked(cell, x, y, mouseButton, type);
        if (result != null && result.resultType != InstallResult.InstallResultType.YES && result.resultType != InstallResult.InstallResultType.OVERRIDE) {
            this.lastError = result.reason;
            this.lastErrorTime = 0;
        }
    }

    private ModuleGrid.GridPos getCellAtPos(double xPos, double yPos, boolean withPlaceOffset) {
        int cs = this.grid.getCellSize();
        int x = (int)((xPos - (double)this.xPos()) / (double)cs);
        int y = (int)((yPos - (double)this.yPos()) / (double)cs);
        Module<?> module = ModuleItem.getModule(this.player.f_35978_.f_36096_.m_142621_());
        if (module != null && withPlaceOffset) {
            int mw = module.getProperties().getWidth() * cs;
            int mh = module.getProperties().getHeight() * cs;
            x = (int)((xPos - (double)this.xPos() - (double)mw / 2.0 + (double)cs / 2.0) / (double)cs);
            y = (int)((yPos - (double)this.yPos() - (double)mh / 2.0 + (double)cs / 2.0) / (double)cs);
        }
        return this.grid.getCell(x, y);
    }

    public boolean onUpdate() {
        ModuleGrid.GridPos cell = this.getCellAtPos(this.getMouseX(), this.getMouseY(), false);
        if (cell.hasEntity()) {
            ModuleEntity<?> entity = cell.getEntity();
            if ((cell = this.grid.getCell(entity.getGridX(), entity.getGridY())).equals(this.hoverCell)) {
                ++this.hoverTime;
            } else {
                this.hoverTime = 0;
                this.hoverCell = cell;
            }
        } else {
            this.hoverTime = 0;
        }
        if (this.lastError != null && this.lastErrorTime++ > 100) {
            this.lastError = null;
        }
        return super.onUpdate();
    }
}

