/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSlideIndicator;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.DEGuiSprites;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorCore;
import com.brandon3055.draconicevolution.inventory.ContainerReactor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GuiReactor
extends ModularGuiContainer<ContainerReactor> {
    private Player player;
    private final TileReactorCore tile;
    public TileReactorComponent component = null;
    private static double compPanelAnim = 0.0;
    private static boolean compPanelExtended = false;
    private GuiElement<?> compPanel;
    protected GuiToolkit<GuiReactor> toolkit = new GuiToolkit((Screen)this, 248, 222);

    public GuiReactor(ContainerReactor container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
        this.player = inv.f_35978_;
        this.tile = (TileReactorCore)container.tile;
    }

    public void addElements(GuiElementManager manager) {
        ArrayList exclusions = new ArrayList();
        this.compPanel = new GuiBorderedRect(this.f_97735_ + this.f_97726_, this.f_97736_ + 125, 0, 91);
        manager.addChild((GuiElement)this.compPanel);
        exclusions.add(this.compPanel);
        manager.setJeiExclusions(() -> exclusions);
        GuiTexture background = (GuiTexture)manager.addChild((GuiElement)((GuiTexture)new GuiTexture(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, DEGuiSprites.get("reactor/background")){

            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                super.renderElement(minecraft, mouseX, mouseY, partialTicks);
                RenderTileReactorCore.renderGUI(GuiReactor.this.tile, GuiReactor.this.f_97735_ + GuiReactor.this.f_97726_ / 2, GuiReactor.this.f_97736_ + 70);
            }
        }.onReload(e -> e.setPosAndSize(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_))));
        background.addChild((GuiElement)((GuiBorderedRect)new GuiBorderedRect(this.f_97735_ + 12, this.f_97736_ + 138, 162, 77).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD)).setColours(-16777216, -1));
        int y = this.f_97736_ + 140;
        background.addChild((GuiElement)((GuiLabel)((GuiLabel)((GuiLabel)new GuiLabel(this.f_97735_ + 10 + 5, y, 162, 8, I18n.m_118938_((String)"gui.draconicevolution.reactor.core_volume", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(49407).setHoverText(I18n.m_118938_((String)"gui.draconicevolution.reactor.core_volume.info", (Object[])new Object[0]))).setHoverTextDelay(2)));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.f_97735_ + 13 + 5, y += 8, 162, 8, "").setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setDisplaySupplier(() -> MathUtils.round((double)((this.tile.reactableFuel.get() + this.tile.convertedFuel.get()) / 1296.0), (double)100.0) + " m^3").setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        background.addChild((GuiElement)((GuiLabel)((GuiLabel)((GuiLabel)new GuiLabel(this.f_97735_ + 10 + 5, y += 11, 162, 8, I18n.m_118938_((String)"gui.draconicevolution.reactor.gen_rate", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(49407).setHoverText(I18n.m_118938_((String)"gui.draconicevolution.reactor.gen_rate.info", (Object[])new Object[0]))).setHoverTextDelay(2)));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.f_97735_ + 13 + 5, y += 8, 162, 8, "").setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setDisplaySupplier(() -> Utils.addCommas((int)((int)this.tile.generationRate.get())) + " OP/t").setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        background.addChild((GuiElement)((GuiLabel)((GuiLabel)((GuiLabel)new GuiLabel(this.f_97735_ + 10 + 5, y += 11, 162, 8, I18n.m_118938_((String)"gui.draconicevolution.reactor.field_rate", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(49407).setHoverText(I18n.m_118938_((String)"gui.draconicevolution.reactor.field_rate.info", (Object[])new Object[0]))).setHoverTextDelay(2)));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.f_97735_ + 13 + 5, y += 8, 162, 8, "").setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setDisplaySupplier(() -> {
            double inputRate = (double)this.tile.fieldDrain.get() / (1.0 - this.tile.shieldCharge.get() / this.tile.maxShieldCharge.get());
            return Utils.addCommas((int)((int)Math.min(inputRate, 2.147483647E9))) + " OP/t";
        }).setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        background.addChild((GuiElement)((GuiLabel)((GuiLabel)((GuiLabel)new GuiLabel(this.f_97735_ + 10 + 5, y += 11, 162, 8, I18n.m_118938_((String)"gui.draconicevolution.reactor.convert_rate", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(49407).setHoverText(I18n.m_118938_((String)"gui.draconicevolution.reactor.convert_rate.info", (Object[])new Object[0]))).setHoverTextDelay(2)));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.f_97735_ + 13 + 5, y += 8, 162, 8, "").setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setDisplaySupplier(() -> Utils.addCommas((int)((int)Math.round(this.tile.fuelUseRate.get() * 1000000.0))) + " nb/t").setAlignment(GuiAlign.LEFT).setShadow(false).setTextColour(0xB0B0B0));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.f_97735_ + 13 + 5, this.f_97736_ + 139, 161, 77, I18n.m_118938_((String)"gui.draconicevolution.reactor.go_boom_now", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE)).setAlignment(GuiAlign.LEFT).setWrap(true).setShadow(false).setTextColour(0xB0B0B0));
        this.toolkit.createPlayerSlots((GuiElement)background, false).setXPos(background.xPos() + 12).setMaxYPos(background.maxYPos() - 8, false).setEnabledCallback(() -> this.tile.reactorState.get() == TileReactorCore.ReactorState.COLD);
        this.toolkit.createSlots((GuiElement)background, 3, 1, 0).setPos(this.f_97735_ + 182, this.f_97736_ + 148).setEnabledCallback(() -> this.tile.reactorState.get() == TileReactorCore.ReactorState.COLD);
        this.toolkit.createSlots((GuiElement)background, 3, 1, 0).setPos(this.f_97735_ + 182, this.f_97736_ + 179).setEnabledCallback(() -> this.tile.reactorState.get() == TileReactorCore.ReactorState.COLD);
        background.addChild((GuiElement)new GuiLabel(this.f_97735_, this.f_97736_ + 2, this.f_97726_, 12, I18n.m_118938_((String)"gui.draconicevolution.reactor.title", (Object[])new Object[0])).setAlignment(GuiAlign.CENTER).setTextColour(65535));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.f_97735_ + 182, this.f_97736_ + 139, 54, 8, I18n.m_118938_((String)"gui.draconicevolution.reactor.fuel_in", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() == TileReactorCore.ReactorState.COLD)).setAlignment(GuiAlign.CENTER).setTrim(false));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.f_97735_ + 182, this.f_97736_ + 170, 54, 8, I18n.m_118938_((String)"gui.draconicevolution.reactor.chaos_out", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() == TileReactorCore.ReactorState.COLD)).setAlignment(GuiAlign.CENTER).setTrim(false));
        background.addChild((GuiElement)new GuiLabel(this.f_97735_ + 7, this.f_97736_ + 127, this.f_97726_, 12, "").setShadowStateSupplier(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE).setDisplaySupplier(() -> {
            Object s = ((TileReactorCore.ReactorState)this.tile.reactorState.get()).localize();
            if (this.tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE && ClientEventHandler.elapsedTicks % 10 > 5) {
                s = ChatFormatting.DARK_RED + "**" + (String)s + "**";
            } else if (this.tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE) {
                s = ChatFormatting.DARK_RED + "--" + (String)s + "--";
            }
            return ChatFormatting.GOLD + I18n.m_118938_((String)"gui.draconicevolution.reactor.status", (Object[])new Object[0]) + ": " + (String)s;
        }).setAlignment(GuiAlign.LEFT));
        background.addChild((GuiElement)((GuiSlideIndicator)((GuiSlideIndicator)((GuiSlideIndicator)((GuiSlideIndicator)new GuiSlideIndicator(() -> this.tile.temperature.get() / 10000.0).setPos(this.f_97735_ + 10, this.f_97736_ + 5)).setSize(16, 112)).setSlideElement((GuiElement)new GuiTexture(16, 8, DEGuiSprites.get("reactor/pointer"))).setOffsets(-2, -1).setHoverText(element -> this.getTempStats())).setHoverTextDelay(5)));
        background.addChild((GuiElement)((GuiSlideIndicator)((GuiSlideIndicator)((GuiSlideIndicator)((GuiSlideIndicator)new GuiSlideIndicator(() -> this.tile.shieldCharge.get() / Math.max(this.tile.maxShieldCharge.get(), 1.0)).setPos(this.f_97735_ + 34, this.f_97736_ + 5)).setSize(16, 112)).setSlideElement((GuiElement)new GuiTexture(16, 8, DEGuiSprites.get("reactor/pointer"))).setOffsets(-2, -1).setHoverText(element -> this.getShieldStats())).setHoverTextDelay(5)));
        background.addChild((GuiElement)((GuiSlideIndicator)((GuiSlideIndicator)((GuiSlideIndicator)((GuiSlideIndicator)new GuiSlideIndicator(() -> (double)this.tile.saturation.get() / (double)Math.max(this.tile.maxSaturation.get(), 1L)).setPos(this.f_97735_ + 198, this.f_97736_ + 5)).setSize(16, 112)).setSlideElement((GuiElement)new GuiTexture(16, 8, DEGuiSprites.get("reactor/pointer"))).setOffsets(-2, -1).setHoverText(element -> this.getSaturationStats())).setHoverTextDelay(5)));
        background.addChild((GuiElement)((GuiSlideIndicator)((GuiSlideIndicator)((GuiSlideIndicator)((GuiSlideIndicator)new GuiSlideIndicator(() -> this.tile.convertedFuel.get() / Math.max(this.tile.reactableFuel.get() + this.tile.convertedFuel.get(), 1.0)).setPos(this.f_97735_ + 222, this.f_97736_ + 5)).setSize(16, 112)).setSlideElement((GuiElement)new GuiTexture(16, 8, DEGuiSprites.get("reactor/pointer"))).setOffsets(-2, -1).setHoverText(element -> this.getFuelStats())).setHoverTextDelay(5)));
        background.addChild((GuiElement)((GuiButton)new GuiButton(this.f_97735_ + 177, this.f_97736_ + 199, 64, 14, I18n.m_118938_((String)"gui.draconicevolution.reactor.charge", (Object[])new Object[0])).setEnabledCallback(this.tile::canCharge)).setBorderColours(-11184811, -8947849).setFillColour(-16777216).setTrim(false).onPressed(this.tile::chargeReactor));
        background.addChild((GuiElement)((GuiButton)new GuiButton(this.f_97735_ + 177, this.f_97736_ + 182, 64, 14, I18n.m_118938_((String)"gui.draconicevolution.reactor.activate", (Object[])new Object[0])).setEnabledCallback(this.tile::canActivate)).setBorderColours(-11184811, -8947849).setFillColour(-16777216).setTrim(false).onPressed(this.tile::activateReactor));
        background.addChild((GuiElement)((GuiButton)new GuiButton(this.f_97735_ + 177, this.f_97736_ + 199, 64, 14, I18n.m_118938_((String)"gui.draconicevolution.reactor.shutdown", (Object[])new Object[0])).setEnabledCallback(this.tile::canStop)).setBorderColours(-11184811, -8947849).setFillColour(-16777216).setTrim(false).onPressed(this.tile::shutdownReactor));
        background.addChild((GuiElement)((GuiButton)((GuiButton)new GuiButton(this.f_97735_ + 177, this.f_97736_ + 165, 64, 14, I18n.m_118938_((String)"gui.draconicevolution.reactor.sas", (Object[])new Object[0])).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setBorderColours(-11184811, -8947849).setRectFillColourGetter((hovering, disabled) -> this.tile.failSafeMode.get() ? -12566273 : -16777216).setTrim(false).onPressed(this.tile::toggleFailSafe).setHoverText(I18n.m_118938_((String)"gui.draconicevolution.reactor.sas.info", (Object[])new Object[0]))));
        background.addChild((GuiElement)((GuiButton)((GuiButton)((GuiButton)new GuiButton(this.f_97735_ + 177, this.f_97736_ + 138, 64, 24, I18n.m_118938_((String)"gui.draconicevolution.reactor.rs_mode", (Object[])new Object[0]).replaceAll("\\\\n", "\n")).setEnabledCallback(() -> this.tile.reactorState.get() != TileReactorCore.ReactorState.COLD && this.component != null && this.tile.reactorState.get() != TileReactorCore.ReactorState.BEYOND_HOPE)).setWrap(true).setBorderColours(-11184811, -8947849).setFillColour(-16777216).onPressed(() -> {
            compPanelExtended = !compPanelExtended;
        }).setInsets(5, 0, 5, 0)).setHoverText(I18n.m_118938_((String)"gui.draconicevolution.reactor.rs_mode.info", (Object[])new Object[0]))));
        background.addChild((GuiElement)((GuiLabel)new GuiLabel(this.f_97735_ + 175, this.f_97736_ + 138, 68, 80, "ETE").setEnabledCallback(() -> this.tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE)).setDisplaySupplier(() -> "Estimated\nTime\nUntil\nDetonation\n\n" + ChatFormatting.UNDERLINE + (String)(this.tile.explosionCountdown.get() >= 0 ? this.tile.explosionCountdown.get() / 20 + "s" : "Calculating..")).setWrap(true).setShadow(false).setTextColour(0xFF0000));
        y = 0;
        for (TileReactorComponent.RSMode mode : TileReactorComponent.RSMode.values()) {
            background.addChild((GuiElement)((GuiButton)((GuiButton)new GuiButton(this.f_97735_ + this.f_97726_ + 2, this.f_97736_ + 127 + y, 76, 10, I18n.m_118938_((String)("gui.draconicevolution.reactor.rs_mode_" + mode.name().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0])).setEnabledCallback(() -> compPanelAnim == 1.0 && this.component != null)).setRectFillColourGetter((hovering, disabled) -> {
                if (this.component != null && this.component.rsMode.get() == mode) {
                    return -5636096;
                }
                if (hovering) {
                    return -10132123;
                }
                return -16777216;
            }).setRectBorderColourGetter((hovering, disabled) -> {
                if (this.component != null && this.component.rsMode.get() == mode) {
                    return -5636096;
                }
                if (hovering) {
                    return -10132123;
                }
                return -16777216;
            }).onPressed(() -> {
                if (this.component != null) {
                    this.component.setRSMode(this.player, mode);
                }
            }).setHoverText(I18n.m_118938_((String)("gui.draconicevolution.reactor.rs_mode_" + mode.name().toLowerCase(Locale.ENGLISH) + ".info"), (Object[])new Object[0]))).setTrim(false));
            y += 11;
        }
    }

    public List<String> getTempStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.m_118938_((String)"gui.draconicevolution.reactor.reaction_temp", (Object[])new Object[0]));
        list.add(MathUtils.round((double)this.tile.temperature.get(), (double)10.0) + "C");
        return list;
    }

    public List<String> getShieldStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.m_118938_((String)"gui.draconicevolution.reactor.field_strength", (Object[])new Object[0]));
        if (this.tile.maxShieldCharge.get() > 0.0) {
            list.add(MathUtils.round((double)(this.tile.shieldCharge.get() / this.tile.maxShieldCharge.get() * 100.0), (double)100.0) + "%");
        }
        list.add(Utils.addCommas((int)((int)this.tile.shieldCharge.get())) + " / " + Utils.addCommas((int)((int)this.tile.maxShieldCharge.get())));
        return list;
    }

    public List<String> getSaturationStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.m_118938_((String)"gui.draconicevolution.reactor.energy_saturation", (Object[])new Object[0]));
        if (this.tile.maxSaturation.get() > 0L) {
            list.add(MathUtils.round((double)((double)this.tile.saturation.get() / (double)this.tile.maxSaturation.get() * 100.0), (double)100.0) + "%");
        }
        list.add(Utils.addCommas((long)this.tile.saturation.get()) + " / " + Utils.addCommas((long)this.tile.maxSaturation.get()));
        return list;
    }

    public List<String> getFuelStats() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.m_118938_((String)"gui.draconicevolution.reactor.fuel_conversion", (Object[])new Object[0]));
        if (this.tile.reactableFuel.get() + this.tile.convertedFuel.get() > 0.0) {
            list.add(MathUtils.round((double)(this.tile.convertedFuel.get() / (this.tile.reactableFuel.get() + this.tile.convertedFuel.get()) * 100.0), (double)100.0) + "%");
        }
        list.add(MathUtils.round((double)this.tile.convertedFuel.get(), (double)100.0) + " / " + MathUtils.round((double)(this.tile.convertedFuel.get() + this.tile.reactableFuel.get()), (double)100.0));
        return list;
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.tile.reactorState.get() == TileReactorCore.ReactorState.COLD != ((ContainerReactor)this.container).fuelSlots) {
            ((ContainerReactor)this.container).setSlotState();
        }
        if (compPanelExtended && (compPanelAnim < 1.0 || this.compPanel.xSize() != 80)) {
            if ((compPanelAnim += 0.1) > 1.0) {
                compPanelAnim = 1.0;
            }
            this.compPanel.setXSize((int)(compPanelAnim * 80.0));
        } else if (!compPanelExtended && compPanelAnim > 0.0) {
            if ((compPanelAnim -= 0.1) < 0.0) {
                compPanelAnim = 0.0;
            }
            this.compPanel.setXSize((int)(compPanelAnim * 80.0));
        }
        if (this.compPanel.isEnabled() && compPanelAnim == 0.0) {
            this.compPanel.setEnabled(false);
        } else if (!this.compPanel.isEnabled() && compPanelAnim > 0.0) {
            this.compPanel.setEnabled(true);
        }
    }
}

