/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.TBasicMachine;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGenerator;
import com.brandon3055.draconicevolution.client.gui.modular.TModularMachine;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class GuiGenerator
extends ModularGuiContainer<ContainerBCTile<TileGenerator>> {
    private static final RenderType modelType = RenderType.m_110446_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/generator/generator_2.png"));
    private static final CCModel storageModel;
    public Player player;
    private TileGenerator tile;
    protected GuiToolkit<GuiGenerator> toolkit = new GuiToolkit((Screen)this, GuiToolkit.GuiLayout.DEFAULT).setTranslationPrefix("gui.draconicevolution.generator");

    public GuiGenerator(ContainerBCTile<TileGenerator> container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.tile = (TileGenerator)container.tile;
        this.player = playerInventory.f_35978_;
    }

    public void addElements(GuiElementManager manager) {
        TBasicMachine template = (TBasicMachine)this.toolkit.loadTemplate((IGuiTemplate)new TModularMachine(this, this.tile));
        template.background.addChild((GuiElement)((StorageRenderer)new StorageRenderer().setPos(this.guiLeft(), this.guiTop())));
        GuiElement fuelSlots = this.toolkit.createSlots(template.background, 3, 1, 0, (x, y) -> ((ContainerBCTile)this.container).getSlotLayout().getSlotData(ContainerSlotLayout.SlotType.TILE_INV, x.intValue()), BCGuiSprites.get((String)"slots/fuel"));
        fuelSlots.zOffset += 100.0;
        fuelSlots.setPos(this.guiLeft() + 64, this.guiTop() + 28);
        template.addEnergyBar((IOPStorage)this.tile.opStorage);
        template.addEnergyItemSlot(true, ((ContainerBCTile)this.container).getSlotLayout().getSlotData(ContainerSlotLayout.SlotType.TILE_INV, 3));
        GuiButton modeButton = this.toolkit.createButton_old("", template.background);
        modeButton.setDisplaySupplier(() -> I18n.m_118938_((String)((TileGenerator.Mode)this.tile.mode.get()).unlocalizedName(), (Object[])new Object[0]));
        modeButton.setHoverText(element -> ChatFormatting.BLUE + I18n.m_118938_((String)(((TileGenerator.Mode)this.tile.mode.get()).unlocalizedName() + ".info"), (Object[])new Object[0]));
        modeButton.onButtonPressed(pressed -> this.tile.mode.set((Enum)((TileGenerator.Mode)this.tile.mode.get()).next(GuiGenerator.m_96638_() || pressed == 1)));
        modeButton.setSize(100, 14);
        modeButton.zOffset += 100.0;
        modeButton.getChildElements().forEach(e -> e.zOffset += 100.0);
        modeButton.setPos(template.playerSlots.maxXPos() - modeButton.xSize(), template.playerSlots.yPos() - modeButton.ySize() + 8);
        modeButton.setResetHoverOnClick(true);
        template.infoPanel.addLabeledValue(ChatFormatting.GOLD + this.toolkit.i18n("fuel_efficiency", new Object[0]), 6, 11, () -> ChatFormatting.GRAY + ((TileGenerator.Mode)this.tile.mode.get()).getEfficiency() + "%", true);
        template.infoPanel.addLabeledValue(ChatFormatting.GOLD + this.toolkit.i18n("output_power", new Object[0]), 6, 11, () -> ChatFormatting.GRAY + this.tile.productionRate.get() + " / " + ((TileGenerator.Mode)this.tile.mode.get()).powerOutput + " OP/t", true);
        template.infoPanel.addLabeledValue(ChatFormatting.GOLD + this.toolkit.i18n("current_fuel_value", new Object[0]), 6, 11, () -> ChatFormatting.GRAY + (String)(this.tile.fuelRemaining.get() == 0 ? "n/a" : this.tile.fuelRemaining.get() + " / " + this.tile.fuelValue.get()), true);
    }

    static {
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/generator/generator_storage.obj")).quads().ignoreMtl().parse();
        storageModel = CCModel.combine(map.values());
        storageModel.computeNormals();
    }

    private class StorageRenderer
    extends GuiElement<StorageRenderer> {
        private StorageRenderer() {
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            PoseStack mStack = new PoseStack();
            MultiBufferSource.BufferSource getter = RenderUtils.getGuiBuffers();
            ccrs.bind(modelType, (MultiBufferSource)getter);
            Matrix4 mat = new Matrix4(mStack);
            mat.translate((double)(this.xPos() + 90), (double)(this.yPos() + 45), 50.0);
            float mx = ((float)(mouseX - GuiGenerator.this.guiLeft()) / (float)GuiGenerator.this.xSize() - 0.5f) * 0.1f;
            float my = ((float)(mouseY - GuiGenerator.this.guiTop()) / (float)GuiGenerator.this.ySize() - 0.5f) * 0.1f;
            mat.apply((Transformation)new Rotation(2.61799387799145, 1.0, 0.0, 0.0).with((Transformation)new Rotation(0.17453292519943, (double)(-my), (double)(1.0f + mx), 0.0)));
            mat.scale(7.5);
            storageModel.render(ccrs, new IVertexOperation[]{mat});
            getter.m_109911_();
        }
    }
}

