/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEnergyBar;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEntityFilter;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEntityDetector;
import com.brandon3055.draconicevolution.client.gui.modular.TModularMachine;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class GuiEntityDetector
extends ModularGuiContainer<ContainerBCTile<TileEntityDetector>> {
    private TileEntityDetector tile;
    protected GuiToolkit<GuiEntityDetector> toolkit = new GuiToolkit((Screen)this, 300, 180).setTranslationPrefix("gui.draconicevolution.entity_detector");

    public GuiEntityDetector(ContainerBCTile<TileEntityDetector> container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.tile = (TileEntityDetector)container.tile;
    }

    public void addElements(GuiElementManager manager) {
        TModularMachine template = new TModularMachine(this, (TileBCore)this.tile, false);
        template.background = GuiTexture.newDynamicTexture((int)this.xSize(), (int)this.ySize(), () -> BCGuiSprites.getThemed((String)"background_dynamic"));
        template.background.onReload(guiTex -> guiTex.setPos(this.guiLeft(), this.guiTop()));
        this.toolkit.loadTemplate((IGuiTemplate)template);
        GuiElement bg = template.background;
        GuiEntityFilter filterUI = new GuiEntityFilter(this.tile.entityFilter);
        filterUI.setNodeBackgroundBuilder(() -> new GuiBorderedRect().set3DGetters(() -> GuiToolkit.Palette.Ctrl.fill((boolean)false), () -> GuiToolkit.Palette.Ctrl.accentLight((boolean)false), () -> GuiToolkit.Palette.Ctrl.accentDark((boolean)false)));
        filterUI.setScrollBarCustomizer(bar -> bar.setSliderElement((GuiElement)new GuiBorderedRect().setGetters(GuiToolkit.Palette.SubItem::accentDark, () -> 0)).getBackgroundElement().setEnabled(false));
        filterUI.setNodeTitleColour(GuiToolkit.Palette.Slot::text);
        ((GuiEntityFilter)filterUI.setRelPos(bg, 25, 14)).setMaxPos(bg.maxXPos() - 16, bg.maxYPos() - 30, true);
        bg.addChild((GuiElement)filterUI);
        GuiBorderedRect filterBG = new GuiBorderedRect();
        filterBG.set3DGetters(GuiToolkit.Palette.Slot::fill, GuiToolkit.Palette.Slot::accentDark, GuiToolkit.Palette.Slot::accentLight);
        filterBG.setBorderColourL(GuiToolkit.Palette.Slot::border3D);
        filterBG.setPosAndSize((GuiElement)filterUI);
        filterUI.addBackGroundChild((GuiElement)filterBG);
        GuiPopUpDialogBase.PopoutDialog popOutDialog = new GuiPopUpDialogBase.PopoutDialog(bg);
        popOutDialog.onReload(e -> e.setPosAndSize(bg));
        popOutDialog.addChild((GuiElement)filterUI);
        popOutDialog.addChild((GuiElement)((GuiLabel)new GuiLabel(I18n.m_118938_((String)"gui_tkt.brandonscore.click_out_close", (Object[])new Object[0])).onReload(e -> ((GuiLabel)((GuiLabel)e.setYPos(bg.maxYPos())).setXPos(bg.xPos())).setSize(200, 12))).setAlignment(GuiAlign.LEFT));
        GuiButton largeView = this.toolkit.createResizeButton(bg);
        largeView.setPos(filterBG.maxXPos() + 1, filterBG.maxYPos() - 12);
        largeView.onPressed(() -> {
            bg.removeChild((GuiElement)filterUI);
            popOutDialog.setPosAndSize(bg);
            ((GuiEntityFilter)filterUI.setRelPos(bg, 3, 3)).setSize(bg.xSize() - 6, bg.ySize() - 6);
            filterBG.setPosAndSize((GuiElement)filterUI);
            popOutDialog.show(100);
        });
        popOutDialog.setCloseCallback(() -> {
            ((GuiEntityFilter)filterUI.setRelPos(bg, 25, 14)).setMaxPos(bg.maxXPos() - 16, bg.maxYPos() - 30, true);
            filterBG.setPosAndSize((GuiElement)filterUI);
            bg.addChild((GuiElement)filterUI);
        });
        template.energyBar = this.toolkit.createEnergyBar(template.background, (IOPStorage)this.tile.opStorage);
        template.energyBar.setPos(template.background.xPos() + 6, template.background.yPos() + 6);
        ((GuiEnergyBar)template.energyBar.setXSize(14)).setMaxYPos(filterUI.yPos() - 4, true);
        ((GuiEnergyBar)((GuiEnergyBar)template.energyBar.setYPos(filterUI.yPos())).setMaxYPos(filterUI.maxYPos(), true)).setXPos(bg.xPos() + 7);
        GuiLabel rangeLabel = ((GuiLabel)template.background.addChild((GuiElement)new GuiLabel(this.guiLeft() + 4, filterUI.maxYPos() + 4, (this.xSize() - 4) / 5, 8, this.toolkit.i18n("range", new Object[0])))).setShadow(false);
        ((GuiButton)rangeLabel.addChild((GuiElement)new GuiButton(rangeLabel.xPos(), rangeLabel.maxYPos(), 16, 16, "-"))).onPressed(() -> this.tile.adjustRange(true, GuiEntityDetector.m_96638_()));
        ((GuiLabel)rangeLabel.addChild((GuiElement)new GuiLabel(rangeLabel.xPos() + rangeLabel.xSize() / 2 - 8, rangeLabel.maxYPos(), 16, 16))).setTrim(false).setDisplaySupplier(() -> Short.toString(this.tile.range.get()));
        ((GuiButton)rangeLabel.addChild((GuiElement)new GuiButton(rangeLabel.maxXPos() - 16, rangeLabel.maxYPos(), 16, 16, "+"))).onPressed(() -> this.tile.adjustRange(false, GuiEntityDetector.m_96638_()));
        GuiLabel rsMinLabel = ((GuiLabel)template.background.addChild((GuiElement)new GuiLabel(rangeLabel.maxXPos(), filterUI.maxYPos() + 4, (this.xSize() - 4) / 5, 8, this.toolkit.i18n("rsmin", new Object[0])))).setShadow(false);
        ((GuiButton)rsMinLabel.addChild((GuiElement)new GuiButton(rsMinLabel.xPos(), rsMinLabel.maxYPos(), 16, 16, "-"))).onPressed(() -> this.tile.adjustRSMin(true, GuiEntityDetector.m_96638_()));
        ((GuiLabel)rsMinLabel.addChild((GuiElement)new GuiLabel(rsMinLabel.xPos() + rsMinLabel.xSize() / 2 - 8, rsMinLabel.maxYPos(), 16, 16))).setTrim(false).setDisplaySupplier(() -> Integer.toString(this.tile.rsMinDetection.get()));
        ((GuiButton)rsMinLabel.addChild((GuiElement)new GuiButton(rsMinLabel.maxXPos() - 16, rsMinLabel.maxYPos(), 16, 16, "+"))).onPressed(() -> this.tile.adjustRSMin(false, GuiEntityDetector.m_96638_()));
        GuiLabel rsMaxLabel = ((GuiLabel)template.background.addChild((GuiElement)new GuiLabel(rsMinLabel.maxXPos(), filterUI.maxYPos() + 4, (this.xSize() - 4) / 5, 8, this.toolkit.i18n("rsmax", new Object[0])))).setShadow(false);
        ((GuiButton)rsMaxLabel.addChild((GuiElement)new GuiButton(rsMaxLabel.xPos(), rsMaxLabel.maxYPos(), 16, 16, "-"))).onPressed(() -> this.tile.adjustRSMax(true, GuiEntityDetector.m_96638_()));
        ((GuiLabel)rsMaxLabel.addChild((GuiElement)new GuiLabel(rsMaxLabel.xPos() + rsMaxLabel.xSize() / 2 - 8, rsMaxLabel.maxYPos(), 16, 16))).setTrim(false).setDisplaySupplier(() -> Integer.toString(this.tile.rsMaxDetection.get()));
        ((GuiButton)rsMaxLabel.addChild((GuiElement)new GuiButton(rsMaxLabel.maxXPos() - 16, rsMaxLabel.maxYPos(), 16, 16, "+"))).onPressed(() -> this.tile.adjustRSMax(false, GuiEntityDetector.m_96638_()));
        GuiLabel pulseRateLabel = ((GuiLabel)template.background.addChild((GuiElement)new GuiLabel(rsMaxLabel.maxXPos(), filterUI.maxYPos() + 4, (this.xSize() - 4) / 5, 8, this.toolkit.i18n("pulse_rate", new Object[0])))).setShadow(false);
        ((GuiButton)pulseRateLabel.addChild((GuiElement)new GuiButton(pulseRateLabel.xPos(), pulseRateLabel.maxYPos(), 16, 16, "-"))).onPressed(() -> this.tile.adjustPulseRate(true, GuiEntityDetector.m_96638_())).setDisabledStateSupplier(() -> !this.tile.pulseRsMode.get());
        ((GuiLabel)pulseRateLabel.addChild((GuiElement)new GuiLabel(pulseRateLabel.xPos() + pulseRateLabel.xSize() / 2 - 8, pulseRateLabel.maxYPos(), 16, 16))).setTrim(false).setDisplaySupplier(() -> Short.toString(this.tile.pulseRate.get()));
        ((GuiButton)pulseRateLabel.addChild((GuiElement)new GuiButton(pulseRateLabel.maxXPos() - 16, pulseRateLabel.maxYPos(), 16, 16, "+"))).onPressed(() -> this.tile.adjustPulseRate(false, GuiEntityDetector.m_96638_())).setDisabledStateSupplier(() -> !this.tile.pulseRsMode.get());
        GuiLabel pulseModeLabel = ((GuiLabel)template.background.addChild((GuiElement)new GuiLabel(pulseRateLabel.maxXPos(), filterUI.maxYPos() + 4, (this.xSize() - 4) / 5, 8, this.toolkit.i18n("pulse_mode", new Object[0])))).setShadow(false);
        ((GuiButton)pulseModeLabel.addChild((GuiElement)new GuiButton(pulseModeLabel.xPos(), pulseModeLabel.maxYPos(), pulseModeLabel.xSize(), 16))).onPressed(() -> this.tile.togglePulsemode()).setDisplaySupplier(() -> this.toolkit.i18n("pulse_mode." + (this.tile.pulseRsMode.get() ? "on" : "off"), new Object[0]));
    }
}

