/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.power.IOInfo;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEnergyBar;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiPickColourDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTooltipBackground;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.SlotDisableable;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.client.gui.modular.TModularMachine;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class GuiEnergyCore
extends ModularGuiContainer<ContainerBCTile<TileEnergyCore>> {
    private GuiToolkit<GuiEnergyCore> toolkit = new GuiToolkit((Screen)this, 180, 200).setTranslationPrefix("gui.draconicevolution.energy_core");
    public Player player;
    public TileEnergyCore tile;
    private GuiPickColourDialog frameColourDialog;
    private GuiPickColourDialog triangleColourDialog;
    private GuiPickColourDialog effectColourDialog;
    public Supplier<Boolean> hideJEI = () -> false;
    private static final BigDecimal MAX_BIGINT = new BigDecimal("9999e9999");

    public GuiEnergyCore(ContainerBCTile<TileEnergyCore> container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.tile = (TileEnergyCore)container.tile;
        this.player = playerInventory.f_35978_;
    }

    public void addElements(GuiElementManager manager) {
        TModularMachine temp = new TModularMachine(this, this.tile);
        temp.background = GuiTexture.newDynamicTexture((int)this.xSize(), (int)this.ySize(), () -> BCGuiSprites.getThemed((String)"background_dynamic"));
        temp.background.onReload(guiTex -> guiTex.setPos(this.guiLeft(), this.guiTop()));
        this.toolkit.loadTemplate((IGuiTemplate)temp);
        temp.title.setDisplaySupplier(() -> this.toolkit.i18n("title", new Object[]{this.tile.tier.get()}));
        ((ContainerBCTile)this.container).f_38839_.stream().filter(e -> e instanceof SlotDisableable).map(e -> (SlotDisableable)e).forEach(e -> e.setEnabled(() -> temp.background.isEnabled()));
        this.hideJEI = () -> !temp.background.isEnabled();
        GuiButton activate = ((GuiButton)((GuiButton)this.toolkit.createButton(() -> this.tile.active.get() ? "deactivate" : "activate", temp.background).setSize(temp.playerSlots.xSize(), 14)).setEnabledCallback(() -> !this.tile.active.get() && this.tile.isStructureValid())).onPressed(() -> this.tile.sendPacketToServer(e -> {}, 1));
        this.toolkit.placeOutside((GuiElement)activate, temp.playerSlots, GuiToolkit.LayoutPos.TOP_CENTER, 0, -3);
        GuiButton tierDown = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)this.toolkit.createButton("tier_down", temp.background).setSize(temp.playerSlots.xSize() / 2 - 1, 14)).setXPos(activate.xPos())).setMaxYPos(activate.yPos() - 1, false)).setEnabledCallback(() -> !this.tile.active.get())).setDisabledStateSupplier(() -> this.tile.tier.get() <= 1).onPressed(() -> this.tile.tier.dec());
        GuiButton tierUp = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)this.toolkit.createButton("tier_up", temp.background).setSize(temp.playerSlots.xSize() / 2 - 1, 14)).setMaxXPos(activate.maxXPos(), false)).setMaxYPos(activate.yPos() - 1, false)).setEnabledCallback(() -> !this.tile.active.get())).setDisabledStateSupplier(() -> this.tile.tier.get() >= 8).onPressed(() -> this.tile.tier.inc());
        GuiButton buildGuide = (GuiButton)((GuiButton)((GuiButton)((GuiButton)this.toolkit.createButton("build_guide", temp.background).setToggleStateSupplier(() -> this.tile.buildGuide.get()).onPressed(() -> this.tile.buildGuide.invert()).setEnabledCallback(() -> !this.tile.active.get())).setSize(temp.playerSlots.xSize(), 14)).setXPos(tierDown.xPos())).setMaxYPos(tierDown.yPos() - 1, false);
        GuiButton assemble = ((GuiButton)((GuiButton)this.toolkit.createButton("assemble", temp.background).setPosAndSize((GuiElement)activate)).setEnabledCallback(() -> !this.tile.isStructureValid())).onPressed(() -> this.tile.sendPacketToServer(e -> {}, 2));
        GuiButton disable = (GuiButton)((GuiButton)this.toolkit.createThemedIconButton(temp.background, "pwr_btn").setEnabledCallback(() -> this.tile.active.get())).onPressed(() -> this.tile.sendPacketToServer(e -> {}, 1)).setHoverText(this.toolkit.i18n("deactivate", new Object[0]));
        this.toolkit.placeInside((GuiElement)disable, temp.background, GuiToolkit.LayoutPos.TOP_LEFT, 3, 3);
        GuiLabel coreInvalidLabel = (GuiLabel)((GuiLabel)((GuiLabel)this.toolkit.createHeading("", temp.background).setLabelText(this.toolkit.i18n("core_invalid", new Object[0])).setAlignment(GuiAlign.CENTER).setTextColour(ChatFormatting.RED).setSize(temp.playerSlots.xSize(), 8)).setPos(temp.playerSlots.xPos(), temp.title.maxYPos() + 5)).setEnabledCallback(() -> !this.tile.active.get() && !this.tile.coreValid.get());
        GuiLabel stabInvalidLabel = (GuiLabel)((GuiLabel)((GuiLabel)this.toolkit.createHeading("", temp.background).setLabelText(this.toolkit.i18n("stabilizers_invalid", new Object[0])).setAlignment(GuiAlign.CENTER).setTextColour(ChatFormatting.RED).setSize(temp.playerSlots.xSize(), 8)).setPos(temp.playerSlots.xPos(), coreInvalidLabel.maxYPos() + 5)).setEnabledCallback(() -> !this.tile.active.get() && !this.tile.stabilizersValid.get());
        GuiLabel stabAdvLabel = (GuiLabel)((GuiLabel)((GuiLabel)this.toolkit.createHeading("", temp.background).setLabelText(this.toolkit.i18n("stabilizers_advanced", new Object[0])).setAlignment(GuiAlign.CENTER).setSize(temp.playerSlots.xSize(), 8)).setPos(temp.playerSlots.xPos(), stabInvalidLabel.maxYPos() + 5)).setEnabledCallback(() -> !this.tile.active.get() && !this.tile.stabilizersValid.get() && this.tile.reqAdvStabilizers());
        GuiTooltipBackground display = (GuiTooltipBackground)((GuiTooltipBackground)((GuiTooltipBackground)((GuiTooltipBackground)((GuiTooltipBackground)temp.background.addChild((GuiElement)new GuiTooltipBackground())).setBorderColor(() -> this.tile.tier.get() == 8 ? -43776 : -7864065).setBackgroundColor(() -> -267386864).setPos(temp.playerSlots.xPos(), temp.title.maxYPos() + 3)).setXSize(temp.playerSlots.xSize())).setMaxYPos(temp.playerSlots.yPos() - 2, true)).setEnabledCallback(() -> this.tile.active.get());
        String pfx = "mod_gui.brandonscore.energy_bar.";
        GuiEnergyBar energyBar = (GuiEnergyBar)((GuiEnergyBar)((GuiEnergyBar)display.addChild((GuiElement)new GuiEnergyBar())).setCapacitySupplier(() -> 1000000L).setEnergySupplier(() -> (long)(this.getEnergyDouble() * 1000000.0)).setSize(activate.xSize() - 6, 14)).setDrawHoveringText(false).setHoverText(e -> {
            int p1000 = (int)(this.getEnergyDouble() * 100000.0);
            return ChatFormatting.GOLD + I18n.m_118938_((String)(pfx + "stored"), (Object[])new Object[0]) + ": " + ChatFormatting.GRAY + this.tile.energy.getScientific() + " (" + (double)p1000 / 1000.0 + "%)";
        });
        this.toolkit.placeInside((GuiElement)energyBar, (GuiElement)display, GuiToolkit.LayoutPos.BOTTOM_CENTER, 0, -3);
        GuiLabel opLabel = ((GuiLabel)((GuiLabel)((GuiLabel)display.addChild((GuiElement)new GuiLabel(I18n.m_118938_((String)(pfx + "operational_potential"), (Object[])new Object[0])))).setSize(display.xSize(), 8)).setRelPos((GuiElement)display, 0, 6)).setTextColour(ChatFormatting.DARK_AQUA).setAlignment(GuiAlign.CENTER);
        GuiLabel energy = ((GuiLabel)((GuiLabel)((GuiLabel)display.addChild((GuiElement)new GuiLabel())).setDisplaySupplier(() -> this.tile.energy.getReadable() + (this.tile.energy.getEnergyStored() < 1000000 ? " " : "") + I18n.m_118938_((String)(pfx + "op"), (Object[])new Object[0])).setSize(display.xSize(), 8)).setPos(display.xPos(), opLabel.maxYPos() + 3)).setTextColour(ChatFormatting.GOLD).setAlignment(GuiAlign.CENTER);
        GuiLabel capLabel = (GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)display.addChild((GuiElement)new GuiLabel())).setDisplaySupplier(() -> I18n.m_118938_((String)(pfx + "capacity"), (Object[])new Object[0])).setSize(display.xSize(), 8)).setPos(display.xPos(), energy.maxYPos() + 4)).setTextColour(ChatFormatting.DARK_AQUA).setAlignment(GuiAlign.CENTER).setEnabledCallback(() -> !this.tile.energy.isUnlimited());
        GuiLabel capacity = (GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)display.addChild((GuiElement)new GuiLabel())).setDisplaySupplier(() -> this.tile.energy.getReadableCapacity() + I18n.m_118938_((String)(pfx + "op"), (Object[])new Object[0])).setSize(display.xSize(), 8)).setPos(display.xPos(), capLabel.maxYPos() + 3)).setTextColour(ChatFormatting.GOLD).setAlignment(GuiAlign.CENTER).setEnabledCallback(() -> !this.tile.energy.isUnlimited());
        GuiLabel ioLabel = ((GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)display.addChild((GuiElement)new GuiLabel())).setDisplaySupplier(() -> I18n.m_118938_((String)(pfx + "io"), (Object[])new Object[0])).setSize(display.xSize(), 8)).setXPos(display.xPos())).setYPosMod(() -> (this.tile.energy.isUnlimited() ? energy : capacity).maxYPos() + 4)).setTextColour(ChatFormatting.DARK_AQUA).setAlignment(GuiAlign.CENTER);
        GuiLabel io = ((GuiLabel)((GuiLabel)((GuiLabel)display.addChild((GuiElement)new GuiLabel())).setDisplaySupplier(this::genIOText).setSize(display.xSize(), 8)).setPos(display.xPos(), ioLabel.maxYPos() + 3)).setTextColour(ChatFormatting.GOLD).setAlignment(GuiAlign.CENTER);
        GuiTextField target = (GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)this.toolkit.createTextField((GuiElement)display, false).addBackground(e -> -265289728, e -> -5723992).setMaxLength(64).setTextColor(14803941).setSuggestion(this.toolkit.i18n("energy_target", new Object[0])).setHoverText(this.toolkit.i18n("energy_target_info", new Object[0]).replace("\n", "\n" + ChatFormatting.GRAY))).setSize(energyBar.xSize(), 12)).setXPos(energyBar.xPos())).setMaxYPos(energyBar.yPos() - 4, false)).setValue(this.tile.energyTarget.get()).onValueChanged(s -> this.tile.energyTarget.set(s)).setFilter(s -> GuiEnergyCore.validBigInt(GuiEnergyCore.sanitizeNumStr(s))).setEnabledCallback(() -> this.tile.energy.isUnlimited());
        GuiButton legacy = ((GuiButton)this.toolkit.createIconButton(temp.background, 12, 12, "legacy").onPressed(() -> this.tile.legacyRender.invert()).setHoverText(e -> this.tile.legacyRender.get() ? this.toolkit.i18n("legacy_true", new Object[0]) : this.toolkit.i18n("legacy_false", new Object[0]))).setToggleStateSupplier(() -> this.tile.legacyRender.get()).setToggleMode(true);
        this.toolkit.placeOutside((GuiElement)legacy, (GuiElement)display, GuiToolkit.LayoutPos.BOTTOM_RIGHT, -12, 0);
        GuiButton customColour = (GuiButton)((GuiButton)this.toolkit.createIconButton(temp.background, 12, 12, "rgb_checker").onPressed(() -> this.tile.customColour.invert()).setHoverText(e -> this.tile.customColour.get() ? this.toolkit.i18n("custom_colour_true", new Object[0]) : this.toolkit.i18n("custom_colour_false", new Object[0]))).setToggleStateSupplier(() -> this.tile.customColour.get()).setToggleMode(true).setEnabledCallback(() -> !legacy.getToggleState());
        this.toolkit.placeOutside((GuiElement)customColour, (GuiElement)legacy, GuiToolkit.LayoutPos.MIDDLE_LEFT, 0, 0);
        GuiButton setColour = ((GuiButton)((GuiButton)this.toolkit.createIconButton(temp.background, 12, 12, "color_picker").setHoverText(e -> this.toolkit.i18n("config_colour", new Object[0]))).setEnabledCallback(() -> customColour.getToggleState() && !legacy.getToggleState())).onPressed(() -> this.colourEditMode(temp.background, true));
        this.toolkit.placeOutside((GuiElement)setColour, (GuiElement)customColour, GuiToolkit.LayoutPos.MIDDLE_LEFT, 0, 0);
        this.setupColourPickers(temp.background);
    }

    private void setupColourPickers(GuiElement<?> bgElement) {
        this.frameColourDialog = (GuiPickColourDialog)((GuiPickColourDialog)((GuiPickColourDialog)new GuiPickColourDialog(bgElement).setCloseOnOutsideClick(false)).setBackgroundElement((GuiElement)new GuiTooltipBackground()).setColourChangeListener(arg_0 -> ((ManagedInt)this.tile.frameColour).set(arg_0)).setIncludeAlpha(false).setCloseCallback(() -> this.colourEditMode(bgElement, false))).setCancelEnabled(true).setEnabledCallback(() -> !bgElement.isEnabled());
        this.toolkit.jeiExclude((GuiElement)this.frameColourDialog);
        this.triangleColourDialog = (GuiPickColourDialog)((GuiPickColourDialog)((GuiPickColourDialog)new GuiPickColourDialog(bgElement).setCloseOnOutsideClick(false)).setBackgroundElement((GuiElement)new GuiTooltipBackground()).setColourChangeListener(arg_0 -> ((ManagedInt)this.tile.innerColour).set(arg_0)).setIncludeAlpha(false).setCloseCallback(() -> this.colourEditMode(bgElement, false))).setCancelEnabled(true).setEnabledCallback(() -> !bgElement.isEnabled());
        this.toolkit.jeiExclude((GuiElement)this.triangleColourDialog);
        this.effectColourDialog = (GuiPickColourDialog)((GuiPickColourDialog)((GuiPickColourDialog)new GuiPickColourDialog(bgElement).setCloseOnOutsideClick(false)).setBackgroundElement((GuiElement)new GuiTooltipBackground()).setColourChangeListener(arg_0 -> ((ManagedInt)this.tile.effectColour).set(arg_0)).setIncludeAlpha(false).setCloseCallback(() -> this.colourEditMode(bgElement, false))).setCancelEnabled(true).setEnabledCallback(() -> !bgElement.isEnabled());
        this.toolkit.jeiExclude((GuiElement)this.effectColourDialog);
    }

    private void colourEditMode(GuiElement<?> bgElement, boolean enabled) {
        bgElement.setEnabled(!enabled);
        boolean bl = this.enableDefaultBackground = !enabled;
        if (enabled) {
            ((GuiPickColourDialog)((GuiPickColourDialog)((GuiPickColourDialog)this.frameColourDialog.setColour(this.tile.frameColour.get()).setYPos(5)).setMaxXPos(this.f_96543_ - 50, false)).normalizePosition()).show(200);
            ((GuiButton)this.frameColourDialog.cancelButton.onPressed(() -> this.frameColourDialog.updateColour(this.tile.tier.get() == 8 ? 0x191919 : 0x191919)).setInsets(0, 0, 0, 0)).setText(this.toolkit.i18n("reset", new Object[0]));
            ((GuiPickColourDialog)((GuiPickColourDialog)((GuiPickColourDialog)this.triangleColourDialog.setColour(this.tile.innerColour.get()).setYPos(this.frameColourDialog.maxYPos() + 2)).setMaxXPos(this.f_96543_ - 50, false)).normalizePosition()).show(200);
            ((GuiButton)this.triangleColourDialog.cancelButton.onPressed(() -> this.triangleColourDialog.updateColour(this.tile.tier.get() == 8 ? 10823168 : 0x660099)).setInsets(0, 0, 0, 0)).setText(this.toolkit.i18n("reset", new Object[0]));
            ((GuiPickColourDialog)((GuiPickColourDialog)((GuiPickColourDialog)this.effectColourDialog.setColour(this.tile.effectColour.get()).setYPos(this.triangleColourDialog.maxYPos() + 2)).setMaxXPos(this.f_96543_ - 50, false)).normalizePosition()).show(200);
            ((GuiButton)this.effectColourDialog.cancelButton.onPressed(() -> this.effectColourDialog.updateColour(this.tile.tier.get() == 8 ? 0xFF7F00 : 62194)).setInsets(0, 0, 0, 0)).setText(this.toolkit.i18n("reset", new Object[0]));
        }
    }

    private double getEnergyDouble() {
        if (this.tile.tier.get() < 8) {
            return (double)this.tile.energy.getOPStored() / (double)this.tile.energy.getMaxOPStored();
        }
        if (!GuiEnergyCore.validBigInt(GuiEnergyCore.sanitizeNumStr(this.tile.energyTarget.get()))) {
            return 0.0;
        }
        BigDecimal target = new BigDecimal(GuiEnergyCore.sanitizeNumStr(this.tile.energyTarget.get()));
        if (target.equals(BigDecimal.ZERO)) {
            return 0.0;
        }
        double val = new BigDecimal(this.tile.energy.getStoredBig()).divide(target, 6, RoundingMode.HALF_EVEN).doubleValue();
        return MathHelper.clip((double)val, (double)0.0, (double)1.0);
    }

    private String genIOText() {
        IOInfo ioInfo = this.tile.energy.getIOInfo();
        if (ioInfo == null) {
            return "[Not Available]";
        }
        String pfx = "mod_gui.brandonscore.energy_bar.";
        StringBuilder builder = new StringBuilder();
        if (GuiEnergyCore.m_96638_()) {
            builder.append(ChatFormatting.GREEN).append("+").append(Utils.formatNumber((long)ioInfo.currentInput()));
            builder.append(" ").append(I18n.m_118938_((String)(pfx + "op"), (Object[])new Object[0])).append("/t, ");
            builder.append(ChatFormatting.RED).append("-").append(Utils.formatNumber((long)ioInfo.currentOutput()));
            builder.append(" ").append(I18n.m_118938_((String)(pfx + "op"), (Object[])new Object[0])).append("/t");
        } else {
            long io = ioInfo.currentInput() - ioInfo.currentOutput();
            builder.append(io > 0L ? ChatFormatting.GREEN + "+" : (io < 0L ? ChatFormatting.RED : ChatFormatting.GRAY));
            builder.append(Utils.formatNumber((long)io)).append(" ").append(I18n.m_118938_((String)(pfx + "op"), (Object[])new Object[0])).append("/t");
        }
        return builder.toString();
    }

    public static boolean validBigInt(String value) {
        try {
            BigDecimal val = new BigDecimal(value);
            return val.compareTo(BigDecimal.ZERO) >= 0 && val.compareTo(MAX_BIGINT) <= 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String sanitizeNumStr(String value) {
        if (((String)value).isEmpty() || ((String)value).toLowerCase(Locale.ENGLISH).endsWith("e")) {
            value = (String)value + "0";
        }
        return value;
    }
}

