/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEnergyBar;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiStackIcon;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.TBasicMachine;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.draconicevolution.blocks.tileentity.TileCelestialManipulator;
import com.brandon3055.draconicevolution.client.DEGuiSprites;
import com.brandon3055.draconicevolution.client.gui.modular.TModularMachine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class GuiCelestialManipulator
extends ModularGuiContainer<ContainerBCTile<TileCelestialManipulator>> {
    private Player player;
    private TileCelestialManipulator tile;
    private TBasicMachine temp;
    private GuiButton weatherMode;
    private GuiButton sunMode;
    private List<GuiElement> weatherControls = new ArrayList<GuiElement>();
    private List<GuiElement> sunControls = new ArrayList<GuiElement>();
    private GuiEnergyBar energyBar;
    private GuiBorderedRect rsBackground;
    private GuiElement[] rsControlButtons = new GuiElement[9];
    private double rsTabAnim = 0.0;
    private boolean rsTabEnabled = false;
    protected GuiToolkit<GuiCelestialManipulator> toolkit = new GuiToolkit((Screen)this, 180, 214).setTranslationPrefix("gui.draconicevolution.celestial_manipulator");

    public GuiCelestialManipulator(ContainerBCTile<TileCelestialManipulator> container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.f_97726_ = 180;
        this.f_97727_ = 200;
        this.tile = (TileCelestialManipulator)container.tile;
        this.player = playerInventory.f_35978_;
    }

    public void addElements(GuiElementManager manager) {
        manager.clear();
        this.weatherControls.clear();
        this.sunControls.clear();
        this.temp = new TModularMachine(this, (TileBCore)this.tile, false);
        this.temp.background = GuiTexture.newDynamicTexture((int)this.xSize(), (int)this.ySize(), () -> BCGuiSprites.getThemed((String)"background_dynamic"));
        this.temp.background.onReload(guiTex -> guiTex.setPos(this.guiLeft(), this.guiTop()));
        this.toolkit.loadTemplate((IGuiTemplate)this.temp);
        this.temp.playerSlots = this.toolkit.createPlayerSlots(this.temp.background, false);
        this.toolkit.placeInside(this.temp.playerSlots, this.temp.background, GuiToolkit.LayoutPos.BOTTOM_CENTER, 0, -7);
        this.weatherMode = new GuiButton(this.guiLeft() + 5, this.guiTop() + 17, 50, 12, this.toolkit.i18n("weather", new Object[0])).setFillColours(-1879048192, -1877929711, -1876811230).setTextColour(-1872691360, -1870594049, -1872756736).setBorderColours(-1878982657, -1878982912, -1878982912).onPressed(() -> {
            this.tile.weatherMode.set(true);
            this.updateControls();
        });
        this.temp.background.addChild((GuiElement)this.weatherMode);
        this.sunMode = new GuiButton(this.guiLeft() + this.xSize() - 55, this.guiTop() + 17, 50, 12, this.toolkit.i18n("time", new Object[0])).setFillColours(-1879048192, -1877929711, -1876811230).setTextColour(-1872691360, -1870594049, -1872756736).setBorderColours(-1878982657, -1878982912, -1878982912).onPressed(() -> {
            this.tile.weatherMode.set(false);
            this.updateControls();
        });
        this.temp.background.addChild((GuiElement)this.sunMode);
        this.temp.energyBar = this.toolkit.createEnergyBar(this.temp.background, (IOPStorage)this.tile.opStorage);
        ((GuiEnergyBar)this.temp.energyBar.setPos(this.guiLeft() + 9, this.guiTop() + 98)).setSize(this.temp.playerSlots.xSize(), 14);
        this.temp.background.addChild((GuiElement)new GuiBorderedRect(this.guiLeft() + 4, this.guiTop() + 16, this.xSize() - 8, this.ySize() - 100).setFillColour(0x40000000).setBorderColour(-1879048192));
        int i = 32;
        this.weatherControls.add((GuiElement)new GuiButton(this.guiLeft() + 4, this.guiTop() + i, this.xSize() - 8, 14, this.toolkit.i18n("stopRain", new Object[0])).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeString("STOP_RAIN"), 0)));
        this.weatherControls.add((GuiElement)new GuiButton(this.guiLeft() + 4, this.guiTop() + (i += 22), this.xSize() - 8, 14, this.toolkit.i18n("startRain", new Object[0])).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeString("START_RAIN"), 0)));
        this.weatherControls.add((GuiElement)new GuiButton(this.guiLeft() + 4, this.guiTop() + (i += 22), this.xSize() - 8, 14, this.toolkit.i18n("startStorm", new Object[0])).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeString("START_STORM"), 0)));
        i = 22;
        this.sunControls.add((GuiElement)new GuiLabel(this.guiLeft(), this.guiTop() + i, this.xSize(), 12, this.toolkit.i18n("skipTo", new Object[0])));
        this.sunControls.add((GuiElement)new GuiButton(this.guiLeft() + 4, this.guiTop() + (i += 14), this.xSize() / 3 - 4, 14, this.toolkit.i18n("sunRise", new Object[0])).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeString("SUN_RISE"), 0)));
        this.sunControls.add((GuiElement)new GuiButton(this.guiLeft() + 4 + this.xSize() / 3 - 2, this.guiTop() + i, this.xSize() / 3 - 4, 14, this.toolkit.i18n("midDay", new Object[0])).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeString("MID_DAY"), 0)));
        this.sunControls.add((GuiElement)new GuiButton(this.guiLeft() + 4 + this.xSize() / 3 * 2 - 4, this.guiTop() + i, this.xSize() / 3 - 4, 14, this.toolkit.i18n("sunSet", new Object[0])).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeString("SUN_SET"), 0)));
        this.sunControls.add((GuiElement)new GuiButton(this.guiLeft() + 4, this.guiTop() + (i += 20), this.xSize() / 3 - 4, 14, this.toolkit.i18n("moonRise", new Object[0])).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeString("MOON_RISE"), 0)));
        this.sunControls.add((GuiElement)new GuiButton(this.guiLeft() + 4 + this.xSize() / 3 - 2, this.guiTop() + i, this.xSize() / 3 - 4, 14, this.toolkit.i18n("midnight", new Object[0])).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeString("MIDNIGHT"), 0)));
        this.sunControls.add((GuiElement)new GuiButton(this.guiLeft() + 4 + this.xSize() / 3 * 2 - 4, this.guiTop() + i, this.xSize() / 3 - 4, 14, this.toolkit.i18n("moonSet", new Object[0])).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeString("MOON_SET"), 0)));
        this.sunControls.add((GuiElement)new GuiButton(this.guiLeft() + 4, this.guiTop() + (i += 20), this.xSize() / 2 - 5, 14, this.toolkit.i18n("skip24", new Object[0])).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeString("SKIP_24"), 0)));
        this.sunControls.add((GuiElement)new GuiButton(this.guiLeft() + 1 + this.xSize() / 2, this.guiTop() + i, this.xSize() / 2 - 5, 14, this.toolkit.i18n("stop", new Object[0])).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeString("STOP"), 0)));
        this.updateControls();
        this.rsBackground = new GuiBorderedRect(this.guiLeft() + this.xSize(), this.guiTop() + 97, 18, 18).setBorderColour(-11513776);
        this.temp.background.addChild((GuiElement)this.rsBackground);
        this.rsBackground.addChild((GuiElement)new GuiStackIcon(this.rsBackground.xPos(), this.rsBackground.yPos(), this.rsBackground.xSize(), this.rsBackground.ySize(), "minecraft:redstone").setToolTip(false));
        this.temp.background.addChild((GuiElement)((GuiButton)((GuiButton)new GuiButton(this.rsBackground.xPos(), this.rsBackground.yPos(), this.rsBackground.xSize(), this.rsBackground.ySize(), "").setFillColours(0, 0, 0).setHoverText(new String[]{I18n.m_118938_((String)"generic.configureRedstone", (Object[])new Object[0])})).setHoverTextDelay(2)).onPressed(() -> this.rsBackground.setChildGroupEnabled("RS_BUTTON", !this.rsControlButtons[0].isEnabled())));
        this.toolkit.jeiExclude((GuiElement)this.rsBackground);
        String[] rsButtonNames = new String[]{"clear", "rain", "storm", "sunrise", "noon", "sunset", "moonrise", "midnight", "moonset"};
        for (int ii = 0; ii < this.rsControlButtons.length; ++ii) {
            int num = ii;
            this.rsControlButtons[num] = ((GuiButton)((GuiButton)this.toolkit.createIconButton((GuiElement)this.rsBackground, 18, DEGuiSprites.getter("celestial_manipulator/" + rsButtonNames[num])).setFillColours(0, -11513776, -9408400).setBorderColours(-11513776, -9408400, -1048576).onPressed(() -> this.tile.sendPacketToServer(output -> output.writeInt(num), 1)).setHoverText(new String[]{this.toolkit.i18n("rs." + num, new Object[0])})).setEnabled(false)).addToGroup("RS_BUTTON");
            this.toolkit.jeiExclude(this.rsControlButtons[num]);
            if (num == 0) {
                this.toolkit.placeOutside(this.rsControlButtons[num], (GuiElement)this.rsBackground, GuiToolkit.LayoutPos.BOTTOM_CENTER, 0, 2);
                continue;
            }
            if (num % 3 != 0) {
                this.toolkit.placeOutside(this.rsControlButtons[num], this.rsControlButtons[num - 1], GuiToolkit.LayoutPos.MIDDLE_RIGHT, 2, 0);
                continue;
            }
            this.toolkit.placeOutside(this.rsControlButtons[num], this.rsControlButtons[num - 3], GuiToolkit.LayoutPos.BOTTOM_CENTER, 0, 2);
        }
    }

    private void updateControls() {
        if (this.tile.weatherMode.get()) {
            for (GuiElement elementBase : this.sunControls) {
                this.temp.background.removeChild(elementBase);
            }
            for (GuiElement elementBase : this.weatherControls) {
                if (this.temp.background.getChildElements().contains(elementBase)) continue;
                this.temp.background.addChild(elementBase);
            }
            this.sunMode.setDisabled(false);
            this.weatherMode.setDisabled(true);
        } else {
            for (GuiElement elementBase : this.sunControls) {
                if (this.temp.background.getChildElements().contains(elementBase)) continue;
                this.temp.background.addChild(elementBase);
            }
            for (GuiElement elementBase : this.weatherControls) {
                this.temp.background.removeChild(elementBase);
            }
            this.sunMode.setDisabled(true);
            this.weatherMode.setDisabled(false);
        }
    }
}

