/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import com.brandon3055.brandonscore.client.render.CustomSpriteUploader;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;

public class DEMiscSprites {
    public static final ResourceLocation ATLAS_LOCATION = new ResourceLocation("draconicevolution", "textures/atlas/misc_sprites.png");
    private static CustomSpriteUploader customSpriteUploader;
    private static final Map<ResourceLocation, Consumer<TextureAtlasSprite>> registeredSprites;
    private static final Map<String, Material> matCache;
    public static final RenderType GUI_TYPE;
    public static TextureAtlasSprite[] ENERGY_PARTICLE;
    public static TextureAtlasSprite[] SPARK_PARTICLE;
    public static TextureAtlasSprite[] SPELL_PARTICLE;
    public static TextureAtlasSprite[] MIXED_PARTICLE;
    public static TextureAtlasSprite ORB_PARTICLE;
    public static TextureAtlasSprite PORTAL_PARTICLE;
    public static TextureAtlasSprite GENERATOR;
    public static final RenderType SOLID;
    public static ParticleRenderType PARTICLE_SHEET_TRANSLUCENT;

    public static void initialize(ColorHandlerEvent.Block event) {
        customSpriteUploader = new CustomSpriteUploader(registeredSprites, ATLAS_LOCATION);
        DEMiscSprites.register("particle/white_orb", (TextureAtlasSprite sprite) -> {
            ORB_PARTICLE = sprite;
        });
        DEMiscSprites.register("particle/portal", (TextureAtlasSprite sprite) -> {
            PORTAL_PARTICLE = sprite;
        });
        DEMiscSprites.register("block/generator/generator_2", (TextureAtlasSprite sprite) -> {
            GENERATOR = sprite;
        });
        DEMiscSprites.registerToArray(i -> "particle/energy_" + i, () -> ENERGY_PARTICLE);
        DEMiscSprites.registerToArray(i -> "particle/spark_" + i, () -> SPARK_PARTICLE);
        DEMiscSprites.registerToArray(i -> "particle/spell_" + i, () -> SPELL_PARTICLE);
        customSpriteUploader.addReloadListener(() -> {
            MIXED_PARTICLE = (TextureAtlasSprite[])Stream.concat(Arrays.stream(SPARK_PARTICLE), Arrays.stream(SPELL_PARTICLE)).toArray(TextureAtlasSprite[]::new);
        });
        if (ModHelper.ENDERSTORAGE.isPresent()) {
            DEMiscSprites.register(new ResourceLocation("enderstorage:buttons"));
        }
    }

    private static void register(ResourceLocation location) {
        DEMiscSprites.register(location, null);
    }

    private static void register(String location) {
        DEMiscSprites.register(new ResourceLocation("draconicevolution", location));
    }

    private static void register(ResourceLocation location, Consumer<TextureAtlasSprite> onLoad) {
        registeredSprites.put(location, onLoad);
    }

    private static void register(String location, Consumer<TextureAtlasSprite> onLoad) {
        DEMiscSprites.register(new ResourceLocation("draconicevolution", location), onLoad);
    }

    private static void registerToArray(Function<Integer, String> nameFunction, Supplier<TextureAtlasSprite[]> arraySupplier) {
        for (int i = 0; i < arraySupplier.get().length; ++i) {
            int finalI = i;
            DEMiscSprites.register(nameFunction.apply(i), (TextureAtlasSprite sprite) -> {
                ((TextureAtlasSprite[])arraySupplier.get())[finalI] = sprite;
            });
        }
    }

    public static Material getMat(String modid, String location) {
        return matCache.computeIfAbsent(modid + ":" + location, s -> new CustomMat(ATLAS_LOCATION, new ResourceLocation(modid, location)));
    }

    public static Material getMat(String location) {
        return matCache.computeIfAbsent("draconicevolution:" + location, s -> new CustomMat(ATLAS_LOCATION, new ResourceLocation("draconicevolution", location)));
    }

    public static TextureAtlasSprite getSprite(String location) {
        return DEMiscSprites.getMat(location).m_119204_();
    }

    public static Supplier<Material> matGetter(String location) {
        return () -> matCache.computeIfAbsent("draconicevolution:" + location, s -> new CustomMat(ATLAS_LOCATION, new ResourceLocation("draconicevolution", location)));
    }

    static {
        registeredSprites = new HashMap<ResourceLocation, Consumer<TextureAtlasSprite>>();
        matCache = new HashMap<String, Material>();
        GUI_TYPE = RenderType.m_173209_((String)"gui_tex", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172814_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ATLAS_LOCATION, false, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
        ENERGY_PARTICLE = new TextureAtlasSprite[5];
        SPARK_PARTICLE = new TextureAtlasSprite[7];
        SPELL_PARTICLE = new TextureAtlasSprite[7];
        SOLID = RenderType.m_173215_((String)"solid", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110671_(RenderStateShard.f_110152_).m_173292_(RenderStateShard.f_173105_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ATLAS_LOCATION, false, false)).m_110691_(true));
        PARTICLE_SHEET_TRANSLUCENT = new ParticleRenderType(){

            public void m_6505_(BufferBuilder builder, TextureManager manager) {
                RenderSystem.m_69458_((boolean)false);
                RenderSystem.m_69478_();
                RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.m_157456_((int)0, (ResourceLocation)ATLAS_LOCATION);
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }

            public void m_6294_(Tesselator tessellator) {
                tessellator.m_85914_();
            }

            public String toString() {
                return "TERRAIN_SHEET_TRANSLUCENT";
            }
        };
    }

    private static class CustomMat
    extends Material {
        public CustomMat(ResourceLocation atlasLocationIn, ResourceLocation textureLocationIn) {
            super(atlasLocationIn, textureLocationIn);
        }

        public TextureAtlasSprite m_119204_() {
            return customSpriteUploader.m_118901_(this.m_119203_());
        }
    }
}

