/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.render.entity.DraconicGuardianRenderer;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;

public class CustomBossInfoHandler
extends GuiComponent {
    private static final ResourceLocation GUI_BARS_LOCATION = new ResourceLocation("textures/gui/bars.png");
    private static final Map<UUID, BossShieldInfo> events = Maps.newLinkedHashMap();
    private static final ResourceLocation ENDER_CRYSTAL_TEXTURES = new ResourceLocation("draconicevolution", "textures/entity/guardian_crystal.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)ENDER_CRYSTAL_TEXTURES);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private static final ModelPart glass;
    private static final ModelPart cube;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(CustomBossInfoHandler::onClientDisconnect);
        MinecraftForge.EVENT_BUS.addListener(CustomBossInfoHandler::preDrawBossInfo);
    }

    public static void preDrawBossInfo(RenderGameOverlayEvent.BossInfo event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.BOSSINFO) {
            return;
        }
        LerpingBossEvent info = event.getBossEvent();
        if (!events.containsKey(info.m_18860_())) {
            return;
        }
        event.setCanceled(true);
        BossShieldInfo shieldInfo = events.get(info.m_18860_());
        Minecraft mc = Minecraft.m_91087_();
        PoseStack matrixStack = event.getMatrixStack();
        int width = event.getWindow().m_85445_();
        int x = event.getX();
        int y = event.getY();
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BARS_LOCATION);
        CustomBossInfoHandler.drawBar(matrixStack, x, y, (BossEvent)info);
        float shield = shieldInfo.isImmune() ? 1.0f : shieldInfo.getShield();
        MultiBufferSource.BufferSource getter = Minecraft.m_91087_().m_91269_().m_110104_();
        if (DEConfig.guardianShaders) {
            if (shieldInfo.isImmune()) {
                DEShaders.shieldColour.glUniform4f(0.0f, 1.0f, 1.0f, 2.0f);
            } else {
                DEShaders.shieldColour.glUniform4f(1.0f, 0.0f, 0.0f, 2.0f);
            }
            DEShaders.shieldBarMode.glUniform1i(1);
            DEShaders.shieldActivation.glUniform1f(shield);
            TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(DraconicGuardianRenderer.SHIELD_TYPE), matrixStack);
            CustomBossInfoHandler.drawShieldRect((VertexConsumer)builder, x, y, 182, 6);
            getter.m_109911_();
        }
        if (shieldInfo.crystals > 0) {
            TextComponent countText = new TextComponent("x" + shieldInfo.crystals);
            int countWidth = mc.f_91062_.m_92852_((FormattedText)countText);
            float anim = ((float)TimeKeeper.getClientTick() + event.getPartialTicks()) * 3.0f;
            VertexConsumer ivertexbuilder = getter.m_6299_(RENDER_TYPE);
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(x + 182 - countWidth - 8), (double)(y - 6), 0.0);
            matrixStack.m_85841_(14.0f, 14.0f, 14.0f);
            int i = OverlayTexture.f_118083_;
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(anim));
            matrixStack.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
            glass.m_104301_(matrixStack, ivertexbuilder, 240, i);
            matrixStack.m_85841_(0.875f, 0.875f, 0.875f);
            matrixStack.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(anim));
            glass.m_104301_(matrixStack, ivertexbuilder, 240, i);
            matrixStack.m_85841_(0.875f, 0.875f, 0.875f);
            matrixStack.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(anim));
            cube.m_104301_(matrixStack, ivertexbuilder, 240, i);
            matrixStack.m_85849_();
            getter.m_109911_();
            if (DEConfig.guardianShaders) {
                DEShaders.shieldColour.glUniform4f(1.0f, 0.0f, 0.0f, 1.5f);
                DEShaders.shieldActivation.glUniform1f(1.0f);
                VertexConsumer shaderBuilder = getter.m_6299_(DraconicGuardianRenderer.SHIELD_TYPE);
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)(x + 182 - countWidth - 8), (double)(y - 6), 0.0);
                matrixStack.m_85841_(14.0f, 14.0f, 14.0f);
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(anim));
                matrixStack.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
                glass.m_104301_(matrixStack, shaderBuilder, 240, i);
                matrixStack.m_85841_(0.875f, 0.875f, 0.875f);
                matrixStack.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(anim));
                glass.m_104301_(matrixStack, shaderBuilder, 240, i);
                matrixStack.m_85841_(0.875f, 0.875f, 0.875f);
                matrixStack.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(anim));
                cube.m_104301_(matrixStack, shaderBuilder, 240, i);
                matrixStack.m_85849_();
                getter.m_109911_();
            }
            mc.f_91062_.m_92763_(matrixStack, (Component)new TextComponent("x" + shieldInfo.crystals), (float)(x + 182 - countWidth), (float)y - 9.0f, 0xFFFFFF);
        }
        Component itextcomponent = info.m_18861_();
        int stringWidth = mc.f_91062_.m_92852_((FormattedText)itextcomponent);
        int stringX = shieldInfo.crystals > 0 ? x : width / 2 - stringWidth / 2;
        int stringY = y - 9;
        matrixStack.m_85837_(0.0, 0.0, 16.0);
        mc.f_91062_.m_92763_(matrixStack, itextcomponent, (float)stringX, (float)stringY, 0xFF0000);
    }

    private static void drawBar(PoseStack matrixStack, int x, int y, BossEvent info) {
        int i;
        CustomBossInfoHandler.drawRect(matrixStack, x, y, 0, info.m_18862_().ordinal() * 5 * 2, 182, 5);
        if (info.m_18863_() != BossEvent.BossBarOverlay.PROGRESS) {
            CustomBossInfoHandler.drawRect(matrixStack, x, y, 0, 80 + (info.m_18863_().ordinal() - 1) * 5 * 2, 182, 5);
        }
        if ((i = (int)(info.m_142717_() * 183.0f)) > 0) {
            CustomBossInfoHandler.drawRect(matrixStack, x, y, 0, info.m_18862_().ordinal() * 5 * 2 + 5, i, 5);
            if (info.m_18863_() != BossEvent.BossBarOverlay.PROGRESS) {
                CustomBossInfoHandler.drawRect(matrixStack, x, y, 0, 80 + (info.m_18863_().ordinal() - 1) * 5 * 2 + 5, i, 5);
            }
        }
    }

    private static void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        events.clear();
    }

    public static void handlePacket(MCDataInput input) {
        UUID id = input.readUUID();
        byte op = input.readByte();
        switch (op) {
            case 0: {
                events.put(id, new BossShieldInfo(input.readFloat(), input.readByte(), input.readBoolean()));
                break;
            }
            case 1: {
                events.remove(id);
                break;
            }
            case 2: {
                events.get(id).setShield(input.readFloat());
                break;
            }
            case 3: {
                events.get(id).setCrystals(input.readByte());
                break;
            }
            case 4: {
                events.get(id).setImmune(input.readBoolean());
            }
        }
    }

    public static void drawRect(PoseStack stack, int x, int y, int u, int v, int width, int height) {
        CustomBossInfoHandler.m_93143_((PoseStack)stack, (int)x, (int)y, (int)0, (float)u, (float)v, (int)width, (int)height, (int)256, (int)256);
    }

    public static void drawShieldRect(VertexConsumer builder, int x, int y, int width, int height) {
        CustomBossInfoHandler.drawQuad(builder, x, x + width, y, y + height, 0, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    private static void drawQuad(VertexConsumer builder, int x, int xMax, int y, int yMax, int z, float u, float uMax, float v, float vMax) {
        builder.m_5483_((double)x, (double)yMax, (double)z).m_7421_(u, vMax).m_5752_();
        builder.m_5483_((double)xMax, (double)yMax, (double)z).m_7421_(uMax, vMax).m_5752_();
        builder.m_5483_((double)xMax, (double)y, (double)z).m_7421_(uMax, v).m_5752_();
        builder.m_5483_((double)x, (double)y, (double)z).m_7421_(u, v).m_5752_();
    }

    static {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("glass", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        partdefinition.m_171599_("cube", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        ModelPart modelRoot = LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32).m_171564_();
        glass = modelRoot.m_171324_("glass");
        cube = modelRoot.m_171324_("cube");
    }

    public static class BossShieldInfo {
        protected float lastPower;
        protected float targetPower;
        protected long setTime;
        protected int crystals;
        protected boolean immune;

        public BossShieldInfo(float power, int crystals, boolean immune) {
            this.lastPower = power;
            this.targetPower = power;
            this.crystals = crystals;
            this.immune = immune;
            this.setTime = Util.m_137550_();
        }

        public BossShieldInfo setShield(float power) {
            this.lastPower = this.getShield();
            this.targetPower = power;
            this.setTime = Util.m_137550_();
            return this;
        }

        public float getShield() {
            long i = Util.m_137550_() - this.setTime;
            float f = Mth.m_14036_((float)((float)i / 100.0f), (float)0.0f, (float)1.0f);
            return Mth.m_14179_((float)f, (float)this.lastPower, (float)this.targetPower);
        }

        public void setCrystals(int crystals) {
            this.crystals = crystals;
        }

        public int getCrystals() {
            return this.crystals;
        }

        public void setImmune(boolean immune) {
            this.immune = immune;
        }

        public boolean isImmune() {
            return this.immune;
        }
    }
}

