/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.flowgate;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFlowGate;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.ContainerDETile;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkHooks;

public class TileFluxGate
extends TileFlowGate {
    private OPRegulator inputReg = new OPRegulator(this, true);
    private OPRegulator outputReg = new OPRegulator(this, false);
    private boolean capsLoaded = false;

    public TileFluxGate(BlockPos pos, BlockState state) {
        super(DEContent.tile_flux_gate, pos, state);
    }

    @Override
    public String getUnits() {
        return "RF/t";
    }

    private void updateCapabilities() {
        this.capManager.remove(CapabilityOP.OP, new Direction[0]);
        this.capManager.set(CapabilityOP.OP, (Object)this.inputReg, new Direction[]{this.getDirection().m_122424_()});
        this.capManager.set(CapabilityOP.OP, (Object)this.outputReg, new Direction[]{this.getDirection()});
    }

    @Override
    public void m_155250_(BlockState p_155251_) {
        super.m_155250_(p_155251_);
        this.updateCapabilities();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (!this.capsLoaded) {
            this.updateCapabilities();
            this.capsLoaded = true;
        }
        return super.getCapability(capability, side);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ContainerDETile<TileFluxGate>(DEContent.container_flow_gate, id, player.m_150109_(), this, (ContainerSlotLayout.LayoutFactory)SneakyUtils.unsafeCast(GuiLayoutFactories.PLAYER_ONLY_LAYOUT));
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        }
        return true;
    }

    @Override
    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        if (this.flowOverridden.get()) {
            return;
        }
        try {
            String value = data.readString();
            long l = Long.parseLong(value);
            if (l < 0L) {
                l = 0L;
            }
            if (id == 0) {
                this.minFlow.set(l);
            } else if (id == 1) {
                this.maxFlow.set(l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static class OPRegulator
    implements IOPStorage {
        private TileFluxGate tile;
        private boolean isInput;

        public OPRegulator(TileFluxGate tile, boolean isInput) {
            this.tile = tile;
            this.isInput = isInput;
        }

        public long receiveOP(long maxReceive, boolean simulate) {
            if (this.isInput) {
                BlockEntity target = this.tile.getTarget();
                if (target == null) {
                    return 0L;
                }
                Direction tInputSide = this.tile.getDirection().m_122424_();
                long sim = EnergyUtils.insertEnergy((BlockEntity)target, (long)maxReceive, (Direction)tInputSide, (boolean)true);
                long transfer = EnergyUtils.insertEnergy((BlockEntity)target, (long)Math.min(Math.max(0L, this.tile.getFlow() - this.tile.transferThisTick), sim), (Direction)tInputSide, (boolean)simulate);
                if (!simulate) {
                    this.tile.transferThisTick += transfer;
                }
                return transfer;
            }
            return 0L;
        }

        public long extractOP(long maxExtract, boolean simulate) {
            if (!this.isInput) {
                BlockEntity source = this.tile.getSource();
                if (source == null) {
                    return 0L;
                }
                Direction tExtractSide = this.tile.getDirection();
                long sim = EnergyUtils.extractEnergy((BlockEntity)source, (long)maxExtract, (Direction)tExtractSide, (boolean)true);
                long transfer = EnergyUtils.extractEnergy((BlockEntity)source, (long)Math.min(Math.max(0L, this.tile.getFlow() - this.tile.transferThisTick), sim), (Direction)tExtractSide, (boolean)simulate);
                if (!simulate) {
                    this.tile.transferThisTick += transfer;
                }
                return transfer;
            }
            return 0L;
        }

        public long getOPStored() {
            if (this.isInput) {
                return 0L;
            }
            BlockEntity target = this.tile.getTarget();
            if (target == null) {
                return 0L;
            }
            return EnergyUtils.getEnergyStored((BlockEntity)target, (Direction)this.tile.getDirection().m_122424_());
        }

        public long getMaxOPStored() {
            if (this.isInput) {
                return 0L;
            }
            BlockEntity target = this.tile.getTarget();
            if (target == null) {
                return 0L;
            }
            return EnergyUtils.getMaxEnergyStored((BlockEntity)target, (Direction)this.tile.getDirection().m_122424_());
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return (int)this.receiveOP(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return (int)this.extractOP(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return (int)Math.min(Integer.MAX_VALUE, this.getOPStored());
        }

        public int getMaxEnergyStored() {
            return (int)Math.min(Integer.MAX_VALUE, this.getMaxOPStored());
        }

        public long modifyEnergyStored(long amount) {
            return 0L;
        }

        public boolean canExtract() {
            return !this.isInput;
        }

        public boolean canReceive() {
            return this.isInput;
        }
    }
}

