/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.flowgate;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.draconicevolution.blocks.machines.FlowGate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TileFlowGate
extends TileBCore
implements IChangeListener,
MenuProvider,
IInteractTile {
    protected long transferThisTick = 0L;
    public final ManagedLong minFlow = (ManagedLong)this.register((IManagedData)new ManagedLong("min_flow", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedLong maxFlow = (ManagedLong)this.register((IManagedData)new ManagedLong("max_flow", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedLong flowOverride = (ManagedLong)this.register((IManagedData)new ManagedLong("flow_override", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool flowOverridden = (ManagedBool)this.register((IManagedData)new ManagedBool("flow_overridden", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte rsSignal = (ManagedByte)this.register((IManagedData)new ManagedByte("rs_signal", -1, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private Direction rotationCache = null;

    public TileFlowGate(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void tick() {
        super.tick();
        this.transferThisTick = 0L;
    }

    public abstract String getUnits();

    @OnlyIn(value=Dist.CLIENT)
    public void setMin(String value) {
        this.sendPacketToServer(output -> output.writeString(value), 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setMax(String value) {
        this.sendPacketToServer(output -> output.writeString(value), 1);
    }

    public long getFlow() {
        if (this.flowOverridden.get()) {
            return this.flowOverride.get();
        }
        if (this.rsSignal.get() == -1) {
            this.rsSignal.set((int)((byte)this.f_58857_.m_46755_(this.f_58858_)));
        }
        return this.minFlow.get() + (long)((double)this.rsSignal.get() / 15.0 * (double)(this.maxFlow.get() - this.minFlow.get()));
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        if (this.flowOverridden.get()) {
            return;
        }
        try {
            String value = data.readString();
            long l = Long.parseLong(value);
            if (l < 0L) {
                l = 0L;
            } else if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            if (id == 0) {
                this.minFlow.set((long)((int)l));
            } else if (id == 1) {
                this.maxFlow.set((long)((int)l));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public BlockEntity getTarget() {
        return this.f_58857_.m_7702_(this.f_58858_.m_142300_(this.getDirection()));
    }

    public BlockEntity getSource() {
        return this.f_58857_.m_7702_(this.f_58858_.m_142300_(this.getDirection().m_122424_()));
    }

    public void m_155250_(BlockState p_155251_) {
        super.m_155250_(p_155251_);
        this.rotationCache = null;
    }

    public Direction getDirection() {
        if (this.rotationCache == null) {
            this.rotationCache = (Direction)this.m_58900_().m_61143_((Property)FlowGate.FACING);
        }
        return this.rotationCache;
    }

    public void onNeighborChange(BlockPos neighbor) {
        this.rsSignal.set((int)((byte)this.f_58857_.m_46755_(this.f_58858_)));
    }
}

