/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.lib.datamanager.ManagedStack;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.tileentity.StabilizedSpawnerLogic;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.ItemCore;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class TileStabilizedSpawner
extends TileBCore
implements IInteractTile,
IChangeListener {
    public ManagedEnum<SpawnerTier> spawnerTier = (ManagedEnum)this.register((IManagedData)new ManagedEnum("spawner_tier", (Enum)SpawnerTier.BASIC, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public ManagedStack mobSoul = (ManagedStack)this.register((IManagedData)new ManagedStack("mob_soul", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public ManagedBool isPowered = (ManagedBool)this.register((IManagedData)new ManagedBool("is_powered", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public ManagedShort spawnDelay = (ManagedShort)this.register((IManagedData)new ManagedShort("spawn_delay", 100, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public ManagedInt startSpawnDelay = (ManagedInt)this.register((IManagedData)new ManagedInt("start_spawn_delay", 100, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public StabilizedSpawnerLogic spawnerLogic = new StabilizedSpawnerLogic(this);
    private int activatingRangeFromPlayer = 24;

    public TileStabilizedSpawner(BlockPos pos, BlockState state) {
        super(DEContent.tile_stabilized_spawner, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ instanceof ServerLevel) {
            this.spawnerLogic.m_151311_((ServerLevel)this.f_58857_, this.f_58858_);
        } else {
            this.spawnerLogic.m_151319_(this.f_58857_, this.f_58858_);
        }
    }

    public boolean isActive() {
        if (this.isPowered.get() || this.mobSoul.get().m_41619_()) {
            return false;
        }
        return !((SpawnerTier)this.spawnerTier.get()).requiresPlayer || this.f_58857_.m_45914_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, (double)this.activatingRangeFromPlayer);
    }

    public void onNeighborChange(BlockPos changePos) {
        this.isPowered.set(this.f_58857_.m_46753_(this.f_58858_));
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == DEContent.mob_soul) {
            if (!this.f_58857_.f_46443_) {
                this.mobSoul.set(stack.m_41777_()).m_41764_(1);
                if (!player.m_7500_()) {
                    InventoryUtils.consumeHeldItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
                }
            }
            return true;
        }
        if (stack.m_41720_() instanceof SpawnEggItem) {
            EntityType type = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
            ItemStack soul = new ItemStack((ItemLike)DEContent.mob_soul);
            DEContent.mob_soul.setEntity(type.getRegistryName(), soul);
            this.mobSoul.set(soul);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return true;
        }
        if (!stack.m_41619_()) {
            SpawnerTier prevTier = (SpawnerTier)this.spawnerTier.get();
            if (stack.m_41720_() == DEContent.core_draconium) {
                if (this.spawnerTier.get() == SpawnerTier.BASIC) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.BASIC);
            } else if (stack.m_41720_() == DEContent.core_wyvern) {
                if (this.spawnerTier.get() == SpawnerTier.WYVERN) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.WYVERN);
            } else if (stack.m_41720_() == DEContent.core_awakened) {
                if (this.spawnerTier.get() == SpawnerTier.DRACONIC) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.DRACONIC);
            } else if (stack.m_41720_() == DEContent.core_chaotic) {
                if (this.spawnerTier.get() == SpawnerTier.CHAOTIC) {
                    return false;
                }
                this.spawnerTier.set((Enum)SpawnerTier.CHAOTIC);
            } else {
                return false;
            }
            ItemStack dropStack = ItemStack.f_41583_;
            switch (prevTier) {
                case BASIC: {
                    dropStack = new ItemStack((ItemLike)DEContent.core_draconium);
                    break;
                }
                case WYVERN: {
                    dropStack = new ItemStack((ItemLike)DEContent.core_wyvern);
                    break;
                }
                case DRACONIC: {
                    dropStack = new ItemStack((ItemLike)DEContent.core_awakened);
                    break;
                }
                case CHAOTIC: {
                    dropStack = new ItemStack((ItemLike)DEContent.core_chaotic);
                }
            }
            if (!this.f_58857_.f_46443_ && !player.m_150110_().f_35937_) {
                ItemEntity entityItem = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() + 0.5, dropStack);
                entityItem.m_20334_(entityItem.m_20184_().f_82479_, 0.2, entityItem.m_20184_().f_82481_);
                this.f_58857_.m_7967_((Entity)entityItem);
                InventoryUtils.consumeHeldItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
            }
        }
        return false;
    }

    public void writeToItemStack(CompoundTag compound, boolean willHarvest) {
        if (willHarvest) {
            this.mobSoul.set(ItemStack.f_41583_);
        }
        super.writeToItemStack(compound, willHarvest);
    }

    protected Entity getRenderEntity() {
        if (this.mobSoul.get().m_41619_()) {
            return null;
        }
        return DEContent.mob_soul.getRenderEntity(this.mobSoul.get());
    }

    public static enum SpawnerTier {
        BASIC(4, true, false),
        WYVERN(6, false, false),
        DRACONIC(8, false, true),
        CHAOTIC(12, false, true);

        private int spawnCount;
        private boolean requiresPlayer;
        private boolean ignoreSpawnReq;

        private SpawnerTier(int spawnCount, boolean requiresPlayer, boolean ignoreSpawnReq) {
            this.spawnCount = spawnCount;
            this.requiresPlayer = requiresPlayer;
            this.ignoreSpawnReq = ignoreSpawnReq;
        }

        public int getRandomSpawnDelay(Random random) {
            int min = this.getMinDelay();
            int max = this.getMaxDelay();
            return min + random.nextInt(max - min);
        }

        public int getMinDelay() {
            return DEConfig.spawnerDelays[this.ordinal() * 2];
        }

        public int getMaxDelay() {
            return DEConfig.spawnerDelays[this.ordinal() * 2 + 1];
        }

        public int getSpawnCount() {
            return this.spawnCount;
        }

        public boolean ignoreSpawnReq() {
            return this.ignoreSpawnReq;
        }

        public boolean requiresPlayer() {
            return this.requiresPlayer;
        }

        public int getMaxCluster() {
            return (int)((double)this.spawnCount * 3.0);
        }

        public static SpawnerTier getTierFromCore(ItemCore core) {
            return core == DEContent.core_chaotic ? CHAOTIC : (core == DEContent.core_wyvern ? WYVERN : (core == DEContent.core_awakened ? DRACONIC : BASIC));
        }
    }
}

