/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.Portal;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.client.render.particle.ParticlePortal;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TilePortal
extends TileBCore {
    private final ManagedPos controllerPos = (ManagedPos)this.register((IManagedData)new ManagedPos("controller_pos", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private boolean hidden = false;
    private Player player = null;

    public TilePortal(BlockPos pos, BlockState state) {
        super(DEContent.tile_portal, pos, state);
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos.set(this.f_58858_.m_141950_((Vec3i)controllerPos));
    }

    protected BlockPos getControllerPos() {
        return this.controllerPos.get() == null ? BlockPos.f_121853_ : this.f_58858_.m_141950_((Vec3i)this.controllerPos.get());
    }

    public TileDislocatorReceptacle getController() {
        BlockEntity tile = this.f_58857_.m_7702_(this.getControllerPos());
        return tile instanceof TileDislocatorReceptacle ? (TileDislocatorReceptacle)tile : null;
    }

    public boolean isPortalActive() {
        TileDislocatorReceptacle controller = this.getController();
        return controller != null && controller.isActive();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tick() {
        if (this.hidden && this.player != null) {
            BlockState state = this.m_58900_();
            if (state.m_60734_() != DEContent.portal) {
                this.hidden = false;
                this.player = null;
                this.f_58857_.m_6933_(this.m_58899_(), (BlockState)state.m_61124_((Property)Portal.VISIBLE, (Comparable)Boolean.valueOf(true)), 0, 0);
                return;
            }
            Direction.Axis axis = (Direction.Axis)state.m_61143_(Portal.AXIS);
            Vector3 vec = Vector3.fromTileCenter((BlockEntity)this).subtract(Vector3.fromEntity((Entity)this.player));
            double dist = Math.abs(axis == Direction.Axis.X ? vec.x : (axis == Direction.Axis.Y ? vec.y : vec.z));
            if (dist > 1.5) {
                this.hidden = false;
                this.player = null;
                this.f_58857_.m_6933_(this.m_58899_(), (BlockState)state.m_61124_((Property)Portal.VISIBLE, (Comparable)Boolean.valueOf(true)), 0, 0);
            }
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        double distanceMod = Utils.getDistance((double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 0.5), (double)((double)this.f_58858_.m_123343_() + 0.5), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_());
        if (this.f_58857_.f_46441_.nextInt(Math.max((int)(distanceMod * (distanceMod / 5.0)), 1)) == 0) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (state.m_60734_() != DEContent.portal) {
                return;
            }
            Direction.Axis axis = (Direction.Axis)state.m_61143_(Portal.AXIS);
            double rD1 = this.f_58857_.f_46441_.nextDouble();
            double rD2 = this.f_58857_.f_46441_.nextDouble();
            double rO1 = -0.1 + this.f_58857_.f_46441_.nextDouble() * 0.2;
            double rO2 = -0.1 + this.f_58857_.f_46441_.nextDouble() * 0.2;
            if (axis == Direction.Axis.Z && player.m_20189_() < (double)this.f_58858_.m_123343_() + 0.5) {
                mc.f_91061_.m_107344_((Particle)new ParticlePortal((ClientLevel)this.f_58857_, Vector3.fromTile((BlockEntity)this).add(rD1, rD2, 0.0), Vector3.fromTile((BlockEntity)this).add(rD1 + rO1, rD2 + rO2, 0.75)));
            } else if (axis == Direction.Axis.Z && player.m_20189_() > (double)this.f_58858_.m_123343_() + 0.5) {
                mc.f_91061_.m_107344_((Particle)new ParticlePortal((ClientLevel)this.f_58857_, Vector3.fromTile((BlockEntity)this).add(rD1, rD2, 1.0), Vector3.fromTile((BlockEntity)this).add(rD1 + rO1, rD2 + rO2, 0.25)));
            } else if (axis == Direction.Axis.X && player.m_20185_() < (double)this.f_58858_.m_123341_() + 0.5) {
                mc.f_91061_.m_107344_((Particle)new ParticlePortal((ClientLevel)this.f_58857_, Vector3.fromTile((BlockEntity)this).add(0.0, rD1, rD2), Vector3.fromTile((BlockEntity)this).add(0.75, rD1 + rO1, rD2 + rO2)));
            } else if (axis == Direction.Axis.X && player.m_20185_() > (double)this.f_58858_.m_123341_() + 0.5) {
                mc.f_91061_.m_107344_((Particle)new ParticlePortal((ClientLevel)this.f_58857_, Vector3.fromTile((BlockEntity)this).add(1.0, rD1, rD2), Vector3.fromTile((BlockEntity)this).add(0.25, rD1 + rO1, rD2 + rO2)));
            } else if (axis == Direction.Axis.Y && player.m_20186_() + (double)player.m_20192_() > (double)this.f_58858_.m_123342_() + 0.5) {
                mc.f_91061_.m_107344_((Particle)new ParticlePortal((ClientLevel)this.f_58857_, Vector3.fromTile((BlockEntity)this).add(rD1, 1.0, rD2), Vector3.fromTile((BlockEntity)this).add(rD1 + rO1, 0.25, rD2 + rO2)));
            } else if (axis == Direction.Axis.Y && player.m_20186_() + (double)player.m_20192_() < (double)this.f_58858_.m_123342_() + 0.5) {
                mc.f_91061_.m_107344_((Particle)new ParticlePortal((ClientLevel)this.f_58857_, Vector3.fromTile((BlockEntity)this).add(rD1, 0.0, rD2), Vector3.fromTile((BlockEntity)this).add(rD1 + rO1, 0.75, rD2 + rO2)));
            }
        }
    }

    public void clientArrived(Player player) {
        BlockState state = this.m_58900_();
        if (state.m_60734_() == DEContent.portal && this.f_58857_ != null) {
            this.f_58857_.m_6933_(this.m_58899_(), (BlockState)state.m_61124_((Property)Portal.VISIBLE, (Comparable)Boolean.valueOf(false)), 0, 0);
            this.hidden = true;
            this.player = player;
        }
    }
}

