/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.raytracer.SubHitBlockHitResult;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;

public class TilePlacedItem
extends TileBCore
implements IInteractTile {
    public static int MAX_STACKS = 4;
    public final ManagedByte stackCount = (ManagedByte)this.register((IManagedData)new ManagedByte("stack_count", 1, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool toolMode = (ManagedBool)this.register((IManagedData)new ManagedBool("tool_mode", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte[] rotation = new ManagedByte[MAX_STACKS];
    public final ManagedBool[] isBlock = new ManagedBool[MAX_STACKS];
    public TileItemStackHandler itemHandler = new TileItemStackHandler(MAX_STACKS);

    public TilePlacedItem(BlockPos pos, BlockState state) {
        super(DEContent.tile_placed_item, pos, state);
        for (int i = 0; i < MAX_STACKS; ++i) {
            this.rotation[i] = (ManagedByte)this.register((IManagedData)new ManagedByte("rotation_" + i, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
            this.isBlock[i] = (ManagedBool)this.register((IManagedData)new ManagedBool("is_block_" + i, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        }
        this.capManager.setInternalManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler).saveBoth().syncTile();
        this.itemHandler.setContentsChangeListener(e -> this.updatePlacedItem());
    }

    private void updatePlacedItem() {
        List<ItemStack> stacks = this.getStacksInOrder();
        this.stackCount.set(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            this.isBlock[i].set(stacks.get(i).m_41720_() instanceof BlockItem);
        }
        if (stacks.size() == 1) {
            ItemStack stack = stacks.get(0);
            this.toolMode.set(stack.m_41720_() instanceof TieredItem || stack.m_41763_());
        } else {
            this.toolMode.set(false);
        }
        this.tick();
    }

    public List<ItemStack> getStacksInOrder() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = this.itemHandler.getSlots() - 1; i >= 0; --i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            stacks.add(this.itemHandler.getStackInSlot(i));
        }
        return stacks;
    }

    public ItemStack extractStackAtIndex(int index) {
        int current = 0;
        for (int i = this.itemHandler.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (index == current) {
                this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
                return stack;
            }
            ++current;
        }
        return ItemStack.f_41583_;
    }

    public boolean[] getBlockArray() {
        boolean[] bools = new boolean[MAX_STACKS];
        for (int i = 0; i < MAX_STACKS; ++i) {
            bools[i] = this.isBlock[i].get();
        }
        return bools;
    }

    public InteractionResult onBlockUse(BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.f_19853_.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        List<ItemStack> stacks = this.getStacksInOrder();
        if (!(hit instanceof SubHitBlockHitResult)) {
            return InteractionResult.PASS;
        }
        int index = ((SubHitBlockHitResult)hit).subHit - 1;
        ItemStack held = player.m_21120_(hand);
        if (!held.m_41619_() && held.m_41720_() == DEContent.crystal_binder && this.getStacksInOrder().size() == 1) {
            this.toolMode.invert();
            this.tick();
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_()) {
            if (index >= 0 && index < this.rotation.length) {
                this.rotation[index].inc();
                BCoreNetwork.sendSound((Level)this.f_58857_, (BlockPos)this.f_58858_, (SoundEvent)SoundEvents.f_12017_, (SoundSource)SoundSource.PLAYERS, (float)1.0f, (float)(0.9f + this.f_58857_.f_46441_.nextFloat() * 0.2f), (boolean)false);
                this.tick();
            }
            return InteractionResult.SUCCESS;
        }
        if (index == -1) {
            this.onBroken(player, Vector3.fromEntityCenter((Entity)player), true);
            this.f_58857_.m_7471_(this.m_58899_(), false);
            return InteractionResult.SUCCESS;
        }
        if (index < stacks.size()) {
            ItemStack stack = this.extractStackAtIndex(index);
            InventoryUtils.givePlayerStack((Player)player, (ItemStack)stack);
            if (stacks.size() == 1) {
                this.f_58857_.m_7471_(this.m_58899_(), false);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void onBlockAttack(BlockState state, Player player) {
        if (!player.m_6144_()) {
            return;
        }
        List<ItemStack> stacks = this.getStacksInOrder();
        if (stacks.size() == 1 && !(stacks.get(0).m_41720_() instanceof BlockItem)) {
            this.toolMode.invert();
            BCoreNetwork.sendSound((Level)this.f_58857_, (BlockPos)this.f_58858_, (SoundEvent)SoundEvents.f_12017_, (SoundSource)SoundSource.PLAYERS, (float)1.0f, (float)(0.9f + this.f_58857_.f_46441_.nextFloat() * 0.2f), (boolean)false);
            this.tick();
        } else {
            HitResult hit = player.m_19907_(4.0, 0.0f, false);
            if (hit instanceof SubHitBlockHitResult && hit.m_6662_() == HitResult.Type.BLOCK && ((SubHitBlockHitResult)hit).subHit > 0 && ((SubHitBlockHitResult)hit).subHit - 1 < this.rotation.length) {
                this.rotation[((SubHitBlockHitResult)hit).subHit - 1].dec();
                BCoreNetwork.sendSound((Level)this.f_58857_, (BlockPos)this.f_58858_, (SoundEvent)SoundEvents.f_12017_, (SoundSource)SoundSource.PLAYERS, (float)1.0f, (float)(0.9f + this.f_58857_.f_46441_.nextFloat() * 0.2f), (boolean)false);
                this.tick();
            }
        }
    }

    public void onBroken(Player player, Vector3 dropPos, boolean noPickupDelay) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!player.m_150110_().f_35937_) {
                TilePlacedItem.popResource(this.f_58857_, dropPos, this.itemHandler.getStackInSlot(i), noPickupDelay);
            }
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public static void popResource(Level world, Vector3 pos, ItemStack stack, boolean noPickupDelay) {
        if (!world.f_46443_ && !stack.m_41619_() && world.m_46469_().m_46207_(GameRules.f_46136_) && !world.restoringBlockSnapshots) {
            double d0 = (double)(world.f_46441_.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(world.f_46441_.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(world.f_46441_.nextFloat() * 0.5f) + 0.25;
            ItemEntity itementity = new ItemEntity(world, pos.x + d0, pos.y + d1, pos.z + d2, stack);
            if (noPickupDelay) {
                itementity.m_32061_();
            } else {
                itementity.m_32060_();
            }
            world.m_7967_((Entity)itementity);
        }
    }

    public boolean saveToItem() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_142082_(-1, -1, -1), this.f_58858_.m_142082_(2, 2, 2));
    }
}

