/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.inventory.ItemHandlerIOControl;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.blocks.machines.Generator;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.ContainerDETile;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.brandon3055.draconicevolution.lib.ISidedTileHandler;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class TileGenerator
extends TileBCore
implements IRSSwitchable,
MenuProvider,
IInteractTile {
    private ISidedTileHandler soundHandler = DraconicEvolution.proxy.createGeneratorSoundHandler(this);
    public final ManagedInt fuelValue = (ManagedInt)this.register((IManagedData)new ManagedInt("fuel_value", 1, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public final ManagedInt fuelRemaining = (ManagedInt)this.register((IManagedData)new ManagedInt("fuel_remaining", 0, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public final ManagedInt productionRate = (ManagedInt)this.register((IManagedData)new ManagedInt("prod_rate", 0, new DataFlags[]{DataFlags.SYNC_CONTAINER}));
    public final ManagedEnum<Mode> mode = (ManagedEnum)this.register((IManagedData)new ManagedEnum("mode", (Enum)Mode.NORMAL, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", false, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    private double consumptionBuffer = 0.0;
    private double productionBuffer = 0.0;
    public float rotation = 0.0f;
    public float rotationSpeed = 0.0f;
    public TileItemStackHandler itemHandler = new TileItemStackHandler(4);
    public OPStorage opStorage = new ModularOPStorage(this, 100000L, 0L, 32000L);

    public TileGenerator(BlockPos pos, BlockState state) {
        super(DEContent.tile_generator, pos, state);
        this.capManager.setManaged("energy", DECapabilities.OP_STORAGE, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.capManager.setInternalManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler).saveBoth();
        this.itemHandler.setStackValidator((slot, stack) -> slot > 2 || ForgeHooks.getBurnTime((ItemStack)stack, null) > 0);
        this.setupPowerSlot((IItemHandler)this.itemHandler, 3, (IOPStorage)this.opStorage, true);
        this.capManager.set(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ItemHandlerIOControl((IItemHandler)this.itemHandler).setExtractCheck(this::canExtractItem), new Direction[0]);
        this.installIOTracker(this.opStorage);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.rotationSpeed = this.active.get() ? ((Mode)this.mode.get()).animFanSpeed : 0.0f;
            this.rotation += this.rotationSpeed;
            this.updateSoundAndFX();
            return;
        }
        boolean last = this.active.get();
        this.active.set(this.fuelRemaining.get() > 0 && this.opStorage.getOPStored() < this.opStorage.getMaxOPStored() && this.isTileEnabled());
        if (this.active.get() != last) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)Generator.ACTIVE, (Comparable)Boolean.valueOf(this.active.get())));
        }
        if (this.active.get()) {
            double genRate = 1.0 - (double)this.opStorage.getOPStored() / (double)this.opStorage.getMaxOPStored();
            genRate = Math.min(1.0, genRate * 4.0);
            double energy = Math.max(1.0, genRate * (double)((Mode)this.mode.get()).powerOutput);
            double fuel = energy / (double)((Mode)this.mode.get()).energyPerFuelUnit;
            this.consumptionBuffer += fuel;
            if ((double)this.fuelRemaining.get() < this.consumptionBuffer) {
                this.tryRefuel();
                if ((double)this.fuelRemaining.get() < this.consumptionBuffer) {
                    this.consumptionBuffer = this.fuelRemaining.get();
                    energy = this.consumptionBuffer * (double)((Mode)this.mode.get()).energyPerFuelUnit;
                }
            }
            this.productionRate.set((int)energy);
            this.productionBuffer += energy;
            if (this.consumptionBuffer >= 1.0) {
                this.fuelRemaining.subtract((int)this.consumptionBuffer);
                this.consumptionBuffer %= 1.0;
            }
            if (this.productionBuffer >= 1.0) {
                this.opStorage.modifyEnergyStored((long)((int)this.productionBuffer));
                this.productionBuffer %= 1.0;
            }
        } else {
            this.productionRate.set(0);
        }
        if (this.isTileEnabled() && this.fuelRemaining.get() <= 0) {
            this.tryRefuel();
        }
        this.opStorage.modifyEnergyStored(-this.sendEnergyToAll(this.opStorage.maxExtract(), this.opStorage.getOPStored()));
    }

    public void tryRefuel() {
        for (int i = 0; i < 3; ++i) {
            int itemBurnTime;
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_() || (itemBurnTime = ForgeHooks.getBurnTime((ItemStack)stack, null)) <= 0) continue;
            if (stack.m_41613_() == 1) {
                stack = stack.m_41720_().getContainerItem(stack);
            } else {
                stack.m_41774_(1);
            }
            this.itemHandler.setStackInSlot(i, stack);
            this.fuelValue.set(itemBurnTime);
            this.fuelRemaining.add(itemBurnTime);
            return;
        }
    }

    private boolean canExtractItem(int slot, ItemStack stack) {
        return slot == 3 && EnergyUtils.isFullyOrInvalid((ItemStack)stack) || slot != 3 && ForgeHooks.getBurnTime((ItemStack)stack, null) <= 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateSoundAndFX() {
        Direction enumfacing;
        this.soundHandler.tick();
        if (!this.active.get() || this.f_58858_.m_123331_((Vec3i)Minecraft.m_91087_().f_91074_.m_142538_()) > 256.0) {
            return;
        }
        Random rand = this.f_58857_.f_46441_;
        double p = 0.0625;
        if (rand.nextInt(17 - ((Mode)this.mode.get()).index * 4) == 0) {
            enumfacing = (Direction)this.m_58900_().m_61143_((Property)Generator.FACING);
            double pgx = p * 7.5 + (double)rand.nextInt(6) * p;
            double pgy = 0.3;
            double pgz = 0.5;
            double outOffset = 0.48;
            switch (enumfacing) {
                case WEST: {
                    this.spawnGrillParticle(rand, (double)this.f_58858_.m_123341_() + pgz - outOffset, (double)this.f_58858_.m_123342_() + pgy, (double)this.f_58858_.m_123343_() + pgx);
                    break;
                }
                case EAST: {
                    this.spawnGrillParticle(rand, (double)this.f_58858_.m_123341_() + pgz + outOffset, (double)this.f_58858_.m_123342_() + pgy, (double)this.f_58858_.m_123343_() + (1.0 - pgx));
                    break;
                }
                case NORTH: {
                    this.spawnGrillParticle(rand, (double)this.f_58858_.m_123341_() + (1.0 - pgx), (double)this.f_58858_.m_123342_() + pgy, (double)this.f_58858_.m_123343_() + pgz - outOffset);
                    break;
                }
                case SOUTH: {
                    this.spawnGrillParticle(rand, (double)this.f_58858_.m_123341_() + pgx, (double)this.f_58858_.m_123342_() + pgy, (double)this.f_58858_.m_123343_() + pgz + outOffset);
                }
            }
        }
        if (rand.nextInt(5 - ((Mode)this.mode.get()).index) == 0) {
            enumfacing = (Direction)this.m_58900_().m_61143_((Property)Generator.FACING);
            double pex = p * 3.0 + (double)rand.nextInt(5) * p;
            double pey = p * 6.5;
            double pez = 0.5;
            double exhaustOffset = 0.4;
            double exhaustVelocity = 0.02 + (0.08 + rand.nextDouble() * 0.02) * ((double)((Mode)this.mode.get()).index / 4.0);
            switch (enumfacing) {
                case WEST: {
                    this.spawnExhaustParticle(rand, (double)this.f_58858_.m_123341_() + (1.0 - pex), (double)this.f_58858_.m_123342_() + pey, (double)this.f_58858_.m_123343_() + pez - exhaustOffset, new Vec3D(0.0, 0.0, -exhaustVelocity));
                    break;
                }
                case EAST: {
                    this.spawnExhaustParticle(rand, (double)this.f_58858_.m_123341_() + pex, (double)this.f_58858_.m_123342_() + pey, (double)this.f_58858_.m_123343_() + pez + exhaustOffset, new Vec3D(0.0, 0.0, exhaustVelocity));
                    break;
                }
                case NORTH: {
                    this.spawnExhaustParticle(rand, (double)this.f_58858_.m_123341_() + pez + exhaustOffset, (double)this.f_58858_.m_123342_() + pey, (double)this.f_58858_.m_123343_() + (1.0 - pex), new Vec3D(exhaustVelocity, 0.0, 0.0));
                    break;
                }
                case SOUTH: {
                    this.spawnExhaustParticle(rand, (double)this.f_58858_.m_123341_() + pez - exhaustOffset, (double)this.f_58858_.m_123342_() + pey, (double)this.f_58858_.m_123343_() + pex, new Vec3D(-exhaustVelocity, 0.0, 0.0));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnGrillParticle(Random rand, double x, double y, double z) {
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
        if (this.mode.get() != Mode.PERFORMANCE_PLUS && rand.nextInt(8) == 0) {
            this.f_58857_.m_7106_((ParticleOptions)new IntParticleType.IntParticleData((ParticleType)DEParticles.flame, new int[]{127}), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnExhaustParticle(Random rand, double x, double y, double z, Vec3D velocity) {
        if (rand.nextBoolean()) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, velocity.x, velocity.y, velocity.z);
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, velocity.x, velocity.y, velocity.z);
        } else {
            this.f_58857_.m_7106_((ParticleOptions)new IntParticleType.IntParticleData((ParticleType)DEParticles.flame, new int[]{64, (int)((0.1 + rand.nextDouble() * 0.05) * 255.0)}), x, y, z, velocity.x, velocity.y, velocity.z);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new ContainerDETile<TileGenerator>(DEContent.container_generator, currentWindowIndex, player.m_150109_(), this, GuiLayoutFactories.GENERATOR_LAYOUT);
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        }
        return true;
    }

    public static enum Mode {
        ECO_PLUS(0, 50, 5, 0.3f),
        ECO(1, 15, 20, 0.4f),
        NORMAL(2, 10, 40, 0.6f),
        PERFORMANCE(3, 8, 80, 0.8f),
        PERFORMANCE_PLUS(4, 5, 300, 1.0f);

        public final int index;
        public final int energyPerFuelUnit;
        public final int powerOutput;
        private float animFanSpeed;

        private Mode(int index, int energyPerFuelUnit, int powerOutput, float animFanSpeed) {
            this.index = index;
            this.energyPerFuelUnit = energyPerFuelUnit;
            this.powerOutput = powerOutput;
            this.animFanSpeed = animFanSpeed;
        }

        public Mode next(boolean prev) {
            if (prev) {
                return Mode.values()[this.index - 1 < 0 ? Mode.values().length - 1 : this.index - 1];
            }
            return Mode.values()[this.index + 1 == Mode.values().length ? 0 : this.index + 1];
        }

        public int getEfficiency() {
            return (int)((float)this.energyPerFuelUnit / 10.0f * 100.0f);
        }

        public String unlocalizedName() {
            return "gui.draconicevolution.generator.mode_" + this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

