/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.inventory.ItemHandlerIOControl;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedFloat;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedResource;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.lib.datamanager.ManagedTextComponent;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IFusionStateMachine;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingInjector;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.tile.fxhandlers.ITileFXHandler;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.ContainerFusionCraftingCore;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class TileFusionCraftingCore
extends TileBCore
implements IFusionInventory,
IFusionStateMachine,
MenuProvider,
IInteractTile,
IChangeListener {
    private final ManagedEnum<IFusionStateMachine.FusionState> fusionState = (ManagedEnum)this.register((IManagedData)new ManagedEnum("fusion_state", (Enum)IFusionStateMachine.FusionState.START, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedResource activeRecipe = (ManagedResource)this.register((IManagedData)new ManagedResource("active_recipe", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedBool crafting = (ManagedBool)this.register((IManagedData)new ManagedBool("is_crafting", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedInt fusionCounter = (ManagedInt)this.register((IManagedData)new ManagedInt("fusion_counter", new DataFlags[]{DataFlags.SAVE_NBT}));
    public final ManagedTextComponent userStatus = (ManagedTextComponent)this.register((IManagedData)new ManagedTextComponent("user_status", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public final ManagedFloat craftAnimProgress = (ManagedFloat)this.register((IManagedData)new ManagedFloat("craft_anim_progress", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedShort craftAnimLength = (ManagedShort)this.register((IManagedData)new ManagedShort("craft_anim_length", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedFloat progress = (ManagedFloat)this.register((IManagedData)new ManagedFloat("progress", -1.0f, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler(2);
    public ITileFXHandler fxHandler;
    private List<IFusionInjector> injectorCache = null;
    private List<BlockPos> injectorPositions = new ArrayList<BlockPos>();
    private IFusionRecipe recipeCache = null;
    private TechLevel minTierCache = null;

    public TileFusionCraftingCore(BlockPos pos, BlockState state) {
        super(DEContent.tile_crafting_core, pos, state);
        this.capManager.setInternalManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler).saveBoth();
        this.capManager.set(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ItemHandlerIOControl((IItemHandler)this.itemHandler).setInsertCheck((slot, stack) -> slot == 0).setExtractCheck((slot, stack) -> slot == 1), new Direction[0]);
        this.itemHandler.setContentsChangeListener(i -> this.localInventoryChange());
        this.itemHandler.setStackValidator((slot, stack) -> slot == 0);
        this.fxHandler = DraconicEvolution.proxy.createFusionFXHandler(this);
        this.activeRecipe.addValueListener(e -> {
            this.recipeCache = null;
        });
    }

    public void startCraft() {
        if (this.isCrafting()) {
            this.inventoryChanged();
            return;
        }
        this.updateInjectors();
        IFusionRecipe recipe = this.f_58857_.m_7465_().m_44015_(DraconicAPI.FUSION_RECIPE_TYPE, (Container)this, this.f_58857_).orElse(null);
        this.setActiveRecipe(recipe);
        if (recipe == null || !recipe.canStartCraft(this, this.f_58857_, null)) {
            return;
        }
        this.setCounter(0);
        this.setFusionState(IFusionStateMachine.FusionState.START);
        this.crafting.set(true);
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        this.startCraft();
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        if (id == 0) {
            this.injectorPositions.clear();
            int count = data.readShort();
            for (int i = 0; i < count; ++i) {
                this.injectorPositions.add(data.readPos());
            }
            this.injectorCache = null;
        } else if (id == 1) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 1.0, 0.0, 0.0);
            this.f_58857_.m_7785_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, DESounds.fusionComplete, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_58857_.f_46441_.nextFloat() - this.f_58857_.f_46441_.nextFloat()) * 0.2f) * 0.7f, false);
            for (int i = 0; i < 100; ++i) {
                double velX = (this.f_58857_.f_46441_.nextDouble() - 0.5) * 0.1;
                double velY = (this.f_58857_.f_46441_.nextDouble() - 0.5) * 0.1;
                double velZ = (this.f_58857_.f_46441_.nextDouble() - 0.5) * 0.1;
                this.f_58857_.m_7106_((ParticleOptions)new IntParticleType.IntParticleData((ParticleType)DEParticles.energy_basic, new int[]{0, 255, 255, 64}), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, velX, velY, velZ);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.fxHandler.tick();
        }
        if (this.crafting.get() && !this.f_58857_.f_46443_) {
            IFusionRecipe recipe = this.getActiveRecipe();
            if (recipe != null) {
                recipe.tickFusionState(this, this, this.f_58857_);
            } else {
                this.cancelCraft();
            }
        }
    }

    public boolean updateInjectors() {
        this.minTierCache = null;
        if (this.isCrafting() || this.f_58857_.f_46443_) {
            return true;
        }
        if (this.injectorPositions.isEmpty()) {
            this.setFusionStatus(-1.0, null);
        }
        this.injectorCache = null;
        ArrayList<BlockPos> oldPositions = new ArrayList<BlockPos>(this.injectorPositions);
        this.injectorPositions.clear();
        int range = DEConfig.fusionInjectorRange;
        int radius = 1;
        List searchTiles = Streams.concat((Stream[])new Stream[]{BlockPos.m_121990_((BlockPos)this.f_58858_.m_142082_(-range, -radius, -radius), (BlockPos)this.f_58858_.m_142082_(range, radius, radius)), BlockPos.m_121990_((BlockPos)this.f_58858_.m_142082_(-radius, -range, -radius), (BlockPos)this.f_58858_.m_142082_(radius, range, radius)), BlockPos.m_121990_((BlockPos)this.f_58858_.m_142082_(-radius, -radius, -range), (BlockPos)this.f_58858_.m_142082_(radius, radius, range))}).map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).filter(e -> e instanceof TileFusionCraftingInjector).map(e -> (TileFusionCraftingInjector)e).collect(Collectors.toList());
        for (TileFusionCraftingInjector tile : searchTiles) {
            Vec3D dirVec = new Vec3D(tile.m_58899_()).subtract(this.f_58858_);
            double dist = Utils.getCardinalDistance((BlockPos)tile.m_58899_(), (BlockPos)this.f_58858_);
            if (dist <= (double)DEConfig.fusionInjectorMinDist) {
                this.setFusionStatus(-1.0, (Component)new TranslatableComponent("fusion_status.draconicevolution.injector_close").m_130940_(ChatFormatting.RED));
                this.injectorPositions.clear();
                return false;
            }
            if (Direction.m_122372_((float)((int)dirVec.x), (float)((int)dirVec.y), (float)((int)dirVec.z)) != tile.getRotation().m_122424_()) continue;
            BlockPos pos = tile.m_58899_();
            Direction facing = tile.getRotation();
            boolean obstructed = false;
            for (BlockPos bp : BlockPos.m_121940_((BlockPos)pos.m_142300_(facing), (BlockPos)pos.m_5484_(facing, FacingUtils.distanceInDirection((BlockPos)pos, (BlockPos)this.f_58858_, (Direction)facing) - 1))) {
                if (this.f_58857_.m_46859_(bp) || !this.f_58857_.m_8055_(bp).m_60815_() && !(this.f_58857_.m_7702_(bp) instanceof TileFusionCraftingInjector)) continue;
                obstructed = true;
                tile.setCore(null);
                break;
            }
            if (obstructed || !tile.setCore(this)) continue;
            this.injectorPositions.add(tile.m_58899_());
        }
        this.dirtyBlock();
        if (!oldPositions.equals(this.injectorPositions)) {
            this.sendPacketToChunk(e -> {
                e.writeShort(this.injectorPositions.size());
                this.injectorPositions.forEach(arg_0 -> ((MCDataOutput)e).writePos(arg_0));
            }, 0);
        }
        return true;
    }

    public void inventoryChanged() {
        this.m_6596_();
        if (!this.updateInjectors()) {
            return;
        }
        if (this.isCrafting()) {
            IFusionRecipe recipe = this.getActiveRecipe();
            if (recipe == null || !recipe.matches(this, this.f_58857_)) {
                this.cancelCraft();
            }
        } else if (!this.f_58857_.f_46443_) {
            IFusionRecipe recipe = this.f_58857_.m_7465_().m_44015_(DraconicAPI.FUSION_RECIPE_TYPE, (Container)this, this.f_58857_).orElse(null);
            if (recipe != null) {
                recipe.canStartCraft(this, this.f_58857_, e -> this.setFusionStatus(-1.0, (Component)e));
            } else {
                this.setFusionStatus(-1.0, (Component)new TranslatableComponent("fusion_status.draconicevolution.no_recipe"));
            }
            this.setActiveRecipe(recipe);
        }
    }

    private void localInventoryChange() {
        this.updateBlock();
        this.inventoryChanged();
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            this.updateInjectors();
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        }
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new ContainerFusionCraftingCore(currentWindowIndex, player.m_150109_(), this, GuiLayoutFactories.FUSION_CRAFTING_CORE);
    }

    @Override
    @Nonnull
    public ItemStack getCatalystStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    @Override
    @Nonnull
    public ItemStack getOutputStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    @Override
    public void setCatalystStack(@Nonnull ItemStack stack) {
        this.itemHandler.setStackInSlot(0, stack);
    }

    @Override
    public void setOutputStack(@Nonnull ItemStack stack) {
        this.itemHandler.setStackInSlot(1, stack);
    }

    @Override
    public List<IFusionInjector> getInjectors() {
        if (this.injectorCache == null) {
            this.injectorCache = this.injectorPositions.stream().map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).filter(e -> e instanceof IFusionInjector).map(e -> (IFusionInjector)e).collect(Collectors.toList());
        }
        return this.injectorCache;
    }

    @Override
    public TechLevel getMinimumTier() {
        if (this.minTierCache == null) {
            this.minTierCache = this.getInjectors().stream().filter(e -> !e.getInjectorStack().m_41619_()).sorted(Comparator.comparing(e -> e.getInjectorTier().index)).map(IFusionInjector::getInjectorTier).findFirst().orElse(TechLevel.DRACONIUM);
        }
        return this.minTierCache;
    }

    public void onNeighborChange(BlockPos neighbor) {
        super.onNeighborChange(neighbor);
        this.updateInjectors();
    }

    @Override
    public IFusionStateMachine.FusionState getFusionState() {
        return (IFusionStateMachine.FusionState)this.fusionState.get();
    }

    @Override
    public void setFusionState(IFusionStateMachine.FusionState state) {
        this.fusionState.set((Enum)state);
        this.m_6596_();
    }

    @Override
    public void completeCraft() {
        this.crafting.set(false);
        this.inventoryChanged();
        this.sendPacketToChunk(e -> {}, 1);
    }

    @Override
    public void cancelCraft() {
        this.crafting.set(false);
        this.getInjectors().forEach(e -> e.setEnergyRequirement(0L, 0L));
        this.setFusionStatus(-1.0, (Component)new TranslatableComponent("fusion_status.draconicevolution.canceled"));
        this.f_58857_.m_5594_(null, this.m_58899_(), DESounds.fusionComplete, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_58857_.f_46441_.nextFloat() - this.f_58857_.f_46441_.nextFloat()) * 0.2f) * 0.7f);
        this.inventoryChanged();
    }

    @Override
    public int getCounter() {
        return this.fusionCounter.get();
    }

    @Override
    public void setCounter(int count) {
        this.fusionCounter.set(count);
    }

    @Override
    public void setFusionStatus(double progress, Component stateText) {
        this.progress.set((float)progress);
        this.userStatus.set(stateText);
    }

    @Override
    public void setCraftAnimation(float progress, int length) {
        this.craftAnimProgress.set(progress);
        this.craftAnimLength.set((short)length);
    }

    public boolean isCrafting() {
        return this.crafting.get();
    }

    @Nullable
    public IFusionRecipe getActiveRecipe() {
        Recipe recipe;
        if (this.recipeCache == null && this.activeRecipe.get() != null && (recipe = (Recipe)this.f_58857_.m_7465_().m_44043_(this.activeRecipe.get()).orElse(null)) instanceof IFusionRecipe) {
            this.recipeCache = (IFusionRecipe)recipe;
        }
        return this.recipeCache;
    }

    public void setActiveRecipe(@Nullable IFusionRecipe recipe) {
        this.recipeCache = recipe;
        this.activeRecipe.set(recipe == null ? null : recipe.m_6423_());
    }

    public int getComparatorOutput() {
        if (!this.getOutputStack().m_41619_()) {
            return 15;
        }
        if (this.crafting.get()) {
            return 1 + this.getFusionState().ordinal();
        }
        IFusionRecipe recipe = this.f_58857_.m_7465_().m_44015_(DraconicAPI.FUSION_RECIPE_TYPE, (Container)this, this.f_58857_).orElse(null);
        if (recipe != null && recipe.canStartCraft(this, this.f_58857_, null)) {
            return 1;
        }
        return 0;
    }

    public void writeExtraNBT(CompoundTag compound) {
        super.writeExtraNBT(compound);
        compound.m_128388_("injector_positions", this.injectorPositions.stream().mapToLong(BlockPos::m_121878_).toArray());
    }

    public void readExtraNBT(CompoundTag compound) {
        super.readExtraNBT(compound);
        this.injectorPositions = Arrays.stream(compound.m_128467_("injector_positions")).mapToObj(BlockPos::m_122022_).collect(Collectors.toList());
        this.injectorCache = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_142082_(-16, -16, -16), this.f_58858_.m_142082_(17, 17, 17));
    }
}

