/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.raytracer.SubHitBlockHitResult;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.ContainerDETile;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.brandon3055.draconicevolution.utils.ItemCapMerger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;

public class TileEnergyTransfuser
extends TileBCore
implements IInteractTile,
MenuProvider,
IRSSwitchable {
    public TileItemStackHandler itemNorth = new TileItemStackHandler(1).setSlotLimit(1).setStackValidator(EnergyUtils::isEnergyItem);
    public TileItemStackHandler itemEast = new TileItemStackHandler(1).setSlotLimit(1).setStackValidator(EnergyUtils::isEnergyItem);
    public TileItemStackHandler itemSouth = new TileItemStackHandler(1).setSlotLimit(1).setStackValidator(EnergyUtils::isEnergyItem);
    public TileItemStackHandler itemWest = new TileItemStackHandler(1).setSlotLimit(1).setStackValidator(EnergyUtils::isEnergyItem);
    private IItemHandlerModifiable[] indexedItemHandlers = new IItemHandlerModifiable[]{this.itemNorth, this.itemEast, this.itemSouth, this.itemWest};
    public IItemHandlerModifiable itemsCombined = (IItemHandlerModifiable)ItemCapMerger.merge(new IItemHandler[]{this.itemNorth, this.itemEast, this.itemSouth, this.itemWest});
    public IOPStorage opStorage = new OPIOAdapter();
    public ManagedEnum<ItemIOMode>[] ioModes = new ManagedEnum[4];
    public ManagedBool balancedMode = (ManagedBool)this.register((IManagedData)new ManagedBool("balance_mode", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER, DataFlags.CLIENT_CONTROL}));

    public TileEnergyTransfuser(BlockPos pos, BlockState state) {
        super(DEContent.tile_energy_transfuser, pos, state);
        this.capManager.setInternalManaged("item_north", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemNorth).syncTile().saveBoth();
        this.capManager.setInternalManaged("item_east", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemEast).syncTile().saveBoth();
        this.capManager.setInternalManaged("item_south", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemSouth).syncTile().saveBoth();
        this.capManager.setInternalManaged("item_west", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemWest).syncTile().saveBoth();
        this.capManager.set(CapabilityOP.OP, (Object)this.opStorage, new Direction[]{Direction.UP, Direction.DOWN, null});
        this.capManager.set(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ItemIOAdapter(0, (IItemHandler)this.itemNorth), new Direction[]{Direction.NORTH});
        this.capManager.set(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ItemIOAdapter(1, (IItemHandler)this.itemEast), new Direction[]{Direction.EAST});
        this.capManager.set(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ItemIOAdapter(2, (IItemHandler)this.itemSouth), new Direction[]{Direction.SOUTH});
        this.capManager.set(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ItemIOAdapter(3, (IItemHandler)this.itemWest), new Direction[]{Direction.WEST});
        this.capManager.set(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ItemIOAdapter(-1, (IItemHandler)this.itemsCombined), new Direction[]{Direction.UP, Direction.DOWN, null});
        for (int i = 0; i < 4; ++i) {
            this.ioModes[i] = (ManagedEnum)this.register((IManagedData)new ManagedEnum("item_mode_" + i, (Enum)ItemIOMode.CHARGE, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
        }
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_ || !this.isTileEnabled()) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            long maxExtract;
            boolean extractOverride;
            ItemStack stack;
            IOPStorage sourceStorage;
            ItemIOMode sourcemode = (ItemIOMode)this.ioModes[i].get();
            if (!sourcemode.discharge || (sourceStorage = EnergyUtils.getStorage((ItemStack)(stack = this.itemsCombined.getStackInSlot(i)))) == null) continue;
            boolean canExtract = sourceStorage.canExtract();
            boolean bl = extractOverride = !canExtract && sourcemode == ItemIOMode.DISCHARGE && sourceStorage instanceof IOPStorageModifiable;
            if (!canExtract && !extractOverride || (maxExtract = extractOverride ? Math.min(((IOPStorageModifiable)sourceStorage).maxExtract(), sourceStorage.getOPStored()) : sourceStorage.extractOP(sourceStorage.getOPStored(), true)) == 0L) continue;
            long totalSent = 0L;
            long sent = this.sendEnergyTo(maxExtract, Direction.DOWN);
            maxExtract -= sent;
            totalSent += sent;
            sent = this.sendEnergyTo(maxExtract, Direction.UP);
            totalSent += sent;
            if ((maxExtract -= sent) > 0L) {
                for (int j = 0; j < 4; ++j) {
                    if (j == i || maxExtract == 0L) continue;
                    ItemIOMode targetMode = (ItemIOMode)this.ioModes[j].get();
                    if (!targetMode.charge || targetMode != ItemIOMode.CHARGE && sourcemode != ItemIOMode.DISCHARGE) continue;
                    sent = EnergyUtils.insertEnergy((ItemStack)this.itemsCombined.getStackInSlot(j), (long)maxExtract, (boolean)false);
                    maxExtract -= sent;
                    totalSent += sent;
                }
            }
            if (extractOverride) {
                ((IOPStorageModifiable)sourceStorage).modifyEnergyStored(-totalSent);
                continue;
            }
            sourceStorage.extractOP(totalSent, false);
        }
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult trace) {
        int slot;
        if (this.f_58857_.f_46443_) {
            return true;
        }
        BlockHitResult hit = RayTracer.retrace((Player)player);
        int n = slot = hit instanceof SubHitBlockHitResult ? ((SubHitBlockHitResult)hit).subHit : -1;
        if (slot > -1 && slot < 4) {
            ItemStack stack = this.itemsCombined.getStackInSlot(slot);
            ItemStack heldStack = player.m_21120_(handIn);
            if (!stack.m_41619_() && heldStack.m_41619_()) {
                player.m_21008_(handIn, stack);
                this.itemsCombined.setStackInSlot(slot, ItemStack.f_41583_);
                return true;
            }
            if (stack.m_41619_() && !heldStack.m_41619_() && this.itemsCombined.isItemValid(slot, heldStack)) {
                if (heldStack.m_41613_() > 1) {
                    ItemStack copy = heldStack.m_41777_();
                    copy.m_41764_(1);
                    this.itemsCombined.setStackInSlot(slot, copy);
                    heldStack.m_41774_(1);
                } else {
                    this.itemsCombined.setStackInSlot(slot, heldStack);
                    player.m_21008_(handIn, ItemStack.f_41583_);
                }
                return true;
            }
        }
        if (player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        }
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new ContainerDETile<TileEnergyTransfuser>(DEContent.container_energy_transfuser, id, player.m_150109_(), this, GuiLayoutFactories.TRANSFUSER_LAYOUT);
    }

    public class OPIOAdapter
    implements IOPStorage {
        public long receiveOP(long maxReceive, boolean simulate) {
            if (!TileEnergyTransfuser.this.isTileEnabled()) {
                return 0L;
            }
            long totalAccepted = 0L;
            for (int i = 0; i < 4; ++i) {
                long accepted;
                ItemIOMode mode = (ItemIOMode)TileEnergyTransfuser.this.ioModes[i].get();
                if (!mode.charge) continue;
                ItemStack stack = TileEnergyTransfuser.this.itemsCombined.getStackInSlot(i);
                if (TileEnergyTransfuser.this.balancedMode.get()) {
                    accepted = EnergyUtils.insertEnergy((ItemStack)stack, (long)(maxReceive / 4L), (boolean)simulate);
                } else {
                    accepted = EnergyUtils.insertEnergy((ItemStack)stack, (long)maxReceive, (boolean)simulate);
                    maxReceive -= accepted;
                }
                totalAccepted += accepted;
            }
            return totalAccepted;
        }

        public long extractOP(long maxExtract, boolean simulate) {
            if (!TileEnergyTransfuser.this.isTileEnabled()) {
                return 0L;
            }
            long totalExtracted = 0L;
            for (int i = 0; i < 4; ++i) {
                ItemIOMode mode = (ItemIOMode)TileEnergyTransfuser.this.ioModes[i].get();
                if (!mode.discharge) continue;
                ItemStack stack = TileEnergyTransfuser.this.itemsCombined.getStackInSlot(i);
                long extracted = EnergyUtils.extractEnergy((ItemStack)stack, (long)maxExtract, (boolean)simulate);
                totalExtracted += extracted;
                maxExtract -= extracted;
            }
            return totalExtracted;
        }

        public long getOPStored() {
            long total = 0L;
            for (int i = 0; i < 4; ++i) {
                total += EnergyUtils.getEnergyStored((ItemStack)TileEnergyTransfuser.this.itemsCombined.getStackInSlot(i));
            }
            return total;
        }

        public long getMaxOPStored() {
            long total = 0L;
            for (int i = 0; i < 4; ++i) {
                total += EnergyUtils.getMaxEnergyStored((ItemStack)TileEnergyTransfuser.this.itemsCombined.getStackInSlot(i));
            }
            return total;
        }

        public boolean canExtract() {
            if (!TileEnergyTransfuser.this.isTileEnabled()) {
                return false;
            }
            for (ManagedEnum<ItemIOMode> mode : TileEnergyTransfuser.this.ioModes) {
                if (!((ItemIOMode)mode.get()).discharge) continue;
                return true;
            }
            return false;
        }

        public boolean canReceive() {
            if (!TileEnergyTransfuser.this.isTileEnabled()) {
                return false;
            }
            for (ManagedEnum<ItemIOMode> mode : TileEnergyTransfuser.this.ioModes) {
                if (!((ItemIOMode)mode.get()).charge) continue;
                return true;
            }
            return false;
        }

        public long modifyEnergyStored(long amount) {
            return 0L;
        }
    }

    public class ItemIOAdapter
    implements IItemHandler {
        private int index;
        private IItemHandler handler;

        public ItemIOAdapter(int index, IItemHandler handler) {
            this.index = index;
            this.handler = handler;
        }

        public int getSlots() {
            return this.handler.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.handler.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemIOMode mode = this.getMode(slot);
            if (mode == ItemIOMode.DISABLED) {
                return stack;
            }
            return this.handler.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemIOMode mode = this.getMode(slot);
            IOPStorage storage = EnergyUtils.getStorage((ItemStack)this.handler.getStackInSlot(slot));
            if (storage != null && mode.canExtract(storage)) {
                return this.handler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.handler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.handler.isItemValid(slot, stack);
        }

        private ItemIOMode getMode(int slot) {
            int i = this.index != -1 ? this.index : slot;
            return (ItemIOMode)TileEnergyTransfuser.this.ioModes[i].get();
        }
    }

    public static enum ItemIOMode {
        CHARGE(0, "mode_charge", true, false, 16745728),
        DISCHARGE(1, "mode_discharge", false, true, 20735),
        BUFFER(2, "mode_buffer", true, true, 0xFF00FF),
        DISABLED(3, "mode_disabled", false, false, 0x202020);

        private int index;
        private String name;
        public final boolean discharge;
        public final boolean charge;
        private int colour;

        private ItemIOMode(int index, String name, boolean charge, boolean discharge, int colour) {
            this.index = index;
            this.name = name;
            this.discharge = discharge;
            this.charge = charge;
            this.colour = colour;
        }

        public ItemIOMode nextMode(boolean previous) {
            return ItemIOMode.values()[Math.floorMod(this.index + (previous ? -1 : 1), ItemIOMode.values().length)];
        }

        public String getName() {
            return this.name;
        }

        public String getSpriteName() {
            return "transfuser/" + this.name;
        }

        public boolean canExtract(IOPStorage storage) {
            switch (this) {
                case CHARGE: {
                    return storage.getOPStored() >= storage.getMaxOPStored();
                }
                case DISCHARGE: {
                    return storage.getOPStored() == 0L || !storage.canExtract() && !(storage instanceof IOPStorageModifiable);
                }
            }
            return false;
        }

        public int getColour() {
            return this.colour;
        }
    }
}

