/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.colour.Colour;
import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.api.power.IOTracker;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedFloat;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.lib.datamanager.ManagedString;
import com.brandon3055.brandonscore.lib.datamanager.ManagedUUID;
import com.brandon3055.brandonscore.multiblock.EmptyPart;
import com.brandon3055.brandonscore.multiblock.MultiBlockDefinition;
import com.brandon3055.brandonscore.multiblock.MultiBlockManager;
import com.brandon3055.brandonscore.multiblock.MultiBlockPart;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.machines.EnergyCore;
import com.brandon3055.draconicevolution.blocks.tileentity.MultiBlockController;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStructureBlock;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.ContainerDETile;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.brandon3055.draconicevolution.lib.MultiBlockBuilder;
import com.brandon3055.draconicevolution.lib.OPStorageOP;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TileEnergyCore
extends TileBCore
implements MenuProvider,
IInteractTile,
MultiBlockController {
    public static final int MAX_TIER = 8;
    public static final int MSG_TOGGLE_ACTIVATION = 1;
    public static final int MSG_BUILD_CORE = 2;
    public static final int ADV_STABILIZER_TIER = 5;
    public static final int MAX_STABILIZER_DIST = 16;
    public static final int DEFAULT_FRAME_COLOUR = 0x191919;
    public static final int DEFAULT_TRIANGLE_COLOUR = 0x660099;
    public static final int DEFAULT_EFFECT_COLOUR = 62194;
    public static final int DEFAULT_FRAME_COLOUR_T8 = 0x191919;
    public static final int DEFAULT_TRIANGLE_COLOUR_T8 = 10823168;
    public static final int DEFAULT_EFFECT_COLOUR_T8 = 0xFF7F00;
    public final ManagedByte tier = (ManagedByte)this.register((IManagedData)new ManagedByte("tier", 1, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool coreValid = (ManagedBool)this.register((IManagedData)new ManagedBool("core_valid", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool stabilizersValid = (ManagedBool)this.register((IManagedData)new ManagedBool("stabilizers_valid", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedPos[] stabilizerPositions = new ManagedPos[4];
    public final ManagedBool buildGuide = (ManagedBool)this.register((IManagedData)new ManagedBool("build_guide", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedFloat fillPercent = (ManagedFloat)this.register((IManagedData)new ManagedFloat("fill_percent", 0.0f, new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedString energyTarget = (ManagedString)this.register((IManagedData)new ManagedString("user_target", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool legacyRender = (ManagedBool)this.register((IManagedData)new ManagedBool("legacy_render", false, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool customColour = (ManagedBool)this.register((IManagedData)new ManagedBool("custom_colour", false, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedInt frameColour = (ManagedInt)this.register((IManagedData)new ManagedInt("frame_colour", 0x191919, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedInt innerColour = (ManagedInt)this.register((IManagedData)new ManagedInt("inner_colour", 0x660099, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedInt effectColour = (ManagedInt)this.register((IManagedData)new ManagedInt("effect_colour", 62194, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedUUID linkUUID = (ManagedUUID)this.register((IManagedData)new ManagedUUID("link_uuid", (UUID)null, new DataFlags[]{DataFlags.SAVE_NBT}));
    public OPStorageOP energy = new OPStorageOP(this::getCapacity);
    private MultiBlockDefinition definitionCache = null;
    private MultiBlockBuilder activeBuilder = null;
    private int defCacheLastTier = 1;

    public TileEnergyCore(BlockPos pos, BlockState state) {
        super(DEContent.tile_storage_core, pos, state);
        this.capManager.setInternalManaged("energy", CapabilityOP.OP, (INBTSerializable)this.energy).saveTile().syncContainer();
        this.energy.setIOTracker((IOTracker)this.addTickable((Runnable)new IOTracker()));
        for (int i = 0; i < this.stabilizerPositions.length; ++i) {
            this.stabilizerPositions[i] = (ManagedPos)this.register((IManagedData)new ManagedPos("stabilizer_pos_" + i, (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        }
        this.tier.addValueListener(e -> {
            this.stabilizersValid.set(false);
            this.validateStructure();
        });
        this.energyTarget.setCCSCS();
    }

    public void writeExtraNBT(CompoundTag nbt) {
        super.writeExtraNBT(nbt);
    }

    public void readExtraNBT(CompoundTag nbt) {
        super.readExtraNBT(nbt);
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            if (this.activeBuilder != null) {
                if (this.activeBuilder.isDead()) {
                    this.activeBuilder = null;
                } else {
                    this.activeBuilder.updateProcess();
                }
            }
            if (this.tier.get() == 8) {
                this.fillPercent.set(0.0f);
            } else {
                this.fillPercent.set((float)this.energy.getOPStored() / (float)this.energy.getMaxOPStored());
            }
        }
    }

    @Override
    public InteractionResult handleRemoteClick(Player player, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            this.validateStructure();
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        super.receivePacketFromClient(data, client, id);
        switch (id) {
            case 1: {
                this.toggleActivation();
                break;
            }
            case 2: {
                this.attemptAutoBuild(client);
            }
        }
    }

    public InteractionResult onBlockUse(BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleRemoteClick(player, hand, hit);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new ContainerDETile<TileEnergyCore>(DEContent.container_energy_core, currentWindowIndex, player.m_150109_(), this, GuiLayoutFactories.ENERGY_CORE_LAYOUT);
    }

    public int getAccessDistanceSq() {
        return 1024;
    }

    public void toggleActivation() {
        if (!this.f_58857_.f_46443_) {
            if (this.active.get()) {
                this.deactivateCore();
                return;
            }
            if (!this.validateStructure()) {
                return;
            }
            MultiBlockDefinition definition = this.getMultiBlockDef();
            if (definition == null) {
                return;
            }
            for (Map.Entry entry : definition.getBlocksAt(this.f_58858_).entrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                MultiBlockPart part = (MultiBlockPart)entry.getValue();
                if (pos.equals((Object)this.f_58858_) || this.f_58857_.m_46859_(pos) || part instanceof EmptyPart) continue;
                BlockState originalState = this.f_58857_.m_8055_(pos);
                if (originalState.m_60713_((Block)DEContent.structure_block)) {
                    this.deactivateCore();
                    f_58854_.error("Detected existing structure block when attempting to activate core...");
                    return;
                }
                this.f_58857_.m_46597_(pos, DEContent.structure_block.m_49966_());
                BlockEntity tile = this.f_58857_.m_7702_(pos);
                if (!(tile instanceof TileStructureBlock)) continue;
                ((TileStructureBlock)tile).blockName.set(originalState.m_60734_().getRegistryName());
                ((TileStructureBlock)tile).setController(this);
            }
            this.buildGuide.set(false);
            this.active.set(true);
            this.updateStabilizers(true);
            this.energy.validateStorage();
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)EnergyCore.ACTIVE, (Comparable)Boolean.valueOf(true)));
            this.linkUUID.set(UUID.randomUUID());
        }
    }

    private void updateStabilizers(boolean coreActive) {
        for (ManagedPos offset : this.stabilizerPositions) {
            BlockPos tilePos;
            BlockEntity tile;
            if (offset.get() == null || !((tile = this.f_58857_.m_7702_(tilePos = this.f_58858_.m_142082_(-offset.get().m_123341_(), -offset.get().m_123342_(), -offset.get().m_123343_()))) instanceof TileEnergyCoreStabilizer)) continue;
            TileEnergyCoreStabilizer stabilizer = (TileEnergyCoreStabilizer)tile;
            stabilizer.isCoreActive.set(coreActive);
        }
    }

    public void deactivateCore() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.linkUUID.set(null);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)EnergyCore.ACTIVE, (Comparable)Boolean.valueOf(false)));
        MultiBlockDefinition definition = this.getMultiBlockDef();
        if (definition == null) {
            return;
        }
        definition.getBlocksAt(this.f_58858_).keySet().forEach(pos -> {
            BlockEntity tile = this.f_58857_.m_7702_(pos);
            if (tile instanceof TileStructureBlock) {
                ((TileStructureBlock)tile).revert();
            }
        });
        this.active.set(false);
        this.updateStabilizers(false);
    }

    private void releaseStabilizers() {
        for (ManagedPos offset : this.stabilizerPositions) {
            if (offset.get() == null) continue;
            BlockPos tilePos = this.f_58858_.m_142082_(-offset.get().m_123341_(), -offset.get().m_123342_(), -offset.get().m_123343_());
            BlockEntity tile = this.f_58857_.m_7702_(tilePos);
            if (tile instanceof TileEnergyCoreStabilizer) {
                TileEnergyCoreStabilizer stabilizer = (TileEnergyCoreStabilizer)tile;
                stabilizer.setCore(null);
            }
            offset.set(null);
        }
    }

    public void onRemoved() {
        this.releaseStabilizers();
    }

    @Override
    public boolean validateStructure() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return true;
        }
        this.coreValid.set(this.isCoreValidForTier(this.tier.get()));
        this.checkStabilizers();
        boolean structureValid = this.isStructureValid();
        if (!structureValid && this.active.get()) {
            this.active.set(false);
            this.deactivateCore();
        }
        return structureValid;
    }

    @Override
    public boolean isStructureValid() {
        return this.stabilizersValid.get() && this.coreValid.get();
    }

    private boolean isCoreValidForTier(int tier) {
        MultiBlockDefinition definition = this.getMultiBlockDef();
        if (definition == null) {
            DraconicEvolution.LOGGER.error("Unable to find multi block definition for tier " + tier + " energy core. Something is broken...");
            return false;
        }
        List invalidParts = definition.test(this.f_58857_, this.f_58858_);
        return invalidParts.isEmpty();
    }

    public boolean checkStabilizers() {
        boolean valid = true;
        if (this.stabilizersValid.get()) {
            for (ManagedPos offset : this.stabilizerPositions) {
                if (offset.get() == null) {
                    valid = false;
                } else {
                    BlockPos tilePos = this.f_58858_.m_141950_((Vec3i)offset.get());
                    BlockEntity tile = this.f_58857_.m_7702_(tilePos);
                    if (tile instanceof TileEnergyCoreStabilizer) {
                        TileEnergyCoreStabilizer stabilizer = (TileEnergyCoreStabilizer)tile;
                        if (stabilizer.getCore() != this || this.reqAdvStabilizers() && !stabilizer.isStructureValid()) {
                            valid = false;
                        }
                    } else {
                        valid = false;
                    }
                }
                if (!valid) break;
            }
            if (!valid) {
                this.stabilizersValid.set(false);
                this.releaseStabilizers();
            }
        } else {
            for (Direction.Axis axis : Direction.Axis.f_122448_) {
                Direction[] dirs = FacingUtils.getFacingsAroundAxis((Direction.Axis)axis);
                ArrayList<TileEnergyCoreStabilizer> found = new ArrayList<TileEnergyCoreStabilizer>();
                block2: for (int fIndex = 0; fIndex < dirs.length; ++fIndex) {
                    Direction facing = dirs[fIndex];
                    for (int dist = 1; dist < 16; ++dist) {
                        TileEnergyCoreStabilizer stabilizer;
                        TileEnergyCore currentCore;
                        BlockPos testPos = this.f_58858_.m_142082_(facing.m_122429_() * dist, facing.m_122430_() * dist, facing.m_122431_() * dist);
                        BlockEntity tile = this.f_58857_.m_7702_(testPos);
                        if (!(tile instanceof TileEnergyCoreStabilizer) || (currentCore = (stabilizer = (TileEnergyCoreStabilizer)tile).getCore()) != null && stabilizer.getCore() != this || !stabilizer.isSuitableForCore(this.tier.get(), this)) continue;
                        found.add(stabilizer);
                        continue block2;
                    }
                }
                if (found.size() != 4) continue;
                for (TileEnergyCoreStabilizer stab : found) {
                    this.stabilizerPositions[found.indexOf(stab)].set(new BlockPos(this.f_58858_.m_123341_() - stab.m_58899_().m_123341_(), this.f_58858_.m_123342_() - stab.m_58899_().m_123342_(), this.f_58858_.m_123343_() - stab.m_58899_().m_123343_()));
                    stab.setCore(this);
                }
                this.stabilizersValid.set(true);
                break;
            }
            if (!this.stabilizersValid.get()) {
                valid = false;
            }
        }
        return valid;
    }

    public boolean reqAdvStabilizers() {
        return this.tier.get() >= 5;
    }

    private long getCapacity() {
        if (this.tier.get() <= 0 || this.tier.get() > 8) {
            DraconicEvolution.LOGGER.error("Tier not valid! WTF!!!");
            return 0L;
        }
        return DEConfig.coreCapacity[this.tier.get() - 1];
    }

    @Nullable
    public MultiBlockDefinition getMultiBlockDef() {
        if (this.definitionCache == null || this.defCacheLastTier != this.tier.get()) {
            this.defCacheLastTier = this.tier.get();
            this.definitionCache = MultiBlockManager.getDefinition((ResourceLocation)new ResourceLocation("draconicevolution", "energy_core_" + this.tier.get()));
        }
        return this.definitionCache;
    }

    private void attemptAutoBuild(ServerPlayer player) {
        if (this.activeBuilder != null && !this.activeBuilder.isDead()) {
            player.m_6352_((Component)new TranslatableComponent("msg.draconicevolution.energy_core.already_building").m_130940_(ChatFormatting.RED), Util.f_137441_);
        } else {
            MultiBlockDefinition definition = this.getMultiBlockDef();
            if (definition != null) {
                this.activeBuilder = new MultiBlockBuilder(this.f_58857_, this.m_58899_(), definition, (Player)player, this);
            }
        }
    }

    public int getColour() {
        if (this.tier.get() == 8) {
            return Colour.packRGBA((double)1.0, (double)0.28f, (double)0.05f, (double)1.0);
        }
        float colour = 1.0f - this.fillPercent.get();
        return Colour.packRGBA((double)1.0, (double)(colour * 0.3f), (double)(colour * 0.7f), (double)1.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderSelectionBox(DrawSelectionEvent.HighlightBlock event) {
        return false;
    }

    @Override
    public VoxelShape getShapeForPart(BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }
}

