/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.api.DislocatorEndPoint;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorSaveData;
import com.brandon3055.draconicevolution.handlers.dislocator.PlayerTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.TileTarget;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileDislocatorPedestal
extends TileBCore
implements DislocatorEndPoint,
IInteractTile {
    public final ManagedInt rotation = (ManagedInt)this.register((IManagedData)new ManagedInt("rotation", 0, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler(1);

    public TileDislocatorPedestal(BlockPos pos, BlockState state) {
        super(DEContent.tile_dislocator_pedestal, pos, state);
        this.capManager.setManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth().syncTile();
        this.itemHandler.setSlotValidator(0, stack -> stack.m_41720_() instanceof Dislocator);
    }

    public InteractionResult onBlockUse(BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.f_58857_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!player.m_6144_() && !stack.m_41619_()) {
            if (stack.m_41720_() instanceof Dislocator) {
                TargetPos location = ((Dislocator)stack.m_41720_()).getTargetPos(stack, this.f_58857_);
                if (location == null) {
                    if (BoundDislocator.isValid(stack)) {
                        if (BoundDislocator.isPlayer(stack)) {
                            player.m_6352_((Component)new TranslatableComponent("dislocate.draconicevolution.bound.cant_find_player").m_130940_(ChatFormatting.RED), Util.f_137441_);
                        } else {
                            player.m_6352_((Component)new TranslatableComponent("dislocate.draconicevolution.bound.cant_find_target").m_130940_(ChatFormatting.RED), Util.f_137441_);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                boolean silenced = this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_204336_(BlockTags.f_13089_);
                if (!silenced) {
                    BCoreNetwork.sendSound((Level)player.f_19853_, (BlockPos)player.m_142538_(), (SoundEvent)DESounds.portal, (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f), (boolean)false);
                }
                BoundDislocator.notifyArriving(stack, player.f_19853_, (Entity)player);
                location.teleport((Entity)player);
                if (!silenced) {
                    DelayedTask.run((int)1, () -> BCoreNetwork.sendSound((Level)player.f_19853_, (BlockPos)player.m_142538_(), (SoundEvent)DESounds.portal, (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f), (boolean)false));
                }
            }
            return InteractionResult.SUCCESS;
        }
        InventoryUtils.handleHeldStackTransfer((int)0, (IItemHandlerModifiable)this.itemHandler, (Player)player);
        this.detectAndSendChanges(false);
        if (BoundDislocator.isValid(stack) && BoundDislocator.isP2P(stack) && this.itemHandler.getStackInSlot(0).m_41619_()) {
            DislocatorSaveData.updateLinkTarget(this.f_58857_, stack, new PlayerTarget(player));
        }
        this.checkIn();
        this.m_6596_();
        this.updateBlock();
        return InteractionResult.SUCCESS;
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ instanceof ServerLevel) {
            this.checkIn();
        }
    }

    @Override
    @Nullable
    public Vec3 getArrivalPos(UUID linkID) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!BoundDislocator.isValid(stack) || !linkID.equals(BoundDislocator.getLinkId(stack))) {
            return null;
        }
        BlockPos pos = this.m_58899_();
        return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5);
    }

    public void checkIn() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (BoundDislocator.isValid(stack) && BoundDislocator.isP2P(stack)) {
            DislocatorSaveData.updateLinkTarget(this.f_58857_, stack, new TileTarget(this));
        }
    }
}

