/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.lib.datamanager.ManagedString;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class TileChaosCrystal
extends TileBCore {
    public int tick = 0;
    public final ManagedBool guardianDefeated = (ManagedBool)this.register((IManagedData)new ManagedBool("guardian_defeated", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedPos parentPos = (ManagedPos)this.register((IManagedData)new ManagedPos("parent_pos", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedLong posLock = (ManagedLong)this.register((IManagedData)new ManagedLong("pos_lock", -1L, new DataFlags[]{DataFlags.SAVE_NBT}));
    private final ManagedString dimLock = (ManagedString)this.register((IManagedData)new ManagedString("dim_lock", "", new DataFlags[]{DataFlags.SAVE_NBT}));
    private boolean validatePlacement = false;
    private int soundTimer;
    private boolean removing = false;

    public TileChaosCrystal(BlockPos pos, BlockState state) {
        super(DEContent.tile_chaos_crystal, pos, state);
    }

    public void tick() {
        if (this.validatePlacement) {
            this.posLock.set(this.f_58858_.m_121878_());
            this.dimLock.set(this.f_58857_.m_46472_().m_135782_().toString());
            for (int i = 1; i <= 2; ++i) {
                this.f_58857_.m_46597_(this.f_58858_.m_6630_(i), DEContent.chaos_crystal_part.m_49966_());
                this.f_58857_.m_46597_(this.f_58858_.m_6625_(i), DEContent.chaos_crystal_part.m_49966_());
                BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_6630_(i));
                if (tile instanceof TileChaosCrystal) {
                    ((TileChaosCrystal)tile).parentPos.set(this.f_58858_);
                }
                if (!((tile = this.f_58857_.m_7702_(this.f_58858_.m_6625_(i))) instanceof TileChaosCrystal)) continue;
                ((TileChaosCrystal)tile).parentPos.set(this.f_58858_);
            }
            this.validatePlacement = false;
        }
        if (this.m_58900_().m_60734_() != DEContent.chaos_crystal) {
            return;
        }
        ++this.tick;
        if (this.tick > 1 && !this.f_58857_.f_46443_ && this.hasBeenMoved()) {
            this.f_58857_.m_7471_(this.f_58858_, false);
        }
        if (!this.f_58857_.f_46443_ && this.soundTimer-- <= 0) {
            this.soundTimer = 3600 + this.f_58857_.f_46441_.nextInt(1200);
            BCoreNetwork.sendSound((Level)this.f_58857_, (BlockPos)this.f_58858_, (SoundEvent)DESounds.chaosChamberAmbient, (SoundSource)SoundSource.AMBIENT, (float)1.5f, (float)(this.f_58857_.f_46441_.nextFloat() * 0.4f + 0.8f), (boolean)false);
        }
        if (!this.f_58857_.f_46443_ && this.f_58857_ instanceof ServerLevel && this.guardianDefeated.get() && this.f_58857_.f_46441_.nextInt(50) == 0) {
            int x = 5 - this.f_58857_.f_46441_.nextInt(11);
            int z = 5 - this.f_58857_.f_46441_.nextInt(11);
            LightningBolt bolt = new LightningBolt(EntityType.f_20465_, this.f_58857_);
            bolt.m_6034_((double)(this.f_58858_.m_123341_() + x), (double)this.f_58857_.m_5452_(Heightmap.Types.WORLD_SURFACE, this.f_58858_).m_123342_(), (double)(this.f_58858_.m_123343_() + z));
            bolt.f_19811_ = true;
            this.f_58857_.m_7967_((Entity)bolt);
        }
    }

    public void detonate(Entity entity) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.parentPos.notNull()) {
            BlockEntity tile = this.f_58857_.m_7702_(this.parentPos.get());
            if (tile instanceof TileChaosCrystal && !((TileChaosCrystal)tile).removing) {
                ((TileChaosCrystal)tile).detonate(entity);
                this.f_58857_.m_46953_(tile.m_58899_(), true, entity);
            }
            return;
        }
        if (this.removing) {
            return;
        }
        this.removing = true;
        this.f_58857_.m_46597_(this.f_58858_.m_7494_(), Blocks.f_50016_.m_49966_());
        this.f_58857_.m_46597_(this.f_58858_.m_6630_(2), Blocks.f_50016_.m_49966_());
        this.f_58857_.m_46597_(this.f_58858_.m_7495_(), Blocks.f_50016_.m_49966_());
        this.f_58857_.m_46597_(this.f_58858_.m_6625_(2), Blocks.f_50016_.m_49966_());
        if (!this.guardianDefeated.get()) {
            Level world = this.f_58857_;
            BlockPos pos = this.f_58858_;
            ProcessHandler.addProcess((IProcess)new DelayedTask.Task(1, () -> {
                world.m_7731_(pos, DEContent.chaos_crystal.m_49966_(), 3);
                TileChaosCrystal tileChaosShard = (TileChaosCrystal)world.m_7702_(pos);
                tileChaosShard.onValidPlacement();
            }));
            return;
        }
        Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)new ItemStack((ItemLike)DEContent.chaos_shard, DEConfig.chaosDropCount));
        this.f_58857_.m_7471_(this.f_58858_, false);
        if (DEOldConfig.disableChaosIslandExplosion || this.hasBeenMoved()) {
            // empty if block
        }
    }

    public void setDefeated() {
        this.guardianDefeated.set(true);
        super.tick();
    }

    public void writeExtraNBT(CompoundTag compound) {
        super.writeExtraNBT(compound);
        if (this.validatePlacement) {
            compound.m_128379_("validate_placement", true);
        }
    }

    public void readExtraNBT(CompoundTag compound) {
        super.readExtraNBT(compound);
        this.validatePlacement = compound.m_128441_("validate_placement") && compound.m_128471_("validate_placement");
    }

    public void onValidPlacement() {
        this.validatePlacement = true;
    }

    private boolean hasBeenMoved() {
        return this.posLock.get() != this.f_58858_.m_121878_() || !this.dimLock.get().equals(this.f_58857_.m_46472_().m_135782_().toString());
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 1, 1)).m_82377_(3.0, 3.0, 3.0);
    }

    public boolean saveToItem() {
        return false;
    }

    public boolean attemptingBreak(Player player) {
        if (this.parentPos.isNull()) {
            if (player != null && player.m_150110_().f_35937_) {
                this.guardianDefeated.set(true);
            }
            return this.guardianDefeated.get();
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.parentPos.get());
        if (blockEntity instanceof TileChaosCrystal) {
            TileChaosCrystal tile = (TileChaosCrystal)blockEntity;
            return tile.attemptingBreak(player);
        }
        return false;
    }
}

