/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.draconicevolution.blocks.StructureBlock;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyPylon;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class EnergyPylon
extends EntityBlockBCore {
    public static final EnumProperty<Mode> MODE = EnumProperty.m_61587_((String)"mode", Mode.class);
    public static final DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");

    public EnergyPylon(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(MODE, (Comparable)((Object)Mode.OUTPUT))).m_61124_((Property)FACING, (Comparable)Direction.UP));
        this.setBlockEntity(() -> DEContent.tile_energy_pylon, true);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MODE, FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEnergyPylon) {
            TileEnergyPylon tile = (TileEnergyPylon)blockEntity;
            if (!level.f_46443_) {
                if (player.m_6144_()) {
                    tile.selectNextCore();
                } else {
                    tile.validateStructure();
                    if (tile.coreOffset.notNull()) {
                        tile.drawParticleBeam();
                    }
                }
            }
            return tile.structureValid.get() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEnergyPylon) {
            TileEnergyPylon tile = (TileEnergyPylon)blockEntity;
            if (!StructureBlock.buildingLock) {
                tile.validateStructure();
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileEnergyPylon) {
            TileEnergyPylon tile = (TileEnergyPylon)blockEntity;
            if (tile.opAdapter.getMaxOPStored() > 0L) {
                return (int)MathHelper.clip((double)((double)tile.opAdapter.getOPStored() / (double)tile.opAdapter.getMaxOPStored() * 15.0), (double)0.0, (double)15.0);
            }
        }
        return 0;
    }

    public static enum Mode implements StringRepresentable
    {
        OUTPUT,
        INPUT;


        public boolean canReceive() {
            return this == INPUT;
        }

        public boolean canExtract() {
            return this == OUTPUT;
        }

        public Mode reverse() {
            return this == OUTPUT ? INPUT : OUTPUT;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

