/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import codechicken.lib.inventory.InventoryUtils;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.hud.IHudBlock;
import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingInjector;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;

public class CraftingInjector
extends EntityBlockBCore
implements IHudBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static VoxelShape SHAPE_DOWN = Shapes.m_83048_((double)0.0625, (double)0.375, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
    private static VoxelShape SHAPE_UP = Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.625, (double)0.9375);
    private static VoxelShape SHAPE_NORTH = Shapes.m_83048_((double)0.0625, (double)0.0625, (double)0.375, (double)0.9375, (double)0.9375, (double)1.0);
    private static VoxelShape SHAPE_SOUTH = Shapes.m_83048_((double)0.0625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.625);
    private static VoxelShape SHAPE_WEST = Shapes.m_83048_((double)0.375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.9375, (double)0.9375);
    private static VoxelShape SHAPE_EAST = Shapes.m_83048_((double)0.0, (double)0.0625, (double)0.0625, (double)0.625, (double)0.9375, (double)0.9375);
    private final TechLevel techLevel;

    public CraftingInjector(BlockBehaviour.Properties properties, TechLevel techLevel) {
        super(properties);
        this.techLevel = techLevel;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP));
        this.setBlockEntity(() -> DEContent.tile_crafting_injector, false);
    }

    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public void m_6786_(LevelAccessor p_176206_1_, BlockPos p_176206_2_, BlockState p_176206_3_) {
        super.m_6786_(p_176206_1_, p_176206_2_, p_176206_3_);
    }

    public void m_6810_(BlockState p_196243_1_, Level world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileFusionCraftingInjector) {
            ((TileFusionCraftingInjector)tile).onDestroyed();
        }
        super.m_6810_(p_196243_1_, world, pos, p_196243_4_, p_196243_5_);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TileFusionCraftingInjector)) {
            return InteractionResult.FAIL;
        }
        TileFusionCraftingInjector craftingPedestal = (TileFusionCraftingInjector)tile;
        if (player.m_6144_()) {
            craftingPedestal.singleItem.set(!craftingPedestal.singleItem.get());
            ChatHelper.sendIndexed((Player)player, (Component)new TranslatableComponent("fusion_inj.draconicevolution." + (craftingPedestal.singleItem.get() ? "single_item" : "multi_item")), (int)98);
            craftingPedestal.getDataManager().detectAndSendChanges();
            return InteractionResult.SUCCESS;
        }
        if (!craftingPedestal.itemHandler.getStackInSlot(0).m_41619_()) {
            if (player.m_21205_().m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, craftingPedestal.itemHandler.getStackInSlot(0));
                craftingPedestal.setInjectorStack(ItemStack.f_41583_);
            } else {
                world.m_7967_((Entity)new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), craftingPedestal.itemHandler.getStackInSlot(0)));
                craftingPedestal.setInjectorStack(ItemStack.f_41583_);
            }
        } else {
            ItemStack stack = player.m_21205_();
            player.m_21008_(InteractionHand.MAIN_HAND, InventoryUtils.insertItem((IItemHandler)craftingPedestal.itemHandler, (ItemStack)stack, (boolean)false));
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        switch (facing) {
            case DOWN: {
                return SHAPE_DOWN;
            }
            case UP: {
                return SHAPE_UP;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: {
                return SHAPE_EAST;
            }
        }
        return super.m_5940_(state, worldIn, pos, context);
    }

    public void generateHudText(Level world, BlockPos pos, Player player, List<Component> displayList) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileFusionCraftingInjector) {
            boolean single = ((TileFusionCraftingInjector)te).singleItem.get();
            displayList.add((Component)new TranslatableComponent("fusion_inj.draconicevolution." + (single ? "single_item" : "multi_item")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}));
        }
    }
}

