/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.tileentity;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.Vec3B;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerClientWireless;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerServerWireless;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXRing;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileCrystalWirelessIO
extends TileCrystalBase {
    protected Map<Vec3B, Direction> receiverSideMap = new HashMap<Vec3B, Direction>();
    protected LinkedList<Vec3B> linkedReceivers = new LinkedList();
    protected LinkedList<BlockPos> receiverCache = null;
    protected Map<BlockPos, Direction> receiverFaceCache = null;
    protected List<LinkedDevice> fastList = new ArrayList<LinkedDevice>();
    protected List<LinkedDevice> slowList = new ArrayList<LinkedDevice>();
    public LinkedList<int[]> receiverTransferRates = new LinkedList();
    public LinkedList<Byte> receiverFlowRates = new LinkedList();
    public final ManagedBool useUpdateOptimisation = (ManagedBool)this.dataManager.register((IManagedData)new ManagedBool("transport_state", true, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public final ManagedBool inputMode = (ManagedBool)this.dataManager.register((IManagedData)new ManagedBool("input_mode", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public Map<Integer, Integer> containerReceiverFlow = new HashMap<Integer, Integer>();

    public TileCrystalWirelessIO(BlockPos pos, BlockState state) {
        super(DEContent.tile_crystal_wireless, pos, state);
    }

    public TileCrystalWirelessIO(TechLevel techLevel, BlockPos pos, BlockState state) {
        super(DEContent.tile_crystal_wireless, techLevel, pos, state);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_) {
            this.updateEnergyFlow();
        }
        super.tick();
    }

    private void updateEnergyFlow() {
        if (this.receiverTransferRates.size() != this.linkedReceivers.size()) {
            this.rebuildReceiverTransferList();
        }
        this.getReceiversFaces();
        ArrayList<LinkedDevice> moveToSlow = new ArrayList<LinkedDevice>();
        for (LinkedDevice receiver : this.fastList) {
            if (!this.updateDevice(receiver)) {
                this.removeReceiver(receiver.pos);
                return;
            }
            if (receiver.timeOut <= 40) continue;
            moveToSlow.add(receiver);
        }
        if (this.tick % 80 == 0) {
            ArrayList<LinkedDevice> moveToFast = new ArrayList<LinkedDevice>();
            for (LinkedDevice receiver : this.slowList) {
                if (!this.updateDevice(receiver)) {
                    this.removeReceiver(receiver.pos);
                    return;
                }
                if (receiver.timeOut != 0) continue;
                moveToFast.add(receiver);
            }
            if (!moveToFast.isEmpty()) {
                this.fastList.addAll(moveToFast);
                this.slowList.removeAll(moveToFast);
            }
        }
        if (!moveToSlow.isEmpty()) {
            this.slowList.addAll(moveToSlow);
            this.fastList.removeAll(moveToSlow);
        }
        if (!this.f_58857_.f_46443_ && DEEventHandler.serverTicks % 10 == 0) {
            this.receiverFlowRates.clear();
            for (int i = 0; i < this.linkedReceivers.size(); ++i) {
                this.receiverFlowRates.add(this.flowConversion(this.receiverTransfer(i)));
            }
        }
    }

    @Override
    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_6144_()) {
            this.inputMode.invert();
            return true;
        }
        return super.onBlockActivated(state, player, handIn, hit);
    }

    protected boolean updateDevice(LinkedDevice receiver) {
        long transferred;
        if (!receiver.isLinkValid(this.f_58857_)) {
            return receiver.invalidTime++ < 100;
        }
        receiver.invalidTime = 0;
        BlockEntity tile = receiver.getCachedTile();
        if (tile == null) {
            receiver.timeOut = receiver.timeOut < 40 ? 40 : ++receiver.timeOut;
            return true;
        }
        if (this.inputMode.get()) {
            transferred = EnergyUtils.extractEnergy((BlockEntity)tile, (long)this.opStorage.receiveEnergy(this.getMaxWirelessTransfer(), true), (Direction)receiver.side, (boolean)false);
            this.opStorage.receiveOP(transferred, false);
        } else {
            transferred = EnergyUtils.insertEnergy((BlockEntity)tile, (long)this.opStorage.extractEnergy(this.getMaxWirelessTransfer(), true), (Direction)receiver.side, (boolean)false);
            this.opStorage.extractOP(transferred, false);
        }
        receiver.timeOut = transferred > 0L ? 0 : ++receiver.timeOut;
        this.receiverTransferRates.get((int)receiver.index)[this.tick % 20] = (int)Math.min(transferred, Integer.MAX_VALUE);
        return true;
    }

    public void rebuildReceiverTransferList() {
        this.receiverTransferRates.clear();
        this.receiverFlowRates.clear();
        for (int i = 0; i < this.linkedReceivers.size(); ++i) {
            this.receiverTransferRates.add(new int[20]);
            this.receiverFlowRates.add((byte)0);
        }
    }

    public int getMaxWirelessTransfer() {
        return this.getTier() == 0 ? 32000 : (this.getTier() == 1 ? 128000 : 512000);
    }

    public int receiverTransfer(int index) {
        long sum = 0L;
        for (int transfer : this.receiverTransferRates.get(index)) {
            sum += (long)transfer;
        }
        return (int)(sum / 20L);
    }

    public byte flowConversion(int transferRate) {
        double d = (double)transferRate / ((double)this.getMaxWirelessTransfer() * 0.01 + (double)transferRate);
        return (byte)(d * 255.0);
    }

    @Override
    public boolean binderUsed(Player player, BlockPos linkTarget, Direction sideClicked) {
        BlockEntity tile = this.f_58857_.m_7702_(linkTarget);
        if (tile == null || tile instanceof ICrystalLink) {
            return super.binderUsed(player, linkTarget, sideClicked);
        }
        if (this.f_58857_.f_46443_) {
            return true;
        }
        Vec3B offset = this.getOffset(linkTarget);
        if (this.linkedReceivers.contains(offset)) {
            this.removeReceiver(linkTarget);
            ChatHelper.sendIndexed((Player)player, (Component)new TranslatableComponent("gui.draconicevolution.energy_net.link_broken").m_130940_(ChatFormatting.GREEN), (int)99);
            return true;
        }
        if (this.inputMode.get()) {
            if (!EnergyUtils.canExtractEnergy((BlockEntity)tile, (Direction)sideClicked)) {
                if (EnergyUtils.getStorage((BlockEntity)tile, (Direction)sideClicked) != null) {
                    ChatHelper.sendIndexed((Player)player, (Component)new TranslatableComponent("gui.draconicevolution.energy_net.side_can_not_extract").m_130940_(ChatFormatting.RED), (int)99);
                    return false;
                }
                return super.binderUsed(player, linkTarget, sideClicked);
            }
        } else if (!EnergyUtils.canReceiveEnergy((BlockEntity)tile, (Direction)sideClicked)) {
            if (EnergyUtils.getStorage((BlockEntity)tile, (Direction)sideClicked) != null) {
                ChatHelper.sendIndexed((Player)player, (Component)new TranslatableComponent("gui.draconicevolution.energy_net.side_can_not_receive").m_130940_(ChatFormatting.RED), (int)99);
                return false;
            }
            return super.binderUsed(player, linkTarget, sideClicked);
        }
        if (this.linkedReceivers.size() >= this.getMaxReceivers()) {
            ChatHelper.sendIndexed((Player)player, (Component)new TranslatableComponent("gui.draconicevolution.energy_net.max_receivers").m_130940_(ChatFormatting.RED), (int)99);
            return false;
        }
        this.addReceiver(linkTarget, sideClicked);
        ChatHelper.sendIndexed((Player)player, (Component)new TranslatableComponent("gui.draconicevolution.energy_net.devices_linked").m_130940_(ChatFormatting.GREEN), (int)99);
        return true;
    }

    public List<BlockPos> getReceivers() {
        if (this.receiverCache == null || this.receiverCache.size() != this.linkedReceivers.size()) {
            this.reCachePositions();
        }
        return this.receiverCache;
    }

    public Map<BlockPos, Direction> getReceiversFaces() {
        if (this.receiverCache == null || this.receiverCache.size() != this.linkedReceivers.size() || this.receiverFaceCache == null || this.receiverFaceCache.size() != this.linkedReceivers.size()) {
            this.reCachePositions();
        }
        return this.receiverFaceCache;
    }

    public int getMaxReceivers() {
        return this.getTier() == 0 ? 16 : (this.getTier() == 1 ? 32 : 64);
    }

    private void reCachePositions() {
        this.receiverCache = new LinkedList();
        this.receiverFaceCache = new HashMap<BlockPos, Direction>();
        this.fastList.clear();
        this.slowList.clear();
        for (Vec3B offset : this.linkedReceivers) {
            this.receiverCache.add(this.fromOffset(offset));
            this.receiverFaceCache.put(this.fromOffset(offset), this.receiverSideMap.get(offset));
            this.fastList.add(new LinkedDevice(this.linkedReceivers.indexOf(offset), this.fromOffset(offset), this.receiverSideMap.get(offset)));
        }
        this.updateBlock();
    }

    @Override
    public EnergyCrystal.CrystalType getCrystalType() {
        return EnergyCrystal.CrystalType.WIRELESS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CrystalFXBase createStaticFX() {
        return new CrystalFXRing((ClientLevel)this.f_58857_, this);
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        Vec3D thisVec = Vec3D.getCenter((BlockPos)this.f_58858_);
        Vec3D targVec = Vec3D.getCenter((BlockPos)linkTo);
        double dist = thisVec.distXZ(targVec);
        double offM = 0.4;
        if (dist == 0.0) {
            if (this.f_58858_.m_123342_() > linkTo.m_123342_()) {
                return thisVec.subtract(0.0, 0.4, 0.0);
            }
            return thisVec.subtract(0.0, -0.4, 0.0);
        }
        double xDist = thisVec.x - targVec.x;
        double zDist = thisVec.z - targVec.z;
        double xOff = xDist / dist;
        double zOff = zDist / dist;
        return thisVec.subtract(xOff * offM, 0.0, zOff * offM);
    }

    @Override
    public boolean renderBeamTermination() {
        return true;
    }

    @Override
    public ENetFXHandler createServerFXHandler() {
        return new ENetFXHandlerServerWireless(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ENetFXHandler createClientFXHandler() {
        return new ENetFXHandlerClientWireless(this);
    }

    @Override
    public void addDisplayData(List<Component> displayList) {
        super.addDisplayData(displayList);
        displayList.add((Component)new TranslatableComponent("gui.draconicevolution.energy_net.hud_wireless_links").m_130946_(": " + this.getReceivers().size() + " / " + this.getMaxReceivers()).m_130940_(ChatFormatting.GREEN));
        ChatFormatting colour = !this.inputMode.get() ? ChatFormatting.GOLD : ChatFormatting.DARK_AQUA;
        displayList.add((Component)new TranslatableComponent("gui.draconicevolution.energy_net.io_output_" + !this.inputMode.get(), new Object[]{colour}));
    }

    public void addReceiver(BlockPos pos, Direction side) {
        Vec3B offset = this.getOffset(pos);
        this.linkedReceivers.add(offset);
        this.receiverSideMap.put(offset, side);
        this.reCachePositions();
        this.updateBlock();
    }

    public void removeReceiver(BlockPos pos) {
        Vec3B offset = this.getOffset(pos);
        this.linkedReceivers.remove(offset);
        this.receiverSideMap.remove(offset);
        this.reCachePositions();
        this.updateBlock();
    }

    @Override
    public void writeExtraNBT(CompoundTag compound) {
        super.writeExtraNBT(compound);
        ListTag list = new ListTag();
        for (Vec3B vec : this.linkedReceivers) {
            CompoundTag receiver = new CompoundTag();
            receiver.m_128382_("offset", new byte[]{vec.x, vec.y, vec.z});
            receiver.m_128344_("side", (byte)this.receiverSideMap.get(vec).m_122411_());
            list.add((Object)receiver);
        }
        compound.m_128365_("linked_receivers", (Tag)list);
    }

    @Override
    public void readExtraNBT(CompoundTag compound) {
        super.readExtraNBT(compound);
        ListTag list = compound.m_128437_("linked_receivers", 10);
        this.linkedReceivers.clear();
        this.receiverSideMap.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag receiver = list.m_128728_(i);
            byte[] offset = receiver.m_128463_("offset");
            Vec3B vec = new Vec3B(offset[0], offset[1], offset[2]);
            this.linkedReceivers.add(vec);
            this.receiverSideMap.put(vec, Direction.m_122376_((int)receiver.m_128445_("side")));
        }
        this.receiverCache = null;
    }

    @Override
    public void detectAndSendContainerChanges(List<ContainerListener> listeners) {
        super.detectAndSendContainerChanges(listeners);
        if (this.linkedReceivers.size() != this.receiverTransferRates.size() && !this.f_58857_.f_46443_) {
            this.rebuildReceiverTransferList();
        }
        List<BlockPos> positions = this.getReceivers();
        ListTag list = new ListTag();
        for (BlockPos lPos : positions) {
            int index = positions.indexOf(lPos);
            if (this.containerReceiverFlow.containsKey(index) && this.containerReceiverFlow.get(index).intValue() == this.receiverTransfer(index)) continue;
            this.containerReceiverFlow.put(index, this.receiverTransfer(index));
            CompoundTag data = new CompoundTag();
            data.m_128344_("I", (byte)index);
            data.m_128405_("E", this.receiverTransfer(index));
            list.add((Object)data);
        }
        CompoundTag compound = new CompoundTag();
        if (!list.isEmpty()) {
            compound.m_128365_("L", (Tag)list);
            this.sendUpdateToListeners(listeners, this.sendPacketToClient(output -> output.writeCompoundNBT(compound), 1));
        } else if (this.containerReceiverFlow.size() > this.linkedReceivers.size()) {
            this.containerReceiverFlow.clear();
            this.sendUpdateToListeners(listeners, this.sendPacketToClient(output -> output.writeCompoundNBT(compound), 1));
        }
    }

    @Override
    public void receivePacketFromServer(MCDataInput data, int id) {
        super.receivePacketFromServer(data, id);
        if (id == 1) {
            CompoundTag compound = data.readCompoundNBT();
            ListTag list = compound.m_128437_("L", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tagData = list.m_128728_(i);
                this.containerReceiverFlow.put(Integer.valueOf(tagData.m_128445_("I")), tagData.m_128451_("E"));
            }
        }
    }

    @Override
    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        super.receivePacketFromClient(data, client, id);
        if (id == 11) {
            int intValue = data.readInt();
            if (this.getReceivers().size() > intValue && intValue >= 0) {
                BlockPos target = this.getReceivers().get(intValue);
                this.removeReceiver(target);
            }
        } else if (id == 21) {
            ArrayList<BlockPos> links = new ArrayList<BlockPos>(this.getReceivers());
            for (BlockPos target : links) {
                this.removeReceiver(target);
            }
        }
    }

    private class LinkedDevice {
        public final int index;
        public final BlockPos pos;
        private Direction side;
        public int timeOut = 0;
        private BlockEntity tileCache = null;
        private int invalidTime = 0;

        public LinkedDevice(int index, BlockPos pos, Direction side) {
            this.index = index;
            this.pos = pos;
            this.side = side;
        }

        public boolean isLinkValid(Level world) {
            this.tileCache = world.m_7702_(this.pos);
            return this.tileCache != null && EnergyUtils.getStorage((BlockEntity)this.tileCache, (Direction)this.side) != null || !Utils.isAreaLoaded((Level)world, (BlockPos)this.pos, (ChunkHolder.FullChunkStatus)ChunkHolder.FullChunkStatus.TICKING);
        }

        public BlockEntity getCachedTile() {
            return this.tileCache;
        }
    }
}

