/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.tileentity;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXRing;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileCrystalRelay
extends TileCrystalBase {
    public TileCrystalRelay(BlockPos pos, BlockState state) {
        super(DEContent.tile_crystal_relay, pos, state);
    }

    public TileCrystalRelay(TechLevel techLevel, BlockPos pos, BlockState state) {
        super(DEContent.tile_crystal_relay, techLevel, pos, state);
    }

    @Override
    public EnergyCrystal.CrystalType getCrystalType() {
        return EnergyCrystal.CrystalType.RELAY;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CrystalFXBase createStaticFX() {
        return new CrystalFXRing((ClientLevel)this.f_58857_, this);
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        Vec3D thisVec = Vec3D.getCenter((BlockPos)this.f_58858_);
        Vec3D targVec = Vec3D.getCenter((BlockPos)linkTo);
        BlockEntity target = this.f_58857_.m_7702_(linkTo);
        if (target instanceof TileDislocatorReceptacle) {
            targVec = ((TileDislocatorReceptacle)target).getBeamLinkPos(this.f_58858_);
        }
        double dist = thisVec.distXZ(targVec);
        double offM = 0.4;
        if (dist == 0.0) {
            if (this.f_58858_.m_123342_() > linkTo.m_123342_()) {
                return thisVec.subtract(0.0, 0.4, 0.0);
            }
            return thisVec.subtract(0.0, -0.4, 0.0);
        }
        double xDist = thisVec.x - targVec.x;
        double zDist = thisVec.z - targVec.z;
        double xOff = xDist / dist;
        double zOff = zDist / dist;
        return thisVec.subtract(xOff * offM, 0.0, zOff * offM);
    }

    @Override
    public boolean renderBeamTermination() {
        return true;
    }
}

