/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.tileentity;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXIO;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileCrystalDirectIO
extends TileCrystalBase {
    public final ManagedEnum<Direction> facing;
    public final ManagedBool outputMode;

    public TileCrystalDirectIO(BlockPos pos, BlockState state) {
        super(DEContent.tile_crystal_io, pos, state);
        this.facing = (ManagedEnum)this.dataManager.register((IManagedData)new ManagedEnum("facing", (Enum)Direction.DOWN, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        this.outputMode = (ManagedBool)this.dataManager.register((IManagedData)new ManagedBool("outputMode", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
        this.outputMode.addValueListener(newVal -> this.opStorage.setIOMode(newVal == false));
    }

    public TileCrystalDirectIO(TechLevel techLevel, BlockPos pos, BlockState state) {
        super(DEContent.tile_crystal_io, techLevel, pos, state);
        this.facing = (ManagedEnum)this.dataManager.register((IManagedData)new ManagedEnum("facing", (Enum)Direction.DOWN, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        this.outputMode = (ManagedBool)this.dataManager.register((IManagedData)new ManagedBool("outputMode", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_142300_((Direction)this.facing.get()));
        if (this.outputMode.get() && tile != null) {
            this.opStorage.extractOP(EnergyUtils.insertEnergy((BlockEntity)tile, (long)this.opStorage.extractOP(this.opStorage.maxExtract(), true), (Direction)((Direction)this.facing.get()).m_122424_(), (boolean)false), false);
        }
    }

    @Override
    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_6144_()) {
            this.outputMode.invert();
            this.updateRotation((Direction)this.facing.get());
            return true;
        }
        return super.onBlockActivated(state, player, handIn, hit);
    }

    @Override
    public EnergyCrystal.CrystalType getCrystalType() {
        return EnergyCrystal.CrystalType.CRYSTAL_IO;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CrystalFXBase createStaticFX() {
        return new CrystalFXIO((ClientLevel)this.f_58857_, this);
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        return Vec3D.getCenter((BlockPos)this.f_58858_);
    }

    @Override
    public boolean renderBeamTermination() {
        return false;
    }

    @Override
    public void addDisplayData(List<Component> displayList) {
        super.addDisplayData(displayList);
        ChatFormatting colour = this.outputMode.get() ? ChatFormatting.GOLD : ChatFormatting.DARK_AQUA;
        displayList.add((Component)new TranslatableComponent("gui.draconicevolution.energy_net.io_output_" + this.outputMode.get(), new Object[]{colour}));
    }

    @Override
    public void onTilePlaced(BlockPlaceContext context, BlockState state) {
        super.onTilePlaced(context, state);
        this.updateRotation(context.m_43719_().m_122424_());
    }

    public void updateRotation(Direction newDirection) {
        this.facing.set((Enum)newDirection);
        this.capManager.remove(CapabilityOP.OP, new Direction[0]);
        this.capManager.setSide(CapabilityOP.OP, (Object)this.opStorage, newDirection);
    }

    @Override
    public void readExtraNBT(CompoundTag compound) {
        super.readExtraNBT(compound);
        this.updateRotation((Direction)this.facing.get());
    }
}

