/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.hud.IHudBlock;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalDirectIO;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalRelay;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EnergyCrystal
extends BlockBCore
implements IHudBlock,
EntityBlock {
    private final TechLevel techLevel;
    private final CrystalType crystalType;
    private static VoxelShape CRYSTAL_SHAPE = Shapes.m_83064_((AABB)new AABB(0.375, 0.125, 0.375, 0.625, 0.875, 0.625));
    private static VoxelShape[] IO_CRYSTAL_SHAPES = new VoxelShape[6];

    public EnergyCrystal(BlockBehaviour.Properties properties, TechLevel techLevel, CrystalType crystalType) {
        super(properties);
        this.techLevel = techLevel;
        this.crystalType = crystalType;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.crystalType.createTile(this.techLevel, pos, state);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        if (entityType == this.crystalType.type.get()) {
            return (e, e2, e3, tile) -> ((TileBCore)tile).tick();
        }
        return null;
    }

    protected boolean hasBlockEntity() {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.crystalType == CrystalType.CRYSTAL_IO) {
            BlockEntity tile = world.m_7702_(pos);
            Direction facing = tile instanceof TileCrystalDirectIO ? (Direction)((TileCrystalDirectIO)tile).facing.get() : Direction.DOWN;
            return IO_CRYSTAL_SHAPES[facing.m_122411_()];
        }
        return CRYSTAL_SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void generateHudText(Level world, BlockPos pos, Player player, List<Component> displayList) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof TileCrystalBase)) {
            return;
        }
        displayList.add((Component)new TranslatableComponent(this.m_5456_().m_5524_()).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}));
        TileCrystalBase tile = (TileCrystalBase)te;
        tile.addDisplayData(displayList);
    }

    static {
        for (Direction dir : Direction.values()) {
            Cuboid6 c = new Cuboid6(0.35, 0.0, 0.35, 0.65, 0.425, 0.65);
            c.apply(Rotation.sideRotations[dir.m_122411_()].at(Vector3.CENTER));
            EnergyCrystal.IO_CRYSTAL_SHAPES[dir.m_122411_()] = Shapes.m_83064_((AABB)c.aabb());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CrystalType implements StringRepresentable
    {
        RELAY(0, () -> DEContent.tile_crystal_relay){

            @Override
            public BlockEntity createTile(TechLevel techLevel, BlockPos pos, BlockState state) {
                return new TileCrystalRelay(techLevel, pos, state);
            }
        }
        ,
        CRYSTAL_IO(1, () -> DEContent.tile_crystal_io){

            @Override
            public BlockEntity createTile(TechLevel techLevel, BlockPos pos, BlockState state) {
                return new TileCrystalDirectIO(techLevel, pos, state);
            }
        }
        ,
        WIRELESS(2, () -> DEContent.tile_crystal_wireless){

            @Override
            public BlockEntity createTile(TechLevel techLevel, BlockPos pos, BlockState state) {
                return new TileCrystalWirelessIO(techLevel, pos, state);
            }
        };

        private final int index;
        private Supplier<BlockEntityType<?>> type;

        private CrystalType(int index, Supplier<BlockEntityType<?>> type) {
            this.index = index;
            this.type = type;
        }

        public int getIndex() {
            return this.index;
        }

        private static CrystalType fromIndex(int i) {
            return i == 0 ? RELAY : (i == 1 ? CRYSTAL_IO : WIRELESS);
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public abstract BlockEntity createTile(TechLevel var1, BlockPos var2, BlockState var3);
    }
}

