/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortal;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Portal
extends EntityBlockBCore {
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.m_61587_((String)"axis", Direction.Axis.class);
    public static final BooleanProperty DRAW_UP = BooleanProperty.m_61465_((String)"drawup");
    public static final BooleanProperty DRAW_DOWN = BooleanProperty.m_61465_((String)"drawdown");
    public static final BooleanProperty DRAW_EAST = BooleanProperty.m_61465_((String)"draweast");
    public static final BooleanProperty DRAW_WEST = BooleanProperty.m_61465_((String)"drawwest");
    public static final BooleanProperty VISIBLE = BooleanProperty.m_61465_((String)"visible");

    public Portal(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)DRAW_UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DRAW_EAST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DRAW_WEST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)VISIBLE, (Comparable)Boolean.valueOf(true)));
        this.setBlockEntity(() -> DEContent.tile_portal, false);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        if (level.m_5776_() && entityType == DEContent.tile_portal) {
            return (e, e2, e3, tile) -> ((TileBCore)tile).tick();
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, DRAW_UP, DRAW_DOWN, DRAW_EAST, DRAW_WEST, VISIBLE});
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return Shapes.m_83040_();
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TilePortal)) {
            return false;
        }
        TileDislocatorReceptacle controller = ((TilePortal)tile).getController();
        if (controller != null && controller.ignitionStage.get() == 2) {
            return true;
        }
        if (!((TilePortal)tile).isPortalActive()) {
            return false;
        }
        for (Direction dir : FacingUtils.getFacingsAroundAxis((Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)))) {
            if (Portal.isFrame(world, pos.m_142300_(dir)) || Portal.isPortal(world, pos.m_142300_(dir))) continue;
            return false;
        }
        return true;
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_7471_(pos, false);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (world.f_46443_) {
            return;
        }
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof TileDislocatorReceptacle) {
                ((TileDislocatorReceptacle)tile).deactivate();
            }
            world.m_186460_(pos, (Block)this, 1);
        }
        world.m_46597_(pos, Portal.getPlacementState(state, world, pos));
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TilePortal && ((TilePortal)tile).getController() != null) {
            ((TilePortal)tile).getController().handleEntityTeleport(entity);
        }
    }

    public static BlockState getPlacementState(BlockState state, Level world, BlockPos pos) {
        switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Z: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)DRAW_UP, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_7494_())))).m_61124_((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_7495_())))).m_61124_((Property)DRAW_EAST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_142126_())))).m_61124_((Property)DRAW_WEST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_142125_())));
            }
            case Y: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)DRAW_UP, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_142127_())))).m_61124_((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_142128_())))).m_61124_((Property)DRAW_EAST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_142126_())))).m_61124_((Property)DRAW_WEST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_142125_())));
            }
            case X: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)DRAW_UP, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_7494_())))).m_61124_((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_7495_())))).m_61124_((Property)DRAW_EAST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_142128_())))).m_61124_((Property)DRAW_WEST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.m_142127_())));
            }
        }
        return state;
    }

    private static boolean isFrame(LevelReader world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == DEContent.infused_obsidian || state.m_60734_() == DEContent.dislocator_receptacle;
    }

    private static boolean isPortal(LevelReader world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == DEContent.portal;
    }
}

