/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.items.ModuleItem;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostContainer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModuleGrid {
    protected int xPos = 0;
    protected int yPos = 0;
    public ModuleHostContainer container;
    protected Inventory player;
    protected int cellSize = 16;
    protected Runnable onGridChange;

    public ModuleGrid(ModuleHostContainer container, Inventory player) {
        this.container = container;
        this.player = player;
    }

    public void setOnGridChange(Runnable onGridChange) {
        this.onGridChange = onGridChange;
    }

    protected void onGridChange() {
        if (this.onGridChange != null) {
            this.onGridChange.run();
        }
        this.container.onGridChange();
    }

    public void setPosition(int guiXPos, int guiYPos) {
        this.xPos = guiXPos;
        this.yPos = guiYPos;
    }

    public ModuleHost getModuleHost() {
        return this.container.getModuleHost();
    }

    public int getWidth() {
        return this.getModuleHost().getGridWidth();
    }

    public int getHeight() {
        return this.getModuleHost().getGridHeight();
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(int cellSize) {
        this.cellSize = cellSize;
    }

    public InstallResult cellClicked(GridPos pos, double x, double y, int button, ClickType clickType) {
        ItemStack stack = this.player.f_35978_.f_36096_.m_142621_();
        Module<?> module = ModuleItem.getModule(stack);
        boolean holdingStack = !stack.m_41619_();
        ModuleContext context = this.container.getModuleContext();
        ModuleEntity<?> posEntity = pos.getEntity();
        if (posEntity != null && posEntity.moduleClicked(this.player.f_35978_, x, y, button, clickType)) {
            return null;
        }
        if (holdingStack && module == null || !pos.isValidCell()) {
            return null;
        }
        ModuleHost host = this.getModuleHost();
        if (clickType == ClickType.PICKUP) {
            if (holdingStack) {
                ModuleEntity<?> entity = module.createEntity();
                entity.setPos(pos.gridX, pos.gridY);
                InstallResult result = this.checkInstall(entity);
                if (result.resultType == InstallResult.InstallResultType.YES) {
                    entity.readFromItemStack(stack, context);
                    host.addModule(entity, context);
                    stack.m_41774_(1);
                    this.onGridChange();
                    return null;
                }
                return result;
            }
            if (pos.hasEntity()) {
                ModuleEntity<?> entity = pos.getEntity();
                ItemStack extracted = new ItemStack((ItemLike)entity.getModule().getItem());
                entity.writeToItemStack(extracted, context);
                ArrayList<Component> error = new ArrayList<Component>();
                if (!host.checkRemoveModule(entity, error)) {
                    return new InstallResult(InstallResult.InstallResultType.NO, null, null, error);
                }
                host.removeModule(entity, context);
                this.player.f_35978_.f_36096_.m_142503_(extracted);
                this.onGridChange();
            }
        } else if (clickType == ClickType.QUICK_MOVE) {
            if (pos.hasEntity()) {
                ModuleEntity<?> entity = pos.getEntity();
                ItemStack extracted = new ItemStack((ItemLike)entity.getModule().getItem());
                entity.writeToItemStack(extracted, context);
                ArrayList<Component> error = new ArrayList<Component>();
                if (!host.checkRemoveModule(entity, error)) {
                    return new InstallResult(InstallResult.InstallResultType.NO, null, null, error);
                }
                if (this.player.m_36054_(extracted)) {
                    host.removeModule(entity, context);
                    this.onGridChange();
                }
            }
        } else if (clickType == ClickType.PICKUP_ALL && module != null) {
            for (ModuleEntity entity : ImmutableList.copyOf(host.getModuleEntities())) {
                if (entity.module == module) {
                    ItemStack modStack = new ItemStack((ItemLike)module.getItem());
                    entity.writeToItemStack(modStack, context);
                    ArrayList<Component> error = new ArrayList<Component>();
                    if (!host.checkRemoveModule(entity, error)) {
                        return new InstallResult(InstallResult.InstallResultType.NO, null, null, error);
                    }
                    if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)modStack) && stack.m_41613_() < stack.m_41741_()) {
                        stack.m_41769_(1);
                        host.removeModule(entity, context);
                    }
                }
                this.onGridChange();
            }
        } else if (clickType == ClickType.CLONE && this.player.f_35978_.m_150110_().f_35937_ && this.player.f_35978_.f_36095_.m_142621_().m_41619_() && pos.hasEntity()) {
            ModuleEntity<?> entity = pos.getEntity();
            ItemStack modStack = new ItemStack((ItemLike)entity.module.getItem());
            entity.writeToItemStack(modStack, context);
            this.player.f_35978_.f_36096_.m_142503_(modStack);
        }
        return null;
    }

    public boolean attemptInstall(ModuleEntity<?> entity) {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                entity.setPos(x, y);
                if (this.checkInstall(entity).resultType != InstallResult.InstallResultType.YES) continue;
                this.getModuleHost().addModule(entity, this.container.getModuleContext());
                this.onGridChange();
                return true;
            }
        }
        return false;
    }

    public InstallResult checkInstall(ModuleEntity<?> entity) {
        ModuleHost host = this.getModuleHost();
        if (host.getHostTechLevel().index < entity.module.getModuleTechLevel().index) {
            return new InstallResult(InstallResult.InstallResultType.NO, entity.module, null, (Component)new TranslatableComponent("modular_item.draconicevolution.cant_install.level_high"));
        }
        if (!host.isModuleSupported(entity)) {
            return new InstallResult(InstallResult.InstallResultType.NO, entity.module, null, (Component)new TranslatableComponent("modular_item.draconicevolution.cant_install.not_supported"));
        }
        if (host.getModuleEntities().stream().anyMatch(entity::intersects)) {
            return new InstallResult(InstallResult.InstallResultType.NO, entity.module, null, (Component)new TranslatableComponent("modular_item.draconicevolution.cant_install.wont_fit"));
        }
        if (entity.getMaxGridX() > host.getGridWidth() || entity.getMaxGridY() > this.getModuleHost().getGridHeight()) {
            return new InstallResult(InstallResult.InstallResultType.NO, entity.module, null, (Component)new TranslatableComponent("modular_item.draconicevolution.cant_install.wont_fit"));
        }
        InstallResult result = ModuleHost.checkAddModule(host, entity.module);
        if (result.resultType == InstallResult.InstallResultType.YES || result.resultType == InstallResult.InstallResultType.OVERRIDE) {
            return new InstallResult(InstallResult.InstallResultType.YES, entity.module, null, (List<Component>)null);
        }
        return result;
    }

    public GridPos getCell(int gridX, int gridY) {
        if (gridX < 0 || gridX >= this.getModuleHost().getGridWidth() || gridY < 0 || gridY >= this.getModuleHost().getGridHeight()) {
            return new GridPos(this);
        }
        return new GridPos(gridX, gridY, this);
    }

    public static class GridPos {
        private final int gridX;
        private final int gridY;
        private final ModuleGrid grid;
        private final ModuleEntity<?> entity;

        GridPos(ModuleGrid grid) {
            this.grid = grid;
            this.gridY = -1;
            this.gridX = -1;
            this.entity = null;
        }

        public GridPos(int gridX, int gridY, ModuleGrid grid) {
            this.gridX = gridX;
            this.gridY = gridY;
            this.grid = grid;
            this.entity = grid.getModuleHost().getModuleEntities().stream().filter(module -> module.contains(gridX, gridY)).findFirst().orElse(null);
        }

        public boolean hasEntity() {
            return this.entity != null;
        }

        public ModuleEntity<?> getEntity() {
            return this.entity;
        }

        public int getGridX() {
            return this.gridX;
        }

        public int getGridY() {
            return this.gridY;
        }

        public boolean isActualEntityPos() {
            return this.hasEntity() && this.entity.checkPos(this.gridX, this.gridY);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridPos gridPos = (GridPos)o;
            return this.gridX == gridPos.gridX && this.gridY == gridPos.gridY;
        }

        public int hashCode() {
            return Objects.hash(this.gridX, this.gridY);
        }

        public boolean isValidCell() {
            return this.gridX != -1 && this.gridY != -1;
        }
    }
}

