/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.render.RenderTypes;
import com.brandon3055.draconicevolution.init.ClientInit;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ModuleEntity<T extends ModuleData<T>> {
    protected final Module<T> module;
    protected ModuleHost host;
    protected Map<String, ConfigProperty> propertyMap = new HashMap<String, ConfigProperty>();
    protected boolean savePropertiesToItem = false;
    protected int gridX;
    protected int gridY;

    public ModuleEntity(Module<T> module) {
        this.module = module;
    }

    public void setHost(ModuleHost host) {
        this.host = host;
    }

    public void tick(ModuleContext context) {
    }

    public void onInstalled(ModuleContext context) {
    }

    public void onRemoved(ModuleContext context) {
    }

    public ConfigProperty addProperty(ConfigProperty property) {
        this.propertyMap.put(property.getName(), property);
        property.generateUnique();
        return property;
    }

    public Collection<ConfigProperty> getEntityProperties() {
        return this.propertyMap.values();
    }

    public void getAttributeModifiers(EquipmentSlot slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map) {
    }

    public void clearCaches() {
    }

    public void writeToNBT(CompoundTag compound) {
        compound.m_128344_("x", (byte)this.gridX);
        compound.m_128344_("y", (byte)this.gridY);
        if (!this.propertyMap.isEmpty()) {
            CompoundTag properties = new CompoundTag();
            this.propertyMap.forEach((name, property) -> properties.m_128365_(name, (Tag)property.serializeNBT()));
            compound.m_128365_("properties", (Tag)properties);
        }
        this.writeExtraData(compound);
    }

    public void readFromNBT(CompoundTag compound) {
        this.gridX = compound.m_128445_("x");
        this.gridY = compound.m_128445_("y");
        CompoundTag properties = compound.m_128469_("properties");
        this.propertyMap.forEach((name, property) -> property.deserializeNBT(properties.m_128469_(name)));
        this.readExtraData(compound);
    }

    public void writeToItemStack(ItemStack stack, ModuleContext context) {
        if (this.savePropertiesToItem && !this.propertyMap.isEmpty()) {
            CompoundTag properties = stack.m_41698_("properties");
            this.propertyMap.forEach((name, property) -> properties.m_128365_(name, (Tag)property.serializeNBT()));
        }
        if (stack.m_41782_()) {
            this.writeExtraData(stack.m_41783_());
        } else {
            CompoundTag tag = new CompoundTag();
            this.writeExtraData(tag);
            if (!tag.m_128456_()) {
                stack.m_41751_(tag);
            }
        }
    }

    public void readFromItemStack(ItemStack stack, ModuleContext context) {
        CompoundTag properties;
        if (this.savePropertiesToItem && (properties = stack.m_41737_("properties")) != null) {
            this.propertyMap.forEach((name, property) -> property.deserializeNBT(properties.m_128469_(name)));
        }
        if (stack.m_41782_()) {
            this.readExtraData(stack.m_41783_());
        }
    }

    protected CompoundTag writeExtraData(CompoundTag nbt) {
        return nbt;
    }

    protected void readExtraData(CompoundTag nbt) {
    }

    public Module<T> getModule() {
        return this.module;
    }

    public void setPos(int gridX, int gridY) {
        this.setGridX(gridX);
        this.setGridY(gridY);
    }

    public void setGridX(int gridX) {
        this.gridX = gridX;
    }

    public void setGridY(int gridY) {
        this.gridY = gridY;
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public int getMaxGridX() {
        return this.gridX + this.module.getProperties().getWidth();
    }

    public int getMaxGridY() {
        return this.gridY + this.module.getProperties().getHeight();
    }

    public int getWidth() {
        return this.module.getProperties().getWidth();
    }

    public int getHeight() {
        return this.module.getProperties().getHeight();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, MultiBufferSource getter, PoseStack poseStack, int x, int y, int width, int height, double mouseX, double mouseY, boolean stackRender, float partialTicks) {
        if (stackRender) {
            poseStack.m_85837_(0.0, 0.0, 210.0);
        }
        int colour = this.getModuleColour(this.module);
        GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)x, (double)y, (double)width, (double)height, (int)colour);
        GuiHelper.drawBorderedRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)x, (double)y, (double)width, (double)height, (double)1.0, (int)colour, (int)GuiHelper.mixColours((int)colour, (int)0x20202000, (boolean)true));
        if (this.module.getProperties().getTechLevel() == TechLevel.CHAOTIC) {
            TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(RenderType.m_110490_()), poseStack);
            builder.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(0.0f, (float)height / (float)width / 64.0f).m_5752_();
            builder.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_((float)width / (float)height / 64.0f, (float)height / (float)width / 64.0f).m_5752_();
            builder.m_5483_((double)(x + width), (double)y, 0.0).m_7421_((float)width / (float)height / 64.0f, 0.0f).m_5752_();
            builder.m_5483_((double)x, (double)y, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
            RenderUtils.endBatch((MultiBufferSource)getter);
        }
        TextureAtlasSprite sprite = ClientInit.moduleSpriteUploader.getSprite(this.module);
        float ar = (float)sprite.m_118405_() / (float)sprite.m_118408_();
        float iar = (float)sprite.m_118408_() / (float)sprite.m_118405_();
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(RenderTypes.MODULE_TYPE), poseStack);
        if (iar * (float)width <= (float)height) {
            double h = (float)width * iar;
            GuiHelper.drawSprite((VertexConsumer)builder, (double)x, (double)((double)y + (double)height / 2.0 - h / 2.0), (double)width, (double)h, (TextureAtlasSprite)sprite);
        } else {
            double w = (float)height * ar;
            GuiHelper.drawSprite((VertexConsumer)builder, (double)((double)x + (double)width / 2.0 - w / 2.0), (double)y, (double)w, (double)height, (TextureAtlasSprite)sprite);
        }
        if (stackRender) {
            poseStack.m_85837_(0.0, 0.0, -210.0);
        } else if (GuiHelper.isInRect((int)x, (int)y, (int)width, (int)height, (double)mouseX, (double)mouseY)) {
            GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)x, (double)y, (double)width, (double)height, (int)0x50FFFFFF);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderModuleOverlay(GuiElement<?> parent, ModuleContext context, MultiBufferSource getter, PoseStack poseStack, int x, int y, int width, int height, double mouseX, double mouseY, float partialTicks, int hoverTicks) {
        if (hoverTicks > 10) {
            Minecraft mc = Minecraft.m_91087_();
            Item item = this.getModule().getItem();
            ItemStack stack = new ItemStack((ItemLike)item);
            this.writeToItemStack(stack, context);
            List list = stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)(mc.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
            parent.getScreen().m_169388_(poseStack, list, Optional.empty(), (int)mouseX, (int)mouseY);
            return true;
        }
        return false;
    }

    public void addToolTip(List<Component> list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addHostHoverText(ItemStack stack, @javax.annotation.Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
    }

    public boolean clientModuleClicked(GuiElement<?> parent, Player player, int x, int y, int width, int height, double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean moduleClicked(Player player, double x, double y, int button, ClickType clickType) {
        return false;
    }

    public boolean checkPos(int gridX, int gridY) {
        return this.gridX == gridX && this.gridY == gridY;
    }

    public boolean isPosValid(int gridWidth, int gridHeight) {
        return this.gridX >= 0 && this.gridY >= 0 && this.getMaxGridX() < gridWidth && this.getMaxGridY() < gridHeight;
    }

    public boolean contains(int gridX, int gridY) {
        return gridX >= this.gridX && gridX < this.gridX + this.module.getProperties().getWidth() && gridY >= this.gridY && gridY < this.gridY + this.module.getProperties().getHeight();
    }

    public boolean intersects(ModuleEntity other) {
        int tw = this.getWidth();
        int th = this.getHeight();
        int rw = other.getWidth();
        int rh = other.getHeight();
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = this.gridX;
        int ty = this.gridY;
        int rx = other.gridX;
        int ry = other.gridY;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    protected int getModuleColour(Module<?> module) {
        return switch (module.getProperties().getTechLevel()) {
            default -> throw new IncompatibleClassChangeError();
            case TechLevel.DRACONIUM -> -14793322;
            case TechLevel.WYVERN -> -12839599;
            case TechLevel.DRACONIC -> -3462656;
            case TechLevel.CHAOTIC -> -15658735;
        };
    }

    public String toString() {
        return "ModuleEntity{module=" + this.module.getRegistryName() + ", gridX=" + this.gridX + ", gridY=" + this.gridY + "}";
    }

    public void sendMessageToServer(Consumer<MCDataOutput> dataConsumer) {
        DraconicNetwork.sendModuleMessage(this.getGridX(), this.getGridY(), dataConsumer);
    }

    public void handleClientMessage(MCDataInput input) {
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawChargeProgress(MultiBufferSource getter, PoseStack poseStack, int x, int y, int width, int height, double progress, @Nullable String text1, @Nullable String text2) {
        double diameter = (double)Math.min(width, height) * 0.425;
        GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)x, (double)y, (double)width, (double)height, (int)0x60FF0000);
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(GuiHelperOld.FAN_TYPE), poseStack);
        builder.m_5483_((double)x + (double)width / 2.0, (double)y + (double)height / 2.0, 0.0).m_6122_(0, 255, 255, 128).m_5752_();
        for (double d = 0.0; d <= 1.0; d += 0.03333333333333333) {
            double angle = d * progress + 0.5 - progress;
            double vertX = (double)x + (double)width / 2.0 + Math.sin(angle * (Math.PI * 2)) * diameter;
            double vertY = (double)y + (double)height / 2.0 + Math.cos(angle * (Math.PI * 2)) * diameter;
            builder.m_5483_(vertX, vertY, 0.0).m_6122_(255, 255, 255, 128).m_5752_();
        }
        RenderUtils.endBatch((MultiBufferSource)getter);
        if (text1 != null) {
            ModuleEntity.drawBackgroundString(getter, poseStack, Minecraft.m_91087_().f_91062_, text1, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f - (float)(text2 == null ? 4 : 8), 0, -2147418368, 1, false, true);
        }
        if (text2 != null) {
            ModuleEntity.drawBackgroundString(getter, poseStack, Minecraft.m_91087_().f_91062_, text2, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f + 1.0f, 0, -2147418368, 1, false, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawBackgroundString(MultiBufferSource getter, PoseStack mStack, Font font, String text, float x, float y, int colour, int background, int padding, boolean shadow, boolean centered) {
        PoseStack matrixstack = new PoseStack();
        int width = font.m_92895_(text);
        x = centered ? x - (float)width / 2.0f : x;
        double d = x - (float)padding;
        double d2 = y - (float)padding;
        double d3 = width + padding * 2;
        Objects.requireNonNull(font);
        GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)mStack, (double)d, (double)d2, (double)d3, (double)(9 - 2 + padding * 2), (int)background);
        font.m_92811_(text, x, y, colour, shadow, matrixstack.m_85850_().m_85861_(), getter, false, 0, 0xF000F0);
    }
}

