/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.items;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.EnergyLinkData;
import com.brandon3055.draconicevolution.api.modules.items.ModuleItem;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyPylon;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStructureBlock;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnergyLinkModuleItem
extends ModuleItem<EnergyLinkData> {
    public EnergyLinkModuleItem(Item.Properties properties, Supplier<Module<EnergyLinkData>> moduleSupplier) {
        super(properties, moduleSupplier);
    }

    public EnergyLinkModuleItem(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        ServerLevel serverLevel;
        block3: {
            block2: {
                if (!(level instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)level;
                if (TimeKeeper.getServerTick() % 20 == 0) break block3;
            }
            return;
        }
        EnergyLinkModuleItem.checkResetLink(stack, serverLevel);
    }

    public static void checkResetLink(ItemStack stack, ServerLevel level) {
        boolean reset;
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        BlockPos pos = new BlockPos(tag.m_128451_("core_x"), tag.m_128451_("core_y"), tag.m_128451_("core_z"));
        UUID uuid = tag.m_128342_("link_id");
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dim")));
        ServerLevel coreLevel = level.m_142572_().m_129880_(dimension);
        boolean bl = reset = coreLevel == null;
        if (!reset) {
            BlockEntity blockEntity = coreLevel.m_7702_(pos);
            if (blockEntity instanceof TileEnergyCore) {
                TileEnergyCore core = (TileEnergyCore)blockEntity;
                if (!uuid.equals(core.linkUUID.get())) {
                    reset = true;
                }
            } else {
                reset = true;
            }
        }
        if (reset) {
            stack.m_41751_(null);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (level.f_46443_ || player == null || !player.m_6144_()) {
            return InteractionResult.SUCCESS;
        }
        Object blockEntity = level.m_7702_(context.m_8083_());
        if (blockEntity instanceof TileStructureBlock) {
            TileStructureBlock structureBlock = (TileStructureBlock)((Object)blockEntity);
            blockEntity = (BlockEntity)structureBlock.getController();
        }
        if (blockEntity instanceof TileEnergyPylon) {
            TileEnergyPylon pylon = (TileEnergyPylon)blockEntity;
            blockEntity = pylon.getCore();
        }
        if (blockEntity instanceof TileEnergyCoreStabilizer) {
            TileEnergyCoreStabilizer stabilizer = (TileEnergyCoreStabilizer)blockEntity;
            blockEntity = stabilizer.getCore();
        }
        if (!(blockEntity instanceof TileEnergyCore)) {
            return InteractionResult.PASS;
        }
        TileEnergyCore core = (TileEnergyCore)blockEntity;
        UUID linkId = core.linkUUID.get();
        if (!core.active.get() || linkId == null) {
            player.m_6352_((Component)new TranslatableComponent("module.draconicevolution.energy_link.core_not_active"), Util.f_137441_);
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("dim", level.m_46472_().m_135782_().toString());
        BlockPos pos = core.m_58899_();
        tag.m_128405_("core_x", pos.m_123341_());
        tag.m_128405_("core_y", pos.m_123342_());
        tag.m_128405_("core_z", pos.m_123343_());
        tag.m_128362_("link_id", linkId);
        return InteractionResult.CONSUME;
    }
}

