/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities.logic;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.inventory.BlockToStackHelper;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.draconicevolution.init.EquipCfg;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeHooks;

public interface IHarvestHandler {
    public boolean start(BlockPos var1, Level var2, ServerPlayer var3);

    public void tick(Level var1, ServerPlayer var2, ItemStack var3, IOPStorage var4, InventoryDynamic var5);

    public boolean isDone();

    public void stop(Level var1, ServerPlayer var2);

    default public void doHarvest(ItemStack stack, Player player, Level level, BlockPos pos, IOPStorage storage, InventoryDynamic stackCollector) {
        if (level.f_46443_ || storage.getOPStored() < (long)EquipCfg.energyHarvest && !player.m_150110_().f_35937_) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        FluidState fluidState = level.m_6425_(pos);
        Block block = state.m_60734_();
        int xp = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)((ServerPlayer)player).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
        if (xp == -1) {
            ServerPlayer mpPlayer = (ServerPlayer)player;
            mpPlayer.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            return;
        }
        if (player.m_150110_().f_35937_) {
            if (block.onDestroyedByPlayer(state, level, pos, player, false, fluidState)) {
                block.m_6786_((LevelAccessor)level, pos, state);
            }
            ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            return;
        }
        stack.m_41686_(level, state, pos, player);
        BlockToStackHelper.breakAndCollectWithPlayer((Level)level, (BlockPos)pos, (InventoryDynamic)stackCollector, (Player)player, (int)xp);
        storage.modifyEnergyStored((long)(-EquipCfg.energyHarvest));
    }
}

