/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ShieldControlData;
import com.brandon3055.draconicevolution.api.modules.data.ShieldData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class ShieldControlEntity
extends ModuleEntity<ShieldControlData> {
    public static final Set<DamageSource> UNBLOCKABLE = Sets.newHashSet((Object[])new DamageSource[]{DamageSource.f_19312_, DamageSource.f_19313_, DamageSource.f_19310_});
    public static final HashMap<DamageSource, Double> ENV_SOURCES = new HashMap();
    private BooleanProperty shieldEnabled;
    private BooleanProperty alwaysVisible;
    private ShieldData shieldCache;
    private long lastHitTime;
    private double passivePowerCache = 0.0;
    private double shieldPoints;
    private double shieldBoost;
    private double maxBoost;
    private int boostTime = 0;
    private int shieldCapacity;
    private int shieldCoolDown;
    private byte envDmgCoolDown = 0;
    private boolean shieldVisible;
    private float shieldAnim;
    private float shieldHitIndicator;
    private int shieldColour;

    public ShieldControlEntity(Module<ShieldControlData> module) {
        super(module);
        this.shieldColour = ShieldControlEntity.getDefaultShieldColour(module.getModuleTechLevel());
        this.shieldEnabled = new BooleanProperty("shield_mod.enabled", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
        this.addProperty(this.shieldEnabled);
        this.alwaysVisible = new BooleanProperty("shield_mod.always_visible", true).setFormatter(ConfigProperty.BooleanFormatter.YES_NO);
        this.addProperty(this.alwaysVisible);
        this.savePropertiesToItem = true;
    }

    @Override
    public void tick(ModuleContext moduleContext) {
        boolean enabled;
        StackModuleContext context;
        IOPStorage storage;
        block23: {
            block22: {
                storage = moduleContext.getOpStorage();
                if (!(moduleContext instanceof StackModuleContext)) break block22;
                context = (StackModuleContext)moduleContext;
                if (EffectiveSide.get().isServer() && storage != null) break block23;
            }
            return;
        }
        ShieldData data = this.getShieldData();
        this.shieldCapacity = data.shieldCapacity();
        double chargeRate = data.shieldRecharge();
        boolean bl = enabled = this.shieldEnabled.getValue() && this.getShieldPoints() > 0.0;
        if (this.shieldPoints > (double)this.shieldCapacity) {
            this.shieldPoints = this.shieldCapacity;
        }
        if (this.shieldHitIndicator > 0.0f) {
            this.shieldHitIndicator = (float)((double)this.shieldHitIndicator - 0.1);
        }
        boolean bl2 = this.shieldVisible = enabled && (this.alwaysVisible.getValue() || System.currentTimeMillis() - this.lastHitTime < 5000L);
        if (this.shieldVisible && this.shieldAnim < 1.0f) {
            this.shieldAnim = Math.min(this.shieldAnim + 0.05f, 1.0f);
        } else if (!this.shieldVisible && this.shieldAnim > 0.0f) {
            this.shieldAnim = Math.max(this.shieldAnim - 0.05f, 0.0f);
        }
        if (this.envDmgCoolDown > 0) {
            this.envDmgCoolDown = (byte)(this.envDmgCoolDown - 1);
        }
        if (!context.isEquipped()) {
            return;
        }
        if (enabled && storage.getOPStored() > 0L) {
            double passiveDraw = this.shieldPoints * this.shieldPoints * EquipCfg.shieldPassiveModifier;
            if (passiveDraw > 0.0) {
                this.passivePowerCache += passiveDraw;
                if (this.passivePowerCache >= 1.0) {
                    storage.modifyEnergyStored((long)(-((int)this.passivePowerCache)));
                    this.passivePowerCache %= 1.0;
                }
            }
        } else if (enabled && this.shieldPoints > 0.0) {
            this.shieldPoints = Math.max(0.0, this.shieldPoints - (double)this.shieldCapacity / 1200.0);
        }
        if (this.shieldBoost > 0.0) {
            --this.boostTime;
            if (this.boostTime == 0) {
                this.shieldBoost = 0.0;
            }
        }
        if (!enabled) {
            chargeRate *= 1.25;
        }
        if (this.shieldCoolDown > 0) {
            this.shieldCoolDown = Math.max(0, this.shieldCoolDown - (enabled ? 100 : 125));
        } else if (this.shieldPoints < (double)this.shieldCapacity && this.shieldCapacity > 0 && chargeRate > 0.0 && storage.getOPStored() > 0L) {
            double energyPerPoint = Math.max(chargeRate * (double)EquipCfg.energyShieldChg, (double)EquipCfg.energyShieldChg);
            long extracted = storage.modifyEnergyStored((long)(-((int)Math.max(1.0, Math.min(chargeRate, (double)this.shieldCapacity - this.shieldPoints) * energyPerPoint))));
            this.shieldPoints += (double)extracted / energyPerPoint;
        }
    }

    public double getShieldPoints() {
        return this.shieldPoints + this.shieldBoost;
    }

    public int getShieldCapacity() {
        return this.shieldCapacity;
    }

    public double getMaxShieldBoost() {
        return this.shieldBoost == 0.0 ? 0.0 : this.maxBoost;
    }

    public double getShieldBoost() {
        return this.shieldBoost;
    }

    public int getShieldCoolDown() {
        return this.shieldCoolDown;
    }

    public int getMaxShieldCoolDown() {
        return ((ShieldControlData)this.module.getData()).coolDownTicks() * 100;
    }

    public void setShieldCoolDown(int shieldCoolDown) {
        this.shieldCoolDown = shieldCoolDown;
    }

    public void tryBlockDamage(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        if (!this.shieldEnabled.getValue() || UNBLOCKABLE.contains(source)) {
            return;
        }
        if (this.blockEnvironmentalDamage(event, source)) {
            return;
        }
        float damage = this.applyDamageModifiers(source, event.getAmount());
        if ((double)damage <= this.getShieldPoints()) {
            LivingEntity entity = event.getEntityLiving();
            event.setCanceled(true);
            this.subtractShieldPoints(damage);
            this.onShieldHit(entity, true);
        }
    }

    private boolean blockEnvironmentalDamage(LivingAttackEvent event, DamageSource source) {
        LivingEntity entity = event.getEntityLiving();
        if (source.m_19384_() && this.getShieldPoints() > 10.0) {
            entity.m_20095_();
        }
        if (ENV_SOURCES.containsKey(source)) {
            ENV_SOURCES.put(DamageSource.f_19308_, 4.0);
            double value = ENV_SOURCES.get(source) / 20.0;
            if (value <= this.getShieldPoints()) {
                this.subtractShieldPoints(value);
                event.setCanceled(true);
                this.lastHitTime = System.currentTimeMillis();
                this.shieldAnim = 1.0f;
                this.shieldHitIndicator = 1.0f;
                this.shieldCoolDown = this.getMaxShieldCoolDown();
                if (this.envDmgCoolDown == 0) {
                    float hitPitch = 0.7f + (float)(Math.min(1.0, this.getShieldPoints() / (((double)this.shieldCapacity + this.getMaxShieldBoost()) * 0.1)) * 0.3);
                    entity.f_19853_.m_5594_(null, entity.m_142538_(), DESounds.shieldStrike, SoundSource.PLAYERS, 0.25f, (0.95f + entity.f_19853_.f_46441_.nextFloat() * 0.1f) * hitPitch);
                    this.envDmgCoolDown = (byte)40;
                }
                return true;
            }
        }
        return false;
    }

    public void tryBlockDamage(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        if (!this.shieldEnabled.getValue() || UNBLOCKABLE.contains(source)) {
            return;
        }
        float damage = this.applyDamageModifiers(source, event.getAmount());
        LivingEntity entity = event.getEntityLiving();
        if ((double)damage <= this.getShieldPoints()) {
            event.setCanceled(true);
            this.subtractShieldPoints(damage);
            this.onShieldHit(entity, true);
        } else if (this.getShieldPoints() > 0.0) {
            damage = (float)((double)damage - this.getShieldPoints());
            event.setAmount(damage);
            this.onShieldHit(entity, false);
            this.shieldPoints = 0.0;
            this.shieldBoost = 0.0;
        }
    }

    private void onShieldHit(LivingEntity entity, boolean damageBlocked) {
        this.lastHitTime = System.currentTimeMillis();
        this.shieldAnim = 1.0f;
        this.shieldHitIndicator = 1.0f;
        if (damageBlocked && (double)this.shieldCapacity + this.getMaxShieldBoost() > 0.0) {
            this.shieldCoolDown = this.getMaxShieldCoolDown();
            float hitPitch = 0.7f + (float)(Math.min(1.0, this.getShieldPoints() / (((double)this.shieldCapacity + this.getMaxShieldBoost()) * 0.1)) * 0.3);
            entity.f_19853_.m_5594_(null, entity.m_142538_(), DESounds.shieldStrike, SoundSource.PLAYERS, 1.0f, (0.95f + entity.f_19853_.f_46441_.nextFloat() * 0.1f) * hitPitch);
        }
    }

    private ShieldData getShieldData() {
        if (this.shieldCache == null) {
            this.shieldCache = this.host.getModuleData(ModuleTypes.SHIELD_BOOST, new ShieldData(0, 0.0));
        }
        return this.shieldCache;
    }

    private float applyDamageModifiers(DamageSource source, float damage) {
        if (source.m_19376_()) {
            damage *= 3.0f;
        }
        if (source.m_19387_()) {
            damage *= 2.0f;
        }
        return damage;
    }

    public void boost(float shieldBoost, int boostTime) {
        this.shieldBoost += (double)shieldBoost;
        this.boostTime = Math.max(this.boostTime, boostTime);
        this.maxBoost = this.shieldBoost;
    }

    public void subtractShieldPoints(double points) {
        if (points > 0.0) {
            if (this.shieldBoost > 0.0) {
                double number = Math.min(this.shieldBoost, points);
                this.shieldBoost -= number;
                points -= number;
            }
            this.shieldPoints = Math.max(0.0, this.shieldPoints - points);
        }
    }

    public int getShieldColour() {
        return this.shieldEnabled.getValue() || this.shieldAnim > 0.0f ? this.shieldColour | (int)((double)(63.0f + 192.0f * this.shieldHitIndicator) * Math.min(1.0, this.getShieldPoints() / ((double)this.shieldCapacity * 0.1))) << 24 : 0xFFFFFF;
    }

    public boolean isShieldEnabled() {
        return this.shieldEnabled.getValue();
    }

    public float getShieldState() {
        return this.shieldAnim;
    }

    private static int getDefaultShieldColour(TechLevel techLevel) {
        switch (techLevel) {
            case DRACONIUM: {
                return 32972;
            }
            case WYVERN: {
                return 9175205;
            }
            case DRACONIC: {
                return 0xFF9000;
            }
            case CHAOTIC: {
                return 12520460;
            }
        }
        return 0;
    }

    @Override
    public void clearCaches() {
        this.shieldCache = null;
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128347_("boost", this.shieldBoost);
        compound.m_128347_("max_boost", this.maxBoost);
        compound.m_128405_("boost_time", this.boostTime);
        compound.m_128344_("env_cdwn", this.envDmgCoolDown);
        compound.m_128379_("visible", this.shieldVisible);
        compound.m_128350_("anim", this.shieldAnim);
        compound.m_128350_("hit", this.shieldHitIndicator);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.shieldBoost = compound.m_128459_("boost");
        this.maxBoost = compound.m_128459_("max_boost");
        this.boostTime = compound.m_128451_("boost_time");
        this.envDmgCoolDown = compound.m_128445_("env_cdwn");
        this.shieldVisible = compound.m_128471_("visible");
        this.shieldAnim = compound.m_128457_("anim");
        this.shieldHitIndicator = compound.m_128457_("hit");
    }

    @Override
    protected void readExtraData(CompoundTag nbt) {
        this.shieldCapacity = nbt.m_128451_("cap");
        this.shieldPoints = nbt.m_128459_("points");
        this.shieldCoolDown = nbt.m_128451_("cooldwn");
    }

    @Override
    protected CompoundTag writeExtraData(CompoundTag nbt) {
        nbt.m_128405_("cap", this.shieldCapacity);
        nbt.m_128347_("points", this.shieldPoints);
        nbt.m_128405_("cooldwn", this.shieldCoolDown);
        return nbt;
    }

    static {
        ENV_SOURCES.put(DamageSource.f_19305_, 1.0);
        ENV_SOURCES.put(DamageSource.f_19307_, 0.5);
        ENV_SOURCES.put(DamageSource.f_19308_, 4.0);
        ENV_SOURCES.put(DamageSource.f_19309_, 1.0);
        ENV_SOURCES.put(DamageSource.f_19310_, 1.0);
        ENV_SOURCES.put(DamageSource.f_19311_, 0.0);
        ENV_SOURCES.put(DamageSource.f_19314_, 1.0);
    }
}

