/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiStackIcon;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.render.RenderTypes;
import com.brandon3055.draconicevolution.init.ClientInit;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.Material;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public abstract class FilteredModuleEntity<T extends ModuleData<T>>
extends ModuleEntity<T> {
    protected BooleanProperty filterEnabled;
    protected IntObjectMap<ItemStack> filterStacks = new IntObjectHashMap();
    protected IntObjectMap<TagKey<Item>> filterTags = new IntObjectHashMap();
    protected final int slotsCount;

    public FilteredModuleEntity(Module<T> module, int slotsCount) {
        super(module);
        this.slotsCount = slotsCount;
        this.savePropertiesToItem = true;
    }

    protected void addEnabledProperty(String moduleName, boolean includeFilter) {
        this.filterEnabled = new BooleanProperty(moduleName + ".enabled", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
        this.addProperty(this.filterEnabled);
        if (includeFilter) {
            Function<Boolean, Component> nameGen = trim -> {
                TranslatableComponent component = new TranslatableComponent("item_prop.draconicevolution." + moduleName + ".enabled");
                boolean first = true;
                for (int i = 0; i < this.slotsCount; ++i) {
                    String append = null;
                    if (this.filterTags.containsKey(i)) {
                        append = ((TagKey)this.filterTags.get(i)).f_203868_().toString();
                    } else if (this.filterStacks.containsKey(i)) {
                        append = ((ItemStack)this.filterStacks.get(i)).m_41786_().getString();
                    }
                    if (append == null) continue;
                    if (trim.booleanValue()) {
                        int trimLen = Math.min(18, 32 - component.getString().length());
                        if (trimLen <= 0) break;
                        append = Utils.trimString((String)append, (int)trimLen, (String)"...");
                    }
                    if (first) {
                        component.m_130946_(": ");
                        first = false;
                    } else {
                        component.m_130946_(", ");
                    }
                    component.m_7220_((Component)new TextComponent(append).m_130940_(ChatFormatting.GRAY));
                }
                return component;
            };
            this.filterEnabled.setDisplayName(() -> (Component)nameGen.apply(true));
            this.filterEnabled.setToolTip(() -> (Component)nameGen.apply(false));
        }
    }

    protected abstract List<Slot> layoutSlots(int var1, int var2, int var3, int var4);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract Material getSlotOverlay();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, MultiBufferSource getter, PoseStack poseStack, int x, int y, int width, int height, double mouseX, double mouseY, boolean renderStack, float partialTicks) {
        if (this.slotsCount == 0) {
            super.renderModule(parent, getter, poseStack, x, y, width, height, mouseX, mouseY, renderStack, partialTicks);
            return;
        }
        float dist = (float)GuiHelper.distToRect((double)x, (double)y, (double)width, (double)height, (double)GuiHelper.getMouseX(), (double)GuiHelper.getMouseY());
        float alpha = dist <= 10.0f ? dist / 10.0f : 1.0f;
        poseStack.m_85836_();
        List<Slot> slots = this.layoutSlots(x, y, width, height);
        if (alpha < 1.0f) {
            Material slotTex = BCGuiSprites.getThemed((String)"slot");
            Material overlayTex = this.getSlotOverlay();
            TransformingVertexConsumer buffer = new TransformingVertexConsumer(getter.m_6299_(BCGuiSprites.GUI_TYPE), poseStack);
            for (Slot slot : slots) {
                GuiHelper.drawSprite((VertexConsumer)buffer, (double)slot.x, (double)slot.y, (double)slot.width, (double)slot.height, (TextureAtlasSprite)slotTex.m_119204_());
                if (overlayTex == null || this.filterStacks.containsKey(slot.index)) continue;
                GuiHelper.drawSprite((VertexConsumer)buffer, (double)slot.x, (double)slot.y, (double)slot.width, (double)slot.height, (TextureAtlasSprite)overlayTex.m_119204_());
            }
            RenderUtils.endBatch((MultiBufferSource)getter);
            poseStack.m_85837_(0.0, 0.0, 100.0);
            for (Slot slot : slots) {
                ITagManager tags;
                ItemStack stack = (ItemStack)this.filterStacks.getOrDefault((Object)slot.index, (Object)ItemStack.f_41583_);
                if (this.filterTags.containsKey(slot.index) && (tags = ForgeRegistries.ITEMS.tags()) != null) {
                    List matchingItems = tags.getTag((TagKey)this.filterTags.get(slot.index)).stream().toList();
                    stack = new ItemStack((ItemLike)matchingItems.get(TimeKeeper.getClientTick() / 10 % matchingItems.size()));
                }
                double itemX = slot.x + slot.width / 16.0;
                double itemY = slot.y + slot.height / 16.0;
                double itemWidth = slot.width - slot.width / 16.0 * 2.0;
                double itemHeight = slot.height - slot.height / 16.0 * 2.0;
                if (!stack.m_41619_()) {
                    GuiHelper.renderGuiStack((ItemStack)stack, (PoseStack)poseStack, (double)itemX, (double)itemY, (double)itemWidth, (double)itemHeight);
                }
                if (!GuiHelper.isInRect((double)slot.x, (double)slot.y, (double)slot.width, (double)slot.height, (double)mouseX, (double)mouseY)) continue;
                poseStack.m_85837_(0.0, 0.0, 100.0);
                GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)itemX, (double)itemY, (double)itemWidth, (double)itemHeight, (int)-2130706433);
                poseStack.m_85837_(0.0, 0.0, -100.0);
            }
            RenderUtils.endBatch((MultiBufferSource)getter);
            poseStack.m_85837_(0.0, 0.0, 100.0);
        } else if (renderStack) {
            poseStack.m_85837_(0.0, 0.0, 200.0);
        }
        if (alpha > 0.0f) {
            int bgColour = this.getModuleColour(this.module) & 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            GuiHelper.drawRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)x, (double)y, (double)width, (double)height, (int)bgColour);
            GuiHelper.drawBorderedRect((MultiBufferSource)getter, (PoseStack)poseStack, (double)x, (double)y, (double)width, (double)height, (double)1.0, (int)bgColour, (int)GuiHelper.mixColours((int)bgColour, (int)0x20202000, (boolean)true));
            TextureAtlasSprite sprite = ClientInit.moduleSpriteUploader.getSprite(this.module);
            float ar = (float)sprite.m_118405_() / (float)sprite.m_118408_();
            float iar = (float)sprite.m_118408_() / (float)sprite.m_118405_();
            TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(RenderTypes.MODULE_TYPE), poseStack);
            if (iar * (float)width <= (float)height) {
                double h = (float)width * iar;
                GuiHelper.drawSprite((VertexConsumer)builder, (double)x, (double)((double)y + (double)height / 2.0 - h / 2.0), (double)width, (double)h, (TextureAtlasSprite)sprite, (float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            } else {
                double w = (float)height * ar;
                GuiHelper.drawSprite((VertexConsumer)builder, (double)((double)x + (double)width / 2.0 - w / 2.0), (double)y, (double)w, (double)height, (TextureAtlasSprite)sprite, (float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            }
        }
        poseStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderModuleOverlay(GuiElement<?> parent, ModuleContext context, MultiBufferSource getter, PoseStack poseStack, int x, int y, int width, int height, double mouseX, double mouseY, float partialTicks, int hoverTicks) {
        if (this.slotsCount == 0) {
            return super.renderModuleOverlay(parent, context, getter, poseStack, x, y, width, height, mouseX, mouseY, partialTicks, hoverTicks);
        }
        if (Screen.m_96638_()) {
            if (hoverTicks <= 10) {
                return false;
            }
            Minecraft mc = Minecraft.m_91087_();
            Item item = this.getModule().getItem();
            ItemStack stack = new ItemStack((ItemLike)item);
            this.writeToItemStack(stack, context);
            List list = stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)(mc.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
            parent.getScreen().m_169388_(poseStack, list, Optional.empty(), (int)mouseX, (int)mouseY);
            return true;
        }
        if (hoverTicks <= 5) {
            return false;
        }
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        list.add(new TranslatableComponent("module.draconicevolution.filtered_module.filter_slot").m_130940_(ChatFormatting.YELLOW));
        int slotX = MathHelper.clip((int)((int)((mouseX - (double)x) / (double)width * 3.0)), (int)0, (int)2);
        int slotY = MathHelper.clip((int)((int)((mouseY - (double)y) / (double)height * 3.0)), (int)0, (int)2);
        int index = slotX + slotY * 3;
        ItemStack filter = (ItemStack)this.filterStacks.getOrDefault((Object)index, (Object)ItemStack.f_41583_);
        TagKey tag = (TagKey)this.filterTags.get(index);
        if (tag != null) {
            list.add(new TranslatableComponent("module.draconicevolution.filtered_module.filter_tag").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_((Component)new TextComponent(tag.f_203868_().toString()).m_130940_(ChatFormatting.GOLD)));
        } else if (!filter.m_41619_()) {
            Component name = filter.m_41786_();
            list.add(new TranslatableComponent("module.draconicevolution.filtered_module.filter_item").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_((Component)(name instanceof MutableComponent ? ((MutableComponent)name).m_130940_(ChatFormatting.GOLD) : name)));
        }
        list.add(new TranslatableComponent("module.draconicevolution.filtered_module.set_item_filter").m_130940_(ChatFormatting.DARK_GRAY));
        list.add(new TranslatableComponent("module.draconicevolution.filtered_module.configure_slot").m_130940_(ChatFormatting.DARK_GRAY));
        list.add(new TranslatableComponent("module.draconicevolution.filtered_module.clear_slot").m_130940_(ChatFormatting.DARK_GRAY));
        parent.getScreen().m_169388_(poseStack, list, Optional.empty(), (int)mouseX, (int)mouseY);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean clientModuleClicked(GuiElement<?> parent, Player player, int x, int y, int width, int height, double mouseX, double mouseY, int button) {
        if (this.slotsCount == 0) {
            return false;
        }
        List<Slot> slots = this.layoutSlots(x, y, width, height);
        Slot slot = slots.stream().filter(e -> e.isInSlot(mouseX, mouseY)).findAny().orElse(null);
        if (slot == null) {
            return false;
        }
        int index = slot.index;
        ItemStack carrying = player.f_36096_.m_142621_();
        if (button == 1 && Screen.m_96638_()) {
            this.filterStacks.remove(index);
            this.filterTags.remove(index);
            this.sendMessageToServer(e -> e.writeCompoundNBT(this.writeExtraData(new CompoundTag())));
            return true;
        }
        if (button == 1) {
            this.displayTagDialog(parent, index);
            return true;
        }
        if (carrying.m_41619_()) {
            return false;
        }
        ItemStack newFilter = carrying.m_41777_();
        newFilter.m_41764_(1);
        this.filterStacks.put(index, (Object)newFilter);
        this.filterTags.remove(index);
        this.sendMessageToServer(e -> e.writeCompoundNBT(this.writeExtraData(new CompoundTag())));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void displayTagDialog(GuiElement<?> parent, int index) {
        GuiTexture bg = GuiTexture.newDynamicTexture((int)148, (int)150, () -> BCGuiSprites.getThemed((String)"background_dynamic"));
        GuiPopUpDialogBase dialog = new GuiPopUpDialogBase(parent);
        dialog.setPosAndSize((GuiElement)bg);
        dialog.setDragBar(20);
        dialog.addChild((GuiElement)bg);
        GuiLabel heading = ((GuiLabel)((GuiLabel)((GuiLabel)bg.addChild((GuiElement)new GuiLabel((Component)new TranslatableComponent("module.draconicevolution.filtered_module.filter_by_tag")))).setRelPos((GuiElement)bg, 0, 5)).setSize(bg.xSize(), 9)).setTextColGetter(GuiToolkit.Palette.BG::text).setShadowStateSupplier(() -> BCConfig.darkMode);
        GuiTextField textField = ((GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)bg.addChild((GuiElement)new GuiTextField())).setPos(bg.xPos() + 5, heading.maxYPos() + 2)).setMaxXPos(bg.maxXPos() - 5, true)).setYSize(12)).setTextColor(GuiToolkit.Palette.Ctrl::text).setShadow(false).addBackground(GuiToolkit.Palette.Ctrl::fill, hovering -> GuiToolkit.Palette.Ctrl.accentLight((boolean)false)).setSuggestion(I18n.m_118938_((String)"module.draconicevolution.filtered_module.filter_example", (Object[])new Object[0]));
        GuiLabel matchingLabel = ((GuiLabel)((GuiLabel)((GuiLabel)bg.addChild((GuiElement)new GuiLabel(I18n.m_118938_((String)"module.draconicevolution.filtered_module.matching", (Object[])new Object[0])))).setPos(bg.xPos(), textField.maxYPos() + 6)).setSize(bg.xSize(), 9)).setTextColGetter(GuiToolkit.Palette.BG::text).setShadowStateSupplier(() -> BCConfig.darkMode);
        GuiBorderedRect matchContainer = ((GuiBorderedRect)((GuiBorderedRect)((GuiBorderedRect)bg.addChild((GuiElement)new GuiBorderedRect())).setPos(textField.xPos(), matchingLabel.maxYPos() + 2)).setMaxPos(textField.maxXPos(), bg.maxYPos() - 5, true)).setColours(GuiToolkit.Palette.Slot.fill(), GuiToolkit.Palette.Slot.accentDark(), GuiToolkit.Palette.Slot.accentLight());
        GuiSlideControl scrollBar = (GuiSlideControl)((GuiSlideControl)((GuiSlideControl)((GuiSlideControl)new GuiSlideControl(GuiSlideControl.SliderRotation.VERTICAL).setPos(matchContainer.maxXPos() - 11, matchContainer.yPos() + 1)).setMaxPos(matchContainer.maxXPos() - 1, matchContainer.maxYPos() - 1, true)).setBackgroundElement((GuiElement)GuiTexture.newDynamicTexture((Supplier)BCGuiSprites.themedGetter((String)"button_disabled"))).setSliderElement((GuiElement)GuiTexture.newDynamicTexture((Supplier)BCGuiSprites.themedGetter((String)"button_borderless"))).onReload(GuiSlideControl::updateElements)).setEnabledCallback(() -> true);
        GuiScrollElement scrollElement = ((GuiScrollElement)((GuiScrollElement)((GuiScrollElement)matchContainer.addChild((GuiElement)new GuiScrollElement())).setRelPos((GuiElement)matchContainer, 1, 1)).setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH).setMaxPos(matchContainer.maxXPos() - 11, matchContainer.maxYPos() - 2, true)).setVerticalScrollBar(scrollBar).setStandardScrollBehavior();
        ArrayList tagOps = new ArrayList();
        ItemStack filterStack = (ItemStack)this.filterStacks.getOrDefault((Object)index, (Object)ItemStack.f_41583_);
        if (!filterStack.m_41619_()) {
            tagOps.addAll(filterStack.m_204131_().toList());
        }
        if (!tagOps.isEmpty()) {
            GuiButton fromItemButton = (GuiButton)((GuiButton)((GuiButton)bg.addChild((GuiElement)new GuiButton(""))).setSize(12, 12)).setMaxPos(matchContainer.maxXPos(), matchContainer.yPos() - 1, false);
            ((GuiStackIcon)((GuiStackIcon)((GuiStackIcon)fromItemButton.addChild((GuiElement)new GuiStackIcon(filterStack))).setPosAndSize((GuiElement)fromItemButton)).setInsets(0, 0, 0, 0)).setHoverOverride(Collections.singletonList(new TranslatableComponent("module.draconicevolution.filtered_module.select_from_item")));
            fromItemButton.onPressed(() -> {
                scrollElement.clearElements();
                scrollElement.resetScrollPositions();
                matchingLabel.setLabelText(I18n.m_118938_((String)"module.draconicevolution.filtered_module.select_or_enter", (Object[])new Object[0]));
                for (TagKey tag : tagOps) {
                    GuiButton button = (GuiButton)((GuiButton)new GuiButton(tag.f_203868_().toString()).setYSize(12)).setRectFillColourGetter((hovering, disabled) -> GuiToolkit.Palette.Ctrl.fill((boolean)hovering)).setRectBorderColourGetter((hovering, disabled) -> 0).setHoverText(tag.f_203868_().toString());
                    scrollElement.addElement((GuiElement)button);
                    button.onPressed(() -> {
                        this.filterTags.remove(index);
                        textField.setValue(tag.f_203868_().toString());
                    });
                }
                scrollElement.reloadElement();
            });
        }
        textField.onValueChanged(s -> {
            ResourceLocation location = ResourceLocation.m_135820_((String)s);
            TagKey key = (TagKey)this.filterTags.get(index);
            if (s.isEmpty() && key == null) {
                return;
            }
            if (location == null && this.filterTags.containsKey(index)) {
                this.filterTags.remove(index);
                this.sendMessageToServer(e -> e.writeCompoundNBT(this.writeExtraData(new CompoundTag())));
                return;
            }
            if (location == null || key != null && location.equals((Object)key.f_203868_()) && !scrollElement.getScrollingElements().isEmpty()) {
                return;
            }
            key = ItemTags.create((ResourceLocation)location);
            ITagManager tags = ForgeRegistries.ITEMS.tags();
            if (tags == null) {
                return;
            }
            scrollElement.clearElements();
            scrollElement.resetScrollPositions();
            matchingLabel.setLabelText(I18n.m_118938_((String)"module.draconicevolution.filtered_module.matching", (Object[])new Object[0]));
            List matchingItems = tags.getTag(key).stream().toList();
            if (matchingItems.isEmpty()) {
                this.filterTags.remove(index);
                this.sendMessageToServer(e -> e.writeCompoundNBT(this.writeExtraData(new CompoundTag())));
                return;
            }
            GuiElement container = new GuiElement();
            for (int i = 0; i < matchingItems.size(); ++i) {
                Item item = (Item)matchingItems.get(i);
                GuiStackIcon icon = new GuiStackIcon(new ItemStack((ItemLike)item));
                icon.setPos(i % 7 * 18, i / 7 * 18);
                container.addChild((GuiElement)icon);
            }
            container.setBoundsToChildren();
            scrollElement.addElement(container);
            scrollElement.reloadElement();
            this.filterTags.put(index, (Object)key);
            this.sendMessageToServer(e -> e.writeCompoundNBT(this.writeExtraData(new CompoundTag())));
        });
        textField.onReturnPressed(() -> ((GuiPopUpDialogBase)dialog).close());
        dialog.showCenter((int)parent.getRenderZLevel() + 200);
        if (this.filterTags.containsKey(index)) {
            textField.setValue(((TagKey)this.filterTags.get(index)).f_203868_().toString());
        }
    }

    @Override
    public void handleClientMessage(MCDataInput input) {
        this.readExtraData(input.readCompoundNBT());
    }

    public boolean testStack(ItemStack stack) {
        if (!this.isEnabled()) {
            return false;
        }
        for (int i = 0; i < this.slotsCount; ++i) {
            Item item;
            TagKey key;
            if (!(this.filterTags.containsKey(i) ? stack.m_204117_(key = (TagKey)this.filterTags.get(i)) : this.filterStacks.containsKey(i) && stack.m_150930_(item = ((ItemStack)this.filterStacks.get(i)).m_41720_()))) continue;
            return true;
        }
        return false;
    }

    public Predicate<ItemStack> createFilterTest() {
        if (!this.isEnabled()) {
            return e -> false;
        }
        Predicate<ItemStack> filterTest = null;
        for (int i = 0; i < this.slotsCount; ++i) {
            Predicate<ItemStack> slotTest;
            if (this.filterTags.containsKey(i)) {
                TagKey key = (TagKey)this.filterTags.get(i);
                slotTest = e -> e.m_204117_(key);
            } else {
                if (!this.filterStacks.containsKey(i)) continue;
                Item item = ((ItemStack)this.filterStacks.get(i)).m_41720_();
                slotTest = e -> e.m_150930_(item);
            }
            filterTest = filterTest == null ? slotTest : filterTest.or(slotTest);
        }
        return filterTest == null ? e -> false : filterTest;
    }

    public boolean isEmpty() {
        return this.slotsCount == 0 || this.filterStacks.isEmpty() && this.filterTags.isEmpty();
    }

    public boolean isEnabled() {
        return this.filterEnabled == null || this.filterEnabled.getValue();
    }

    @Override
    protected CompoundTag writeExtraData(CompoundTag nbt) {
        super.writeExtraData(nbt);
        if (this.slotsCount == 0) {
            return nbt;
        }
        ListTag itemList = new ListTag();
        this.filterStacks.forEach((slot, stack) -> {
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("slot", (byte)slot.intValue());
            ((ItemStack)this.filterStacks.get(slot)).m_41739_(compoundtag);
            itemList.add((Object)compoundtag);
        });
        nbt.m_128365_("items", (Tag)itemList);
        ListTag tagList = new ListTag();
        this.filterTags.forEach((slot, key) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("slot", (byte)slot.intValue());
            tag.m_128359_("key", key.f_203868_().toString());
            tagList.add((Object)tag);
        });
        nbt.m_128365_("tags", (Tag)tagList);
        return nbt;
    }

    @Override
    protected void readExtraData(CompoundTag nbt) {
        super.readExtraData(nbt);
        if (this.slotsCount == 0) {
            return;
        }
        this.filterStacks.clear();
        this.filterTags.clear();
        ListTag itemList = nbt.m_128437_("items", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            CompoundTag compoundtag = itemList.m_128728_(i);
            byte slot = compoundtag.m_128445_("slot");
            if (slot < 0 || slot >= this.slotsCount) continue;
            this.filterStacks.put((int)slot, (Object)ItemStack.m_41712_((CompoundTag)compoundtag));
        }
        ListTag tagList = nbt.m_128437_("tags", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tag = tagList.m_128728_(i);
            byte slot = tag.m_128445_("slot");
            TagKey key = ItemTags.create((ResourceLocation)new ResourceLocation(tag.m_128461_("key")));
            if (slot < 0 || slot >= this.slotsCount) continue;
            this.filterTags.put((int)slot, (Object)key);
        }
    }

    protected record Slot(int index, double x, double y, double width, double height) {
        public boolean isInSlot(double testX, double textY) {
            return GuiHelper.isInRect((double)this.x, (double)this.y, (double)this.width, (double)this.height, (double)testX, (double)textY);
        }
    }
}

