/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.EnergyLinkData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class EnergyLinkEntity
extends ModuleEntity<EnergyLinkData> {
    private UUID linkId = null;
    private BlockPos corePos = null;
    private ResourceKey<Level> dimKey = null;
    private long linkCharge = 0L;
    private double flow = 0.0;
    private boolean coreEnergyLow = false;
    private BooleanProperty enabled = new BooleanProperty("energy_link_mod.enabled", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);

    public EnergyLinkEntity(Module<EnergyLinkData> module) {
        super(module);
        this.addProperty(this.enabled);
    }

    @Override
    public void tick(ModuleContext moduleContext) {
        TileEnergyCore core;
        IOPStorage storage;
        block15: {
            block14: {
                StackModuleContext context;
                block13: {
                    block12: {
                        if (this.linkId == null || this.dimKey == null || this.corePos == null) {
                            return;
                        }
                        storage = moduleContext.getOpStorage();
                        if (!(moduleContext instanceof StackModuleContext)) break block12;
                        context = (StackModuleContext)moduleContext;
                        if (storage != null) break block13;
                    }
                    return;
                }
                Level level = context.getEntity().f_19853_;
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                if (!level.m_46472_().equals(this.dimKey) && (level = serverLevel.m_142572_().m_129880_(this.dimKey)) == null) {
                    return;
                }
                if (!level.m_46749_(this.corePos)) {
                    return;
                }
                BlockEntity entity = level.m_7702_(this.corePos);
                if (!(entity instanceof TileEnergyCore)) break block14;
                core = (TileEnergyCore)entity;
                if (this.linkId.equals(core.linkUUID.get())) break block15;
            }
            this.clear();
            return;
        }
        if (!this.enabled.getValue()) {
            this.disconnect();
            return;
        }
        EnergyLinkData data = (EnergyLinkData)this.module.getData();
        if (!this.updateConnection(data, storage, core)) {
            return;
        }
        long inserted = core.energy.extractOP(storage.modifyEnergyStored(core.energy.extractOP(data.transferLimit(), true)), false);
        this.flow = MathHelper.approachExp((double)this.flow, (double)inserted, (double)0.05);
    }

    private boolean updateConnection(EnergyLinkData data, IOPStorage storage, TileEnergyCore core) {
        if (core.energy.getOPStored() < data.operationEnergy() * 20L) {
            this.coreEnergyLow = true;
            this.disconnect();
            return false;
        }
        this.coreEnergyLow = false;
        if (this.linkCharge < data.activationEnergy()) {
            long chargeRate = Math.max(1L, data.activationEnergy() / 600L);
            long remaining = data.activationEnergy() - this.linkCharge;
            this.linkCharge += storage.modifyEnergyStored(-Math.min(remaining, chargeRate));
            return false;
        }
        long maintenanceCost = (long)((double)data.operationEnergy() * 0.1 + (double)data.operationEnergy() * 0.9 * (this.flow / (double)data.transferLimit()));
        long extracted = core.energy.extractOP(maintenanceCost, false);
        if (extracted < maintenanceCost) {
            this.disconnect();
            return false;
        }
        return true;
    }

    private void disconnect() {
        this.linkCharge = 0L;
        this.flow = 0.0;
    }

    private void clear() {
        this.linkId = null;
        this.dimKey = null;
        this.corePos = null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, MultiBufferSource getter, PoseStack poseStack, int x, int y, int width, int height, double mouseX, double mouseY, boolean stackRender, float partialTicks) {
        super.renderModule(parent, getter, poseStack, x, y, width, height, mouseX, mouseY, stackRender, partialTicks);
        EnergyLinkData data = (EnergyLinkData)this.module.getData();
        if (this.linkCharge >= data.activationEnergy()) {
            return;
        }
        double progress = (double)this.linkCharge / (double)data.activationEnergy();
        String pText = (int)(progress * 100.0) + "%";
        this.drawChargeProgress(getter, poseStack, x, y, width, height, progress, pText, I18n.m_118938_((String)"module.draconicevolution.energy_link.charging", (Object[])new Object[0]) + StringUtils.repeat((String)".", (int)((int)(System.currentTimeMillis() / 500L % 4L))));
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.linkCharge = compound.m_128454_("link_charge");
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128356_("link_charge", this.linkCharge);
    }

    @Override
    protected void readExtraData(CompoundTag nbt) {
        super.readExtraData(nbt);
        if (nbt.m_128441_("link_id")) {
            this.linkId = nbt.m_128342_("link_id");
            this.corePos = new BlockPos(nbt.m_128451_("core_x"), nbt.m_128451_("core_y"), nbt.m_128451_("core_z"));
            this.dimKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dim")));
        }
    }

    @Override
    protected CompoundTag writeExtraData(CompoundTag nbt) {
        if (this.linkId != null) {
            nbt.m_128359_("dim", this.dimKey.m_135782_().toString());
            nbt.m_128405_("core_x", this.corePos.m_123341_());
            nbt.m_128405_("core_y", this.corePos.m_123342_());
            nbt.m_128405_("core_z", this.corePos.m_123343_());
            nbt.m_128362_("link_id", this.linkId);
        }
        return super.writeExtraData(nbt);
    }

    @Override
    public void addToolTip(List<Component> list) {
        if (this.linkId != null) {
            list.add((Component)new TranslatableComponent("module.draconicevolution.energy_link.linked_core").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_((Component)new TextComponent("X:" + this.corePos.m_123341_() + ", Y:" + this.corePos.m_123342_() + ", Z:" + this.corePos.m_123343_() + ", " + this.dimKey.m_135782_()).m_130940_(ChatFormatting.DARK_GREEN)));
        } else {
            list.add((Component)new TranslatableComponent("module.draconicevolution.energy_link.link_to_core").m_130940_(ChatFormatting.GRAY));
        }
    }
}

