/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.BCGuiSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.NoData;
import com.brandon3055.draconicevolution.api.modules.entities.FilteredModuleEntity;
import com.brandon3055.draconicevolution.client.DEMiscSprites;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnderCollectionEntity
extends FilteredModuleEntity<NoData> {
    private CompoundTag frequencyTag = new CompoundTag();

    public EnderCollectionEntity(Module<NoData> module) {
        super(module, module.getProperties().getTechLevel() == TechLevel.DRACONIC ? 9 : 0);
        this.addEnabledProperty("ender_collection_mod", false);
    }

    @Override
    protected List<FilteredModuleEntity.Slot> layoutSlots(int x, int y, int width, int height) {
        ArrayList<FilteredModuleEntity.Slot> slots = new ArrayList<FilteredModuleEntity.Slot>();
        double slotXSize = (double)width / 3.0;
        double slotYSize = (double)height / 3.0;
        for (int i = 0; i < this.slotsCount; ++i) {
            double xPos = (double)x + (double)(i % 3) * slotXSize;
            double yPos = (double)y + (double)(i / 3) * slotYSize;
            slots.add(new FilteredModuleEntity.Slot(i, xPos, yPos, slotXSize, slotYSize));
        }
        return slots;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected Material getSlotOverlay() {
        return BCGuiSprites.get((String)"slots/filter");
    }

    @Override
    protected void readExtraData(CompoundTag nbt) {
        super.readExtraData(nbt);
        this.frequencyTag = nbt.m_128469_("frequency");
    }

    @Override
    protected CompoundTag writeExtraData(CompoundTag nbt) {
        nbt.m_128365_("frequency", (Tag)this.frequencyTag);
        return super.writeExtraData(nbt);
    }

    public List<ItemStack> insertStacks(Player player, Collection<ItemStack> stacks, IOPStorage opStorage) {
        if (opStorage == null) {
            return new ArrayList<ItemStack>(stacks);
        }
        Object container = ModHelper.ENDERSTORAGE.isPresent() ? this.getEnderStorage(player) : player.m_36327_();
        Predicate<ItemStack> filter = null;
        if (!this.filterTags.isEmpty() || !this.filterStacks.isEmpty()) {
            filter = this.createFilterTest();
        }
        ArrayList<ItemStack> notInserted = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            long cost = (long)EquipCfg.enderModulePerItemEnergy * (long)stack.m_41613_();
            if (opStorage.getOPStored() < cost || filter != null && !filter.test(stack)) {
                notInserted.add(stack);
                continue;
            }
            opStorage.modifyEnergyStored(-cost);
            int remainder = InventoryUtils.insertItem((Container)container, (ItemStack)stack, (boolean)false);
            if (remainder <= 0) continue;
            stack.m_41764_(remainder);
            notInserted.add(stack);
        }
        return notInserted;
    }

    public int insertStack(Player player, ItemStack stack, IOPStorage opStorage) {
        Object container = ModHelper.ENDERSTORAGE.isPresent() ? this.getEnderStorage(player) : player.m_36327_();
        Predicate<ItemStack> filter = null;
        if (!this.filterTags.isEmpty() || !this.filterStacks.isEmpty()) {
            filter = this.createFilterTest();
        }
        long cost = (long)EquipCfg.enderModulePerItemEnergy * (long)stack.m_41613_();
        if (opStorage.getOPStored() < cost || filter != null && !filter.test(stack)) {
            return stack.m_41613_();
        }
        opStorage.modifyEnergyStored(-cost);
        return InventoryUtils.insertItem((Container)container, (ItemStack)stack, (boolean)false);
    }

    private Container getEnderStorage(Player player) {
        if (this.frequencyTag.m_128456_()) {
            return player.m_36327_();
        }
        Frequency frequency = new Frequency(this.frequencyTag);
        return (Container)EnderStorageManager.instance((boolean)false).getStorage(frequency, EnderItemStorage.TYPE);
    }

    private EnumColour[] getColours() {
        Frequency frequency = new Frequency(this.frequencyTag);
        return new EnumColour[]{frequency.getLeft(), frequency.getMiddle(), frequency.getRight()};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, MultiBufferSource getter, PoseStack poseStack, int x, int y, int width, int height, double mouseX, double mouseY, boolean renderStack, float partialTicks) {
        float alpha;
        super.renderModule(parent, getter, poseStack, x, y, width, height, mouseX, mouseY, renderStack, partialTicks);
        if (this.frequencyTag.m_128456_() || !ModHelper.ENDERSTORAGE.isPresent()) {
            return;
        }
        float dist = (float)GuiHelper.distToRect((double)x, (double)y, (double)width, (double)height, (double)GuiHelper.getMouseX(), (double)GuiHelper.getMouseY());
        float f = alpha = dist <= 10.0f ? dist / 10.0f : 1.0f;
        if (alpha == 0.0f) {
            return;
        }
        if (alpha != 1.0f) {
            poseStack.m_85837_(0.0, 0.0, 201.0);
        }
        double p = (double)width / 16.0;
        double w = p * 2.0;
        double h = p * 4.0;
        double mid = (double)x + (double)width / 2.0;
        double py = (double)y + (double)height / 2.0 - h / 2.0;
        EnumColour[] colours = this.getColours();
        Material mat = DEMiscSprites.getMat("enderstorage", "buttons");
        TransformingVertexConsumer builder = new TransformingVertexConsumer(getter.m_6299_(DEMiscSprites.GUI_TYPE), poseStack);
        double hp = 0.03125;
        for (int i = 0; i < 3; ++i) {
            double px = mid - w / 2.0 - p * 3.0 + (double)i * (p * 3.0);
            double u = hp * 3.0 + hp * 8.0 * (double)(colours[i].getWoolMeta() % 4);
            double v = hp * 2.0 + hp * 8.0 * (double)(colours[i].getWoolMeta() / 4);
            GuiHelper.drawPartialSprite((VertexConsumer)builder, (double)px, (double)py, (double)w, (double)h, (TextureAtlasSprite)mat.m_119204_(), (double)u, (double)v, (double)(u + hp * 2.0), (double)(v + hp * 4.0), (float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        RenderUtils.endBatch((MultiBufferSource)getter);
        if (alpha != 1.0f) {
            poseStack.m_85837_(0.0, 0.0, -201.0);
        }
    }
}

