/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.data;

import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.init.EquipCfg;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public record ShieldData(int shieldCapacity, double shieldRecharge) implements ModuleData<ShieldData>
{
    @Override
    public ShieldData combine(ShieldData other) {
        return new ShieldData(this.shieldCapacity + other.shieldCapacity, this.shieldRecharge + other.shieldRecharge);
    }

    @Override
    public void addInformation(Map<Component, Component> map, ModuleContext context, boolean stack) {
        if (this.shieldCapacity > 0) {
            map.put((Component)new TranslatableComponent("module.draconicevolution.shield_capacity.name"), (Component)new TranslatableComponent("module.draconicevolution.shield_capacity.value", new Object[]{this.shieldCapacity}));
        }
        if (this.shieldRecharge > 0.0) {
            map.put((Component)new TranslatableComponent("module.draconicevolution.shield_recharge.name"), (Component)new TranslatableComponent("module.draconicevolution.shield_recharge.value", new Object[]{ModuleData.round(this.shieldRecharge * 20.0, 10.0), ModuleData.round((double)this.shieldCapacity / this.shieldRecharge / 20.0, 10.0), (int)Math.max(this.shieldRecharge * (double)EquipCfg.energyShieldChg, (double)EquipCfg.energyShieldChg)}));
        }
        if (this.shieldCapacity > 0) {
            map.put((Component)new TranslatableComponent("module.draconicevolution.shield_passive.name"), (Component)new TranslatableComponent("module.draconicevolution.shield_passive.value", new Object[]{(double)Math.round((double)(this.shieldCapacity * this.shieldCapacity) * EquipCfg.shieldPassiveModifier * 10.0) / 10.0}));
        }
    }
}

